/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.ws;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.unifyconfig.config.RpcReportSampleConfigData;
import com.yy.appbase.unifyconfig.config.WsHttpDispatcherConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.StatInitDelegate;
import com.yy.base.utils.LowEndMachineOptUtil;
import com.yy.base.utils.SettingFlags;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.RpcRequestStrategy;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.Map;

public class WsStatusDelegate {
    private static final String TAG = "WsStatus";

    public static void init() {
        StatInitDelegate.init((StatInitDelegate.OnStat)new StatInitDelegate.OnStat(){

            public void onStat(HashMap<String, String> map, String act, boolean isAllReport) {
                WsStatusDelegate.stat(map, act, isAllReport);
            }

            public void onMetric(String uri, long time, String returnCode, HashMap<String, String> moreInfo, boolean isAllReport) {
                if (!LowEndMachineOptUtil.INSTANCE.getGraceNetSwitch()) {
                    return;
                }
                WsStatusDelegate.metric(uri, time, returnCode, moreInfo, isAllReport);
            }

            public boolean isStatSwitchOn(String sName, String methodOrUri) {
                if (!LowEndMachineOptUtil.INSTANCE.getGraceNetSwitch()) {
                    return false;
                }
                boolean isEnableReport = RpcReportSampleConfigData.enableReport(sName, methodOrUri);
                MLog.debug((Object)WsStatusDelegate.TAG, (String)("sname " + sName + " method " + methodOrUri + " isEnableReport " + isEnableReport), (Object[])new Object[0]);
                return isEnableReport;
            }
        });
        RpcRequestStrategy.setOnWsHttpPickConfig((RpcRequestStrategy.OnWsHttpDispatcherConfig)new RpcRequestStrategy.OnWsHttpDispatcherConfig(){
            private IAB mIAB = null;

            public Map<String, RpcRequestStrategy.RpcRequestStrategyType> getWsHttpConfigList() {
                return WsHttpDispatcherConfig.sWsHttpDispatcherConfigHashMap;
            }

            public int getWsMaxTaskCount() {
                return WsHttpDispatcherConfig.sMaxTaskCount;
            }

            public boolean enableWsHttpDispatcher() {
                boolean wsHttpMergeEnable = SettingFlags.getBoolean((String)"ws_http_merge", (boolean)true);
                if (wsHttpMergeEnable && this.mIAB == null) {
                    this.mIAB = NewABDefine.WS_HTTP_MERGE.getTest();
                }
                return wsHttpMergeEnable && (RuntimeContext.sIsDebuggable || NAB.B.equals(this.mIAB));
            }

            public String getABValue() {
                return this.mIAB != null ? this.mIAB.getHiidoValue() : null;
            }
        });
    }

    private static void stat(HashMap<String, String> statMap, String act, boolean isAllReport) {
        if (statMap == null) {
            return;
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("act", act);
        for (Map.Entry<String, String> entry : statMap.entrySet()) {
            statisContent.put(entry.getKey(), entry.getValue());
        }
        String value = statisContent.toString();
        MLog.debug((Object)TAG, (String)value, (Object[])new Object[0]);
        HiidoStatis.reportContent((StatisContent)statisContent);
    }

    private static void metric(String uri, long time, String returnCode, HashMap<String, String> moreInfo, boolean isAllReport) {
        MLog.debug((Object)TAG, (String)("metric uri " + uri + " net time " + time + " returnCode " + returnCode), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)uri, (long)time, (String)returnCode, moreInfo);
    }
}

