/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.wrap.post;

import com.yy.appbase.http.HttpUtil;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Should;
import com.yy.grace.Callback;
import com.yy.grace.Grace;
import com.yy.grace.MediaType;
import com.yy.grace.MultipartBody;
import com.yy.grace.RequestBody;
import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractPostFileBuilder {
    protected String mUrl;
    private final Map<String, String> mHeader = new HashMap<String, String>();
    private final List<MultipartBody.Part> mPartList = new ArrayList<MultipartBody.Part>();
    private long mConnectTimeout;
    private long mReadTimeout;
    private long mWriteTimeout;
    private Grace mGrace;

    public AbstractPostFileBuilder url(String url) {
        this.mUrl = url;
        return this;
    }

    public AbstractPostFileBuilder header(Map<String, String> header) {
        if (header != null) {
            this.mHeader.putAll(header);
        }
        return this;
    }

    public AbstractPostFileBuilder file(File file, String key, String fileName, String type2) {
        if (file != null) {
            this.mPartList.add(MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)type2), (File)file)));
        }
        return this;
    }

    public AbstractPostFileBuilder file(File file, String key) {
        if (file != null) {
            String fileName = file.getName();
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String type2 = fileNameMap.getContentTypeFor(fileName);
            this.mPartList.add(MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)type2), (File)file)));
        }
        return this;
    }

    public AbstractPostFileBuilder parts(String key, String value) {
        this.mPartList.add(MultipartBody.Part.createFormData((String)key, (String)value));
        return this;
    }

    public AbstractPostFileBuilder parts(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.parts(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public AbstractPostFileBuilder connectTimeout(long connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        return this;
    }

    public AbstractPostFileBuilder readTimeout(long readTimeout) {
        this.mReadTimeout = readTimeout;
        return this;
    }

    public AbstractPostFileBuilder writeTimeout(long writeTimeout) {
        this.mWriteTimeout = writeTimeout;
        return this;
    }

    public AbstractPostFileBuilder newGrace(Grace grace) {
        this.mGrace = grace;
        return this;
    }

    public AbstractPostFileBuilder execute(Callback<String> callback) {
        if (StringUtils.isEmpty((String)this.mUrl)) {
            Should.fail((String)"\u8bf7\u6c42\u7684Url\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        HttpUtil.uploadFile(this.mGrace, this.mUrl, this.mConnectTimeout, this.mReadTimeout, this.mWriteTimeout, this.mHeader, this.mPartList, callback);
        return this;
    }
}

