/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.dns;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.dns.DnsHardCodeUtils;
import com.yy.appbase.http.dns.GSLBDnsExecutor;
import com.yy.appbase.http.dns.HTTPDnsUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.guid.IGuid;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.dns.DnsConfigData;
import com.yy.grace.dns.DnsLookupResult;
import com.yy.grace.dns.DnsSetupData;
import com.yy.grace.dns.HTTPHostResolver;
import com.yy.grace.dns.HTTPHostResolverDelegate;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001a\u001a\u00020\u0004J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u00020\bH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0006\u0010\"\u001a\u00020\u0017J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010!\u001a\u00020\u0004J \u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00042\u000e\u0010'\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020\u001f2\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00100\u001a\u00020\u001f2\b\u0010.\u001a\u0004\u0018\u00010\u0004J\u0010\u00101\u001a\u00020\u001f2\b\u00102\u001a\u0004\u0018\u00010\u000eJ\u0010\u00103\u001a\u00020\u001f2\b\u00104\u001a\u0004\u0018\u00010\u0004J\u0012\u00105\u001a\u00020\u001f2\b\u00106\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/yy/appbase/http/dns/HTTPDnsUtils;", "Lcom/yy/grace/dns/HTTPHostResolverDelegate;", "()V", "AccountID", "", "PRE_HOST_JSON_CONFIG", "TAG", "mConfigData", "Lcom/yy/grace/dns/DnsConfigData;", "getMConfigData", "()Lcom/yy/grace/dns/DnsConfigData;", "mConfigData$delegate", "Lkotlin/Lazy;", "mDnsMonitorCallBack", "Lcom/yy/appbase/http/dns/HTTPDnsUtils$IHttpDnsMonitorCallBack;", "mGSLBMatchMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "mGSLBMissMap", "mGslbExecutor", "Lcom/yy/appbase/http/dns/GSLBDnsExecutor;", "mInit", "", "mLastConfigString", "mLastPreResolveString", "getAccountID", "getDns", "Lcom/yy/grace/dns/HTTPHostResolver;", "getDnsConfig", "init", "", "isResolveIgnore", "host", "isSmartResolveEnable", "lookupAsString", "", "onLogMessage", "message", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onResultReport", "result", "Lcom/yy/grace/dns/DnsLookupResult;", "parseConfigData", "configString", "reportMonitorCallBack", "setDnsConfig", "setDnsMonitorCallBack", "callBack", "setPreResolveHostConfig", "preResolveHostString", "updatePreResolveHostToResolver", "preResolveString", "IHttpDnsMonitorCallBack", "appbase_debug"})
public final class HTTPDnsUtils
implements HTTPHostResolverDelegate {
    private static final String TAG = "HttpDnsUtils";
    private static final String AccountID = "8bef39f3-2607-4ff9-80b7-82595c754ac8";
    private static final String PRE_HOST_JSON_CONFIG = "pre_host_json_config";
    private static boolean mInit;
    private static volatile String mLastPreResolveString;
    private static volatile String mLastConfigString;
    private static final Lazy mConfigData$delegate;
    private static final HashMap<String, Integer> mGSLBMatchMap;
    private static final HashMap<String, Integer> mGSLBMissMap;
    private static volatile IHttpDnsMonitorCallBack mDnsMonitorCallBack;
    private static final GSLBDnsExecutor mGslbExecutor;
    public static final HTTPDnsUtils INSTANCE;

    private final DnsConfigData getMConfigData() {
        Lazy lazy = mConfigData$delegate;
        HTTPDnsUtils hTTPDnsUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DnsConfigData)lazy.getValue();
    }

    @NotNull
    public DnsConfigData getDnsConfig() {
        return this.getMConfigData();
    }

    public boolean isResolveIgnore(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return !UriProvider.inUseDnsHostList(host);
    }

    public void onLogMessage(@NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (exception == null) {
            MLog.info((Object)TAG, (String)message, (Object[])new Object[0]);
        } else {
            MLog.error((Object)TAG, (String)message, (Throwable)exception, (Object[])new Object[0]);
        }
    }

    public void onResultReport(@NotNull DnsLookupResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        YYTaskExecutor.execute((Runnable)new Runnable(result){
            final /* synthetic */ DnsLookupResult $result;

            public final void run() {
                if (this.$result.getFrom() == 1) {
                    Map map = this.$result.getMetricMap();
                    if (map != null) {
                        String dataSource;
                        Map map2 = map;
                        boolean bl = false;
                        boolean bl2 = false;
                        Map it = map2;
                        boolean bl3 = false;
                        HashMap<K, V> reportMap = new HashMap<K, V>();
                        Map map3 = reportMap;
                        String string2 = (String)it.get("serverid");
                        if (string2 == null) {
                            string2 = "";
                        }
                        map3.put("serverid", string2);
                        ((Map)reportMap).put("uid", String.valueOf(AccountUtil.getUid()));
                        String string3 = (String)it.get("source");
                        if (string3 == null) {
                            string3 = dataSource = "";
                        }
                        if (this.$result.isSuccess()) {
                            HiidoStatis.reportAppMonitorReturnCode((String)("gslb" + '/' + dataSource), (long)this.$result.getDuration(), (String)"0", (Map)reportMap);
                        } else {
                            reportMap.putAll(it);
                            String string4 = "gslb" + '/' + dataSource;
                            long l = this.$result.getDuration();
                            String string5 = (String)it.get("errcode");
                            if (string5 == null) {
                                string5 = "1";
                            }
                            HiidoStatis.reportAppMonitorReturnCode((String)string4, (long)l, (String)string5, (Map)reportMap);
                        }
                    }
                } else if (this.$result.getFrom() == 0 && SettingFlags.getBoolean((String)"collecttemporarydata", (boolean)false)) {
                    List<String> hardCodeList = DnsHardCodeUtils.INSTANCE.getDefaultIPList(this.$result.getHost());
                    Collection collection = hardCodeList;
                    boolean bl = false;
                    boolean bl4 = false;
                    if (!(collection == null || collection.isEmpty()) && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        StatisContent statContent = new StatisContent();
                        statContent.put("act", "hagoperf");
                        statContent.put("sfield", this.$result.getHost());
                        IGuid iGuid = GuidFactory.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iGuid, (String)"GuidFactory.getInstance()");
                        statContent.put("sfieldtwo", iGuid.getGuid());
                        statContent.put("perftype", "dnshard");
                        HiidoStatis.reportContent((StatisContent)statContent);
                    }
                }
                HTTPDnsUtils.access$reportMonitorCallBack(HTTPDnsUtils.INSTANCE, this.$result);
            }
            {
                this.$result = dnsLookupResult;
            }
        });
    }

    public final synchronized void init() {
        MLog.debug((Object)TAG, (String)"init", (Object[])new Object[0]);
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        DnsSetupData dnsSetupData = new DnsSetupData();
        Context context2 = context;
        HTTPHostResolver hTTPHostResolver = HTTPHostResolver.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        DnsSetupData $this$apply = dnsSetupData;
        boolean bl3 = false;
        $this$apply.setAccountId(AccountID);
        $this$apply.setCountry(SystemUtils.getHagoCountry());
        $this$apply.setDeviceId(GuidFactory.getInstance().getGuid());
        $this$apply.setLogEnable(RuntimeContext.sIsDebuggable);
        $this$apply.setTaskExecutor((ThreadPoolMgr.ITaskExecutor)mGslbExecutor);
        DnsSetupData dnsSetupData2 = dnsSetupData;
        hTTPHostResolver.init(context2, dnsSetupData2, (HTTPHostResolverDelegate)this);
        this.updatePreResolveHostToResolver(mLastPreResolveString);
        mInit = true;
    }

    @Nullable
    public final synchronized HTTPHostResolver getDns() {
        HTTPHostResolver hTTPHostResolver;
        if (!mInit) {
            this.init();
        }
        if (this.isSmartResolveEnable()) {
            hTTPHostResolver = HTTPHostResolver.INSTANCE;
        } else {
            MLog.debug((Object)TAG, (String)"getDns null, not enable", (Object[])new Object[0]);
            hTTPHostResolver = null;
        }
        return hTTPHostResolver;
    }

    public final boolean isSmartResolveEnable() {
        return this.getDnsConfig().getGslbEnable();
    }

    @NotNull
    public final String getAccountID() {
        return AccountID;
    }

    public final synchronized void setPreResolveHostConfig(@Nullable String preResolveHostString) {
        if (Intrinsics.areEqual((Object)mLastPreResolveString, (Object)preResolveHostString)) {
            MLog.debug((Object)TAG, (String)"setPreResolveHostConfig ignore, preResolveString is same", (Object[])new Object[0]);
            return;
        }
        mLastPreResolveString = preResolveHostString;
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(preResolveHostString){
            final /* synthetic */ String $preResolveHostString;

            public final void run() {
                MLog.debug((Object)"HttpDnsUtils", (String)("setPreResolveHostConfig save to file: " + this.$preResolveHostString), (Object[])new Object[0]);
                FileStorageUtils.getInstance().saveToFile(true, this.$preResolveHostString, "pre_host_json_config");
            }
            {
                this.$preResolveHostString = string2;
            }
        });
        if (mInit) {
            this.updatePreResolveHostToResolver(preResolveHostString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> lookupAsString(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        HTTPDnsUtils hTTPDnsUtils = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (hTTPDnsUtils) {
            boolean bl3 = false;
            if (!mInit) {
                INSTANCE.init();
            }
            Unit unit = Unit.INSTANCE;
        }
        return HTTPHostResolver.INSTANCE.lookupAsString(host);
    }

    private final void updatePreResolveHostToResolver(String preResolveString) {
        MLog.debug((Object)TAG, (String)("updatePreResolveHostToResolver: " + preResolveString), (Object[])new Object[0]);
        CharSequence charSequence = preResolveString;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(preResolveString){
            final /* synthetic */ String $preResolveString;

            public final void run() {
                try {
                    List hostList = (List)JsonParser.parseJsonObject((String)this.$preResolveString, List.class);
                    ArrayList<E> preResolveList = new ArrayList<E>(UriProvider.getNeedUseHostList());
                    List list = hostList;
                    if (list == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                    }
                    preResolveList.addAll(list);
                    HTTPHostResolver.INSTANCE.setPreResolveHosts((List)preResolveList);
                }
                catch (Exception ex) {
                    MLog.error((Object)"HttpDnsUtils", (String)"updatePreResolveHostToInterceptor error", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            {
                this.$preResolveString = string2;
            }
        });
    }

    public final synchronized void setDnsConfig(@Nullable String configString) {
        if (Intrinsics.areEqual((Object)mLastConfigString, (Object)configString)) {
            MLog.debug((Object)TAG, (String)"setDnsConfig ignore, configString is same", (Object[])new Object[0]);
            return;
        }
        mLastConfigString = configString;
        this.parseConfigData(configString);
    }

    public final synchronized void setDnsMonitorCallBack(@Nullable IHttpDnsMonitorCallBack callBack) {
        block2: {
            block3: {
                MLog.debug((Object)TAG, (String)("setDnsMonitorCallBack callBack is null: " + (callBack == null)), (Object[])new Object[0]);
                mDnsMonitorCallBack = callBack;
                if (callBack == null) break block2;
                Map map = mGSLBMatchMap;
                boolean bl = false;
                if (!map.isEmpty()) break block3;
                map = mGSLBMissMap;
                bl = false;
                if (!(!map.isEmpty())) break block2;
            }
            MLog.debug((Object)TAG, (String)("callback monitor success size: " + mGSLBMatchMap.size() + ", fail size: " + mGSLBMissMap.size()), (Object[])new Object[0]);
            callBack.onMonitor(MapsKt.toMap((Map)mGSLBMatchMap), MapsKt.toMap((Map)mGSLBMissMap));
            mGSLBMatchMap.clear();
            mGSLBMissMap.clear();
        }
    }

    private final synchronized void reportMonitorCallBack(DnsLookupResult result) {
        MLog.debug((Object)TAG, (String)("reportMonitorCallBack callback is null: " + (mDnsMonitorCallBack == null)), (Object[])new Object[0]);
        if (mDnsMonitorCallBack != null) {
            int n;
            if (result.getFrom() == 1) {
                List list = result.getIpList();
                n = list != null ? list.size() : 0;
            } else {
                n = 0;
            }
            int ipSize = n;
            IHttpDnsMonitorCallBack iHttpDnsMonitorCallBack = mDnsMonitorCallBack;
            if (iHttpDnsMonitorCallBack != null) {
                iHttpDnsMonitorCallBack.onMonitor(result.getHost(), ipSize);
            }
        } else if (result.getFrom() == 1 && result.isSuccess()) {
            Integer n = mGSLBMatchMap.get(result.getHost());
            if (n == null) {
                n = 0;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mGSLBMatchMap[result.host] ?: 0");
            int count = n;
            ((Map)mGSLBMatchMap).put(result.getHost(), ++count);
        } else {
            Integer n = mGSLBMissMap.get(result.getHost());
            if (n == null) {
                n = 0;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mGSLBMissMap[result.host] ?: 0");
            int count = n;
            ((Map)mGSLBMissMap).put(result.getHost(), ++count);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseConfigData(String configString) {
        MLog.debug((Object)TAG, (String)("parseConfigData: " + configString), (Object[])new Object[0]);
        DnsConfigData configData2 = this.getDnsConfig();
        CharSequence charSequence = configString;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                JSONObject json = JsonParser.obtainJSONObject((String)configString);
                configData2.setGslbEnable(json.optInt("gslb_enable", 1) == 1);
                SettingFlags.setBoolean((String)"usesmartdns", (boolean)configData2.getGslbEnable());
                configData2.setGslbDelay(json.optLong("gslb_delay", configData2.getGslbDelay()));
                SettingFlags.setLongValue((String)"gslb_allow_consume_duration", (long)configData2.getGslbDelay());
                configData2.setUseHttps(json.optInt("use_https", 1) == 1);
                SettingFlags.setBoolean((String)"glsb_https", (boolean)configData2.getUseHttps());
                configData2.setForceGslbRefresh(json.optInt("force_refresh", 0) == 1);
                SettingFlags.setBoolean((String)"gslb_force_refresh", (boolean)configData2.getForceGslbRefresh());
                configData2.setUseGslbLocal(json.optInt("use_local", 1) == 1);
                SettingFlags.setBoolean((String)"gslb_local_dns", (boolean)configData2.getUseGslbLocal());
                Iterator iterator2 = json.keys();
                HashMap<String, List<String>> hardcodeMap = new HashMap<String, List<String>>();
                hardcodeMap.putAll(DnsHardCodeUtils.INSTANCE.getDefaultMap());
                configData2.setHardcodeMap((Map)hardcodeMap);
                while (iterator2.hasNext()) {
                    String host = (String)iterator2.next();
                    JSONArray array = json.optJSONArray(host);
                    if (array == null) continue;
                    int n = 0;
                    List ipList = new ArrayList();
                    n = 0;
                    int n2 = array.length();
                    while (n < n2) {
                        void i;
                        if (array.optString((int)i) != null) {
                            String string2;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            String it = string2;
                            boolean bl5 = false;
                            CharSequence charSequence2 = it;
                            boolean bl6 = false;
                            if (charSequence2.length() > 0) {
                                ipList.add(it);
                            }
                        }
                        ++i;
                    }
                    Map map = hardcodeMap;
                    String string3 = host;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"host");
                    map.put(string3, ipList);
                }
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"parseConfigData error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private HTTPDnsUtils() {
    }

    static {
        HTTPDnsUtils hTTPDnsUtils;
        INSTANCE = hTTPDnsUtils = new HTTPDnsUtils();
        mConfigData$delegate = LazyKt.lazy((Function0)mConfigData.2.INSTANCE);
        mGSLBMatchMap = new HashMap();
        mGSLBMissMap = new HashMap();
        mGslbExecutor = new GSLBDnsExecutor();
        YYTaskExecutor.execute((Runnable)1.INSTANCE);
    }

    public static final /* synthetic */ void access$reportMonitorCallBack(HTTPDnsUtils $this, DnsLookupResult result) {
        $this.reportMonitorCallBack(result);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J0\u0010\u0002\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\tH&\u00a8\u0006\u000b"}, d2={"Lcom/yy/appbase/http/dns/HTTPDnsUtils$IHttpDnsMonitorCallBack;", "", "onMonitor", "", "hostname", "", "ips", "", "hostWithIp", "", "hostNoIp", "appbase_debug"})
    public static interface IHttpDnsMonitorCallBack {
        public void onMonitor(@NotNull String var1, int var2);

        public void onMonitor(@NotNull Map<String, Integer> var1, @NotNull Map<String, Integer> var2);
    }
}

