/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.dns;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class GSLBDnsExecutor
implements ThreadPoolMgr.ITaskExecutor {
    private static final String Tag = "GSLBDnsExecutor";
    private static int MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() >= 4 ? 12 : 8;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private ArrayList<GSLBDnsRunnable> mRunnablesToPost = new ArrayList(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(Runnable task2) {
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            this.mRunnablesToPost.add(new GSLBDnsRunnable(task2));
        }
        this.executeNext();
        return true;
    }

    private void onTaskFinished(GSLBDnsRunnable runnable) {
        this.mCurrentActiveTasks.decrementAndGet();
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        GSLBDnsRunnable myRunnable = null;
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            if (this.mRunnablesToPost.size() > 0 && this.mCurrentActiveTasks.get() < MAX_CONCURRENCY_TASKS) {
                myRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                if (myRunnable != null) {
                    this.mCurrentActiveTasks.incrementAndGet();
                }
            }
        }
        if (myRunnable != null) {
            YYTaskExecutor.execute(myRunnable);
        }
    }

    public int getPoolSize() {
        return 20;
    }

    public int getActiveCount() {
        return this.mCurrentActiveTasks.get();
    }

    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminated() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(long timeoutMs) {
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            this.mRunnablesToPost.clear();
        }
    }

    private class GSLBDnsRunnable
    implements Runnable {
        private Runnable mRunnable;

        public GSLBDnsRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    GSLBDnsExecutor.this.onTaskFinished(this);
                    if (!RuntimeContext.sIsDebuggable || this.mRunnable == null) break block6;
                    GSLBDnsExecutor gSLBDnsExecutor = GSLBDnsExecutor.this;
                    synchronized (gSLBDnsExecutor) {
                        MLog.info((Object)GSLBDnsExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + GSLBDnsExecutor.this.mRunnablesToPost.size()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    GSLBDnsExecutor.this.onTaskFinished(this);
                    MLog.info((Object)GSLBDnsExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + " error:" + throwable), (Object[])new Object[0]);
                    throw throwable;
                }
            }
        }
    }
}

