/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.growth;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import androidx.lifecycle.Observer;
import com.yy.appbase.common.Callback;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.growth.AbsExperimentCreator;
import com.yy.appbase.growth.BaseGrowth;
import com.yy.appbase.growth.GrowthExperimentController;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.IMainPageState;
import com.yy.appbase.service.home.PageType;
import com.yy.appbase.service.home.PlayTabData;
import com.yy.appbase.service.home.PlayTabType;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u00020\fH\u0004J\b\u0010!\u001a\u00020\fH\u0004J\b\u0010\"\u001a\u00020\fH\u0004J\b\u0010#\u001a\u00020\fH\u0004J\b\u0010$\u001a\u00020\fH\u0004J\b\u0010%\u001a\u00020\fH\u0004J\b\u0010&\u001a\u00020\fH\u0004J\b\u0010'\u001a\u00020\fH\u0004J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020\fJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H&J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010.\u001a\u00020/H&J\u0010\u00102\u001a\u00020-2\u0006\u00103\u001a\u000204H&J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0003J0\u00105\u001a\u00020-2\b\u00108\u001a\u0004\u0018\u00010*2\b\u00109\u001a\u0004\u0018\u00010*2\b\u0010:\u001a\u0004\u0018\u00010\n2\b\u0010;\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010<\u001a\u00020-H$J0\u0010=\u001a\u00020-2\b\u00108\u001a\u0004\u0018\u00010*2\b\u00109\u001a\u0004\u0018\u00010*2\b\u0010:\u001a\u0004\u0018\u00010>2\b\u0010;\u001a\u0004\u0018\u00010>H\u0014J\u0006\u0010?\u001a\u00020-J\b\u0010@\u001a\u00020-H\u0004J\u0010\u0010A\u001a\u00020\u00002\b\u0010B\u001a\u0004\u0018\u00010\u0006J\u000e\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020\bJ\u000e\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020\fJ\b\u0010G\u001a\u00020-H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/yy/appbase/growth/AbsExperiment;", "Lcom/yy/appbase/growth/BaseGrowth;", "()V", "kvoBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "mController", "Lcom/yy/appbase/growth/GrowthExperimentController;", "mCreator", "Lcom/yy/appbase/growth/AbsExperimentCreator;", "mLastPlayTab", "Lcom/yy/appbase/service/home/PlayTabType;", "mMock", "", "mWindowChangeListener", "Lcom/yy/appbase/growth/AbsExperiment$WindowPageChangeListener;", "getMWindowChangeListener", "()Lcom/yy/appbase/growth/AbsExperiment$WindowPageChangeListener;", "mWindowChangeListener$delegate", "Lkotlin/Lazy;", "playTabData", "Lcom/yy/appbase/service/home/PlayTabData;", "getActivity", "Landroid/app/Activity;", "getContext", "Landroid/content/Context;", "getController", "getCurrentWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "getDialogLinkManager", "Lcom/yy/framework/core/ui/dialog/frame/DialogLinkManager;", "getWindowManager", "Lcom/yy/framework/core/ui/AbstractWindowManager;", "isHome", "isHomeBbs", "isHomeChannel", "isHomeChat", "isHomeGame", "isHomeLive", "isHomeMine", "isHomeParty", "isHomeTargetTab", "tabName", "", "isMock", "onMessage", "", "msg", "Landroid/os/Message;", "onMessageSync", "", "onNotify", "notification", "Lcom/yy/framework/core/Notification;", "onPlayTabChanged", "data", "Lcom/yy/base/event/kvo/KvoEventIntent;", "lastWindow", "newWindow", "lastPage", "newPage", "onRecycle", "onWindowPageChanged", "Lcom/yy/appbase/service/home/PageType;", "recycle", "registerWindowChange", "setController", "controller", "setCreator", "creator", "setMock", "mock", "unregisterWindowChange", "WindowPageChangeListener", "appbase_debug"})
public abstract class AbsExperiment
extends BaseGrowth {
    private GrowthExperimentController mController;
    private AbsExperimentCreator mCreator;
    private final Lazy mWindowChangeListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WindowPageChangeListener>(this){
        final /* synthetic */ AbsExperiment this$0;

        @NotNull
        public final WindowPageChangeListener invoke() {
            return new WindowPageChangeListener(this.this$0);
        }
        {
            this.this$0 = absExperiment;
            super(0);
        }
    }));
    private boolean mMock;
    private PlayTabData playTabData;
    private final KvoBinder kvoBinder = new KvoBinder((Object)this);
    private PlayTabType mLastPlayTab;

    private final WindowPageChangeListener getMWindowChangeListener() {
        Lazy lazy = this.mWindowChangeListener$delegate;
        AbsExperiment absExperiment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (WindowPageChangeListener)lazy.getValue();
    }

    public abstract void onNotify(@NotNull Notification var1);

    public abstract void onMessage(@NotNull Message var1);

    @Nullable
    public abstract Object onMessageSync(@NotNull Message var1);

    protected abstract void onRecycle();

    public final void setMock(boolean mock) {
        MLog.debug((Object)this.getMTag(), (String)("setMock: " + mock), (Object[])new Object[0]);
        this.mMock = mock;
    }

    public final boolean isMock() {
        return this.mMock && RuntimeContext.isLocalBuild() && RuntimeContext.sIsDebuggable;
    }

    public final void setCreator(@NotNull AbsExperimentCreator creator) {
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        this.mCreator = creator;
    }

    public final void recycle() {
        MLog.info((Object)this.getMTag(), (String)"recycle experiment", (Object[])new Object[0]);
        AbsExperimentCreator absExperimentCreator = this.mCreator;
        if (absExperimentCreator != null) {
            absExperimentCreator.recycle();
        }
        this.onRecycle();
    }

    @NotNull
    public final AbsExperiment setController(@Nullable GrowthExperimentController controller) {
        this.mController = controller;
        return this;
    }

    @Nullable
    public final GrowthExperimentController getController() {
        return this.mController;
    }

    @NotNull
    public final Context getContext() {
        GrowthExperimentController growthExperimentController = this.mController;
        if (growthExperimentController == null || (growthExperimentController = growthExperimentController.getEnvironment()) == null || (growthExperimentController = growthExperimentController.getContext()) == null) {
            Context context = RuntimeContext.sApplicationContext;
            growthExperimentController = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        }
        return growthExperimentController;
    }

    @Nullable
    public final Activity getActivity() {
        GrowthExperimentController growthExperimentController = this.mController;
        Context context = growthExperimentController != null && (growthExperimentController = growthExperimentController.getEnvironment()) != null ? growthExperimentController.getContext() : null;
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        return (Activity)context;
    }

    @Nullable
    public final AbstractWindow getCurrentWindow() {
        GrowthExperimentController growthExperimentController = this.mController;
        return growthExperimentController != null && (growthExperimentController = growthExperimentController.getEnvironment()) != null && (growthExperimentController = growthExperimentController.getWindowManager()) != null ? growthExperimentController.getCurrentWindow() : null;
    }

    @Nullable
    public final DialogLinkManager getDialogLinkManager() {
        GrowthExperimentController growthExperimentController = this.mController;
        return growthExperimentController != null ? growthExperimentController.getDialogLinkManager() : null;
    }

    @Nullable
    public final AbstractWindowManager getWindowManager() {
        GrowthExperimentController growthExperimentController = this.mController;
        return growthExperimentController != null && (growthExperimentController = growthExperimentController.getEnvironment()) != null ? growthExperimentController.getWindowManager() : null;
    }

    private final boolean isHomeTargetTab(String tabName) {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        return Intrinsics.areEqual((Object)WindowNameDef.getNewNameIfHomeTab(abstractWindow != null ? abstractWindow.getName() : null), (Object)tabName);
    }

    protected final boolean isHome() {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        return WindowNameDef.isHomePage(abstractWindow != null ? abstractWindow.getName() : null);
    }

    protected final boolean isHomeGame() {
        return this.isHomeTargetTab("HomePageNew#Play") && (this.mLastPlayTab == PlayTabType.TODAY || this.mLastPlayTab == PlayTabType.GAME);
    }

    protected final boolean isHomeBbs() {
        return this.isHomeTargetTab("HomePageNew#Disccover");
    }

    protected final boolean isHomeChannel() {
        return this.isHomeParty() || this.isHomeLive() || this.isHomeTargetTab("HomePageNew#Channel");
    }

    protected final boolean isHomeParty() {
        return this.isHomeTargetTab("HomePageNew#Play") && this.mLastPlayTab == PlayTabType.PARTY;
    }

    protected final boolean isHomeLive() {
        return this.isHomeTargetTab("HomePageNew#Play") && this.mLastPlayTab == PlayTabType.LIVE;
    }

    protected final boolean isHomeChat() {
        return this.isHomeTargetTab("HomePageNew#Chat");
    }

    protected final boolean isHomeMine() {
        return this.isHomeTargetTab("HomePageNew#Mine");
    }

    protected final void registerWindowChange() {
        block0: {
            MLog.debug((Object)this.getMTag(), (String)"registerWindowChange", (Object[])new Object[0]);
            DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.getMWindowChangeListener());
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null) break block0;
            iServiceManager.observeService(IHomeService.class, new Callback<IHomeService>(this){
                final /* synthetic */ AbsExperiment this$0;

                public final void onResponse(IHomeService homeService) {
                    homeService.currentPageState().observeForever((Observer)AbsExperiment.access$getMWindowChangeListener$p(this.this$0));
                    AbsExperiment.access$setPlayTabData$p(this.this$0, homeService.getPlayData());
                    if (AbsExperiment.access$getPlayTabData$p(this.this$0) != null) {
                        AbsExperiment.access$getKvoBinder$p(this.this$0).singleBindSourceTo((KvoSource)AbsExperiment.access$getPlayTabData$p(this.this$0));
                    }
                }
                {
                    this.this$0 = absExperiment;
                }
            });
        }
    }

    protected final void unregisterWindowChange() {
        MLog.debug((Object)this.getMTag(), (String)"unregisterWindowChange", (Object[])new Object[0]);
        DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.getMWindowChangeListener());
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager != null) {
            iServiceManager.observeService(IHomeService.class, new Callback<IHomeService>(this){
                final /* synthetic */ AbsExperiment this$0;

                public final void onResponse(IHomeService homeService) {
                    homeService.currentPageState().removeObserver((Observer)AbsExperiment.access$getMWindowChangeListener$p(this.this$0));
                }
                {
                    this.this$0 = absExperiment;
                }
            });
        }
        if (this.playTabData != null) {
            this.kvoBinder.clearAllKvoConnections();
        }
    }

    @KvoMethodAnnotation(name="tab", sourceClass=PlayTabData.class)
    private final void onPlayTabChanged(KvoEventIntent data2) {
        PlayTabType tab = ((PlayTabData)data2.source()).getTab();
        if (tab != null) {
            String window = this.getMWindowChangeListener().getMLastWindow();
            this.onPlayTabChanged(window, window, this.mLastPlayTab, tab);
            this.mLastPlayTab = tab;
        }
    }

    protected void onPlayTabChanged(@Nullable String lastWindow, @Nullable String newWindow, @Nullable PlayTabType lastPage, @Nullable PlayTabType newPage) {
        MLog.debug((Object)this.getMTag(), (String)("onPlayTabChanged lastW: " + lastWindow + ", newW: " + newWindow + ", lastP: " + (Object)((Object)lastPage) + ", newP: " + (Object)((Object)newPage)), (Object[])new Object[0]);
    }

    protected void onWindowPageChanged(@Nullable String lastWindow, @Nullable String newWindow, @Nullable PageType lastPage, @Nullable PageType newPage) {
        MLog.debug((Object)this.getMTag(), (String)("onWindowPageChanged lastW: " + lastWindow + ", newW: " + newWindow + ", lastP: " + (Object)((Object)lastPage) + ", newP: " + (Object)((Object)newPage)), (Object[])new Object[0]);
    }

    public static final /* synthetic */ WindowPageChangeListener access$getMWindowChangeListener$p(AbsExperiment $this) {
        return $this.getMWindowChangeListener();
    }

    public static final /* synthetic */ PlayTabData access$getPlayTabData$p(AbsExperiment $this) {
        return $this.playTabData;
    }

    public static final /* synthetic */ void access$setPlayTabData$p(AbsExperiment $this, PlayTabData playTabData) {
        $this.playTabData = playTabData;
    }

    public static final /* synthetic */ KvoBinder access$getKvoBinder$p(AbsExperiment $this) {
        return $this.kvoBinder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/yy/appbase/growth/AbsExperiment$WindowPageChangeListener;", "Lcom/yy/framework/core/ui/DefaultWindow$IGlobalWindowMonitor;", "Landroidx/lifecycle/Observer;", "Lcom/yy/appbase/service/home/IMainPageState;", "mExperiment", "Lcom/yy/appbase/growth/AbsExperiment;", "(Lcom/yy/appbase/growth/AbsExperiment;)V", "mLastMainPage", "Lcom/yy/appbase/service/home/PageType;", "mLastWindow", "", "getMLastWindow", "()Ljava/lang/String;", "setMLastWindow", "(Ljava/lang/String;)V", "onChanged", "", "pageState", "onShown", "window", "Lcom/yy/framework/core/ui/DefaultWindow;", "appbase_debug"})
    public static final class WindowPageChangeListener
    implements DefaultWindow.IGlobalWindowMonitor,
    Observer<IMainPageState> {
        @Nullable
        private String mLastWindow;
        private PageType mLastMainPage;
        private final AbsExperiment mExperiment;

        @Nullable
        public final String getMLastWindow() {
            return this.mLastWindow;
        }

        public final void setMLastWindow(@Nullable String string2) {
            this.mLastWindow = string2;
        }

        public void onShown(@Nullable DefaultWindow window) {
            DefaultWindow defaultWindow = window;
            if (Intrinsics.areEqual((Object)this.mLastWindow, (Object)(defaultWindow != null ? defaultWindow.getName() : null)) ^ true) {
                DefaultWindow defaultWindow2 = window;
                this.mExperiment.onWindowPageChanged(this.mLastWindow, defaultWindow2 != null ? defaultWindow2.getName() : null, this.mLastMainPage, this.mLastMainPage);
                DefaultWindow defaultWindow3 = window;
                this.mLastWindow = defaultWindow3 != null ? defaultWindow3.getName() : null;
            }
        }

        public void onChanged(@Nullable IMainPageState pageState) {
            if (pageState != null && this.mLastMainPage != pageState.getType()) {
                if (this.mLastWindow == null) {
                    AbstractWindow abstractWindow = this.mExperiment.getCurrentWindow();
                    this.mLastWindow = abstractWindow != null ? abstractWindow.getName() : null;
                }
                this.mExperiment.onWindowPageChanged(this.mLastWindow, this.mLastWindow, this.mLastMainPage, pageState.getType());
                this.mLastMainPage = pageState.getType();
            }
        }

        public WindowPageChangeListener(@NotNull AbsExperiment mExperiment) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)mExperiment, (String)"mExperiment");
                this.mExperiment = mExperiment;
                AbstractWindow abstractWindow = this.mExperiment.getCurrentWindow();
                this.mLastWindow = abstractWindow != null ? abstractWindow.getName() : null;
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager == null) break block0;
                iServiceManager.observeService(IHomeService.class, new Callback<IHomeService>(){

                    @Override
                    public final void onResponse(IHomeService homeService) {
                        if (mLastMainPage == null) {
                            mLastMainPage = homeService.getCurrentPageType();
                        }
                    }
                });
            }
        }
    }
}

