/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.envsetting.uriprovider;

import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IPHostProvider {
    private static final String TAG = "IPHostProvider";
    public static final String PARTY_HOST = "i.ihago.net";
    public static final String PARTY_HOST_863 = "i-863.ihago.net";
    public static final String PARTY_HOST_889 = "i-889.ihago.net";
    public static final String PARTY_HOST_872 = "i-872.ihago.net";
    public static final String PARTY_HOST_894 = "i-894.ihago.net";
    public static final String PARTY_HOST_892 = "i-892.ihago.net";
    public static final String PARTY_HOST_875 = "i-875.ihago.net";
    public static final String PARTY_HOST_881 = "i-881.ihago.net";
    public static final String PARTY_HOST_YJD = "yjd-turnover.ihago.net";
    public static final String PARTY_HOST_SBL = "sbl-turnover.ihago.net";
    public static final String PARTY_HOST_JLP = "jlp-turnover.ihago.net";
    public static final String PARTY_HOST_MM = "mm-turnover.ihago.net";
    public static final String PARTY_HOST_DB = "db-turnover.ihago.net";
    public static final String PARTY_HOST_GG = "gg-turnover.ihago.net";
    public static final String PARTY_HOST_MSK = "msk-turnover.ihago.net";
    public static final String PROXY_HOST_875 = "i-proxy-875.ihago.net";
    public static final String PROXY_HOST_881 = "i-proxy-881.ihago.net";
    public static final String PROXY_HOST_863 = "i-proxy-863.ihago.net";
    private static final Map<String, List<String>> sIPHostMap = new ConcurrentHashMap<String, List<String>>();

    public static void putDefaultIp(@NonNull String host, @NonNull List<String> ipList) {
        MLog.debug((Object)TAG, (String)"putIPList host: %s, list: %s", (Object[])new Object[]{host, ipList});
        sIPHostMap.put(host, ipList);
    }

    public static List<String> getDefaultIpByHost(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return null;
        }
        List<String> ipList = sIPHostMap.get(host);
        if (ipList != null) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"getHardcodeIPByHost: %s, list: %s", (Object[])new Object[]{host, ipList});
            }
            return ipList;
        }
        ipList = new ArrayList<String>(1);
        if (StringUtils.equal((String)PARTY_HOST, (String)host)) {
            ipList.add("149.129.135.90");
        } else if (StringUtils.equal((String)PARTY_HOST_863, (String)host)) {
            ipList.add("149.129.192.91");
        } else if (StringUtils.equal((String)PARTY_HOST_889, (String)host)) {
            ipList.add("172.96.125.5");
        } else if (StringUtils.equal((String)PARTY_HOST_872, (String)host)) {
            ipList.add("47.254.39.182");
        } else if (StringUtils.equal((String)PARTY_HOST_894, (String)host)) {
            ipList.add("47.91.97.180");
        } else if (StringUtils.equal((String)PARTY_HOST_892, (String)host)) {
            ipList.add("162.62.3.21");
        } else if (StringUtils.equal((String)PARTY_HOST_875, (String)host)) {
            ipList.add("149.129.135.90");
        } else if (StringUtils.equal((String)PARTY_HOST_881, (String)host)) {
            ipList.add("161.117.96.120");
        } else if (StringUtils.equal((String)PARTY_HOST_YJD, (String)host)) {
            ipList.add("149.129.192.174");
        } else if (StringUtils.equal((String)PARTY_HOST_SBL, (String)host)) {
            ipList.add("172.96.125.5");
        } else if (StringUtils.equal((String)PARTY_HOST_JLP, (String)host)) {
            ipList.add("161.117.107.48");
        } else if (StringUtils.equal((String)PARTY_HOST_MM, (String)host)) {
            ipList.add("149.129.176.71");
        } else if (StringUtils.equal((String)PARTY_HOST_DB, (String)host)) {
            ipList.add("47.91.97.180");
        } else if (StringUtils.equal((String)PARTY_HOST_GG, (String)host)) {
            ipList.add("47.254.50.150");
        } else if (StringUtils.equal((String)PARTY_HOST_MSK, (String)host)) {
            ipList.add("162.62.3.49");
        } else if (StringUtils.equal((String)PROXY_HOST_875, (String)host)) {
            ipList.add("34.93.247.142");
        } else if (StringUtils.equal((String)PROXY_HOST_881, (String)host) || StringUtils.equal((String)PROXY_HOST_863, (String)host)) {
            ipList.add("13.229.5.136");
        }
        sIPHostMap.put(host, ipList);
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"getHardcodeIPByHost: %s, list: %s", (Object[])new Object[]{host, ipList});
        }
        return ipList;
    }
}

