/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.deeplink;

import android.net.Uri;
import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.URLUtils;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u001a\u0010\u0017\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u001a\u0010\u0019\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u001a\u0010\u001a\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J:\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010 H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/yy/appbase/deeplink/DeepLinkStatistics;", "", "()V", "PARAM_CODE_SOURCE", "", "PARAM_SDK_TYPE", "SDK_AF", "SDK_APK", "SDK_FACEBOOK", "SDK_GP", "SDK_INTENT", "SDK_S2S", "TAG", "mFirstDp", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getReportDeepLinkString", "deeplinkUri", "Landroid/net/Uri;", "deeplink", "reportCodeResult", "", "source", "time", "reportConsumeDeeplink", "sdkType", "reportFirstDeeplink", "reportIntentDeeplink", "reportRequestCode", "reportRequestSdk", "reportSdkResult", "mediaSource", "extra", "", "appbase_debug"})
public final class DeepLinkStatistics {
    private static final String TAG = "DeepLinkStatistics";
    private static final String PARAM_SDK_TYPE = "sdk_type";
    private static final String PARAM_CODE_SOURCE = "code_source";
    @NotNull
    public static final String SDK_FACEBOOK = "1";
    @NotNull
    public static final String SDK_AF = "2";
    @NotNull
    public static final String SDK_S2S = "3";
    @NotNull
    public static final String SDK_GP = "4";
    @NotNull
    public static final String SDK_APK = "5";
    @NotNull
    public static final String SDK_INTENT = "6";
    private static AtomicBoolean mFirstDp;
    public static final DeepLinkStatistics INSTANCE;

    @JvmStatic
    public static final void reportRequestSdk(@NotNull String sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028473").put("function_id", "req_sdk").put(PARAM_SDK_TYPE, sdkType));
    }

    @JvmStatic
    public static final void reportRequestCode(@NotNull String sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028473").put("function_id", "req_code").put(PARAM_SDK_TYPE, sdkType));
    }

    @JvmStatic
    public static final void reportSdkResult(@NotNull String sdkType, @Nullable String mediaSource, @Nullable String time, @Nullable Map<String, String> extra) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20028473").put(PARAM_SDK_TYPE, sdkType).put("function_id", "req_sdk_result");
        String string2 = mediaSource;
        if (string2 == null) {
            string2 = "";
        }
        HiidoEvent hiidoEvent2 = hiidoEvent.put("media_source", string2);
        String string3 = time;
        if (string3 == null) {
            string3 = "";
        }
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent2.put("time_consuming", string3).putMap(extra));
    }

    @JvmStatic
    public static final void reportCodeResult(@Nullable String deeplink, @NotNull String source, @NotNull String time) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028473").put("function_id", "get_code_deeplink").put(PARAM_CODE_SOURCE, source).put("time_consuming", time).put("deeplink", DeepLinkStatistics.getReportDeepLinkString(deeplink)));
    }

    @JvmStatic
    public static final void reportIntentDeeplink(@Nullable Uri deeplink, @NotNull String sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        if (deeplink == null) {
            return;
        }
        String string2 = deeplink.getQueryParameter("game_id");
        if (string2 == null) {
            string2 = deeplink.getQueryParameter("gameId");
        }
        String gameId = string2;
        String adId = deeplink.getQueryParameter("adId");
        String reportDpString = DeepLinkStatistics.getReportDeepLinkString(deeplink);
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20028473").put("function_id", "first_deeplink").put("deeplink", reportDpString).put("time_consuming", String.valueOf(SystemClock.uptimeMillis() - RuntimeContext.sAppOncreateTime)).put(PARAM_SDK_TYPE, sdkType);
        String string3 = gameId;
        if (string3 == null) {
            string3 = "";
        }
        HiidoEvent hiidoEvent2 = hiidoEvent.put("gid", string3);
        String string4 = adId;
        if (string4 == null) {
            string4 = "";
        }
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent2.put("adid", string4));
    }

    @JvmStatic
    public static final void reportFirstDeeplink(@Nullable Uri deeplink, @NotNull String sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        if (deeplink == null) {
            return;
        }
        if (mFirstDp.getAndSet(false)) {
            String string2 = deeplink.getQueryParameter("game_id");
            if (string2 == null) {
                string2 = deeplink.getQueryParameter("gameId");
            }
            String gameId = string2;
            String adId = deeplink.getQueryParameter("adId");
            String reportDpString = DeepLinkStatistics.getReportDeepLinkString(deeplink);
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20028473").put("function_id", "first_deeplink").put("deeplink", reportDpString).put("time_consuming", String.valueOf(SystemClock.uptimeMillis() - RuntimeContext.sAppOncreateTime)).put(PARAM_SDK_TYPE, sdkType);
            String string3 = gameId;
            if (string3 == null) {
                string3 = "";
            }
            HiidoEvent hiidoEvent2 = hiidoEvent.put("gid", string3);
            String string4 = adId;
            if (string4 == null) {
                string4 = "";
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent2.put("adid", string4));
        }
    }

    @JvmStatic
    public static final void reportConsumeDeeplink(@Nullable Uri deeplink, @NotNull String sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        Uri uri = deeplink;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028473").put("function_id", "use_first_deeplink").put("deeplink", uri != null ? uri.toString() : null).put(PARAM_SDK_TYPE, sdkType));
    }

    @JvmStatic
    @NotNull
    public static final String getReportDeepLinkString(@Nullable String deeplink) {
        String string2;
        if (deeplink == null) {
            string2 = "";
        } else {
            String string3 = URLUtils.urlEncoderEncode((String)deeplink);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URLUtils.urlEncoderEncode(deeplink)");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getReportDeepLinkString(@Nullable Uri deeplinkUri) {
        String string2;
        if (deeplinkUri == null) {
            string2 = "";
        } else {
            String string3 = URLUtils.urlEncoderEncode((String)deeplinkUri.toString());
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URLUtils.urlEncoderEncode(deeplinkUri.toString())");
        }
        return string2;
    }

    private DeepLinkStatistics() {
    }

    static {
        DeepLinkStatistics deepLinkStatistics;
        INSTANCE = deepLinkStatistics = new DeepLinkStatistics();
        mFirstDp = new AtomicBoolean(true);
    }
}

