/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.deeplink;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.deeplink.data.DeepLinkBundle;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\fJ\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006J\"\u0010\u001e\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00020!J$\u0010\"\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010\u00062\b\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006J\u001a\u0010%\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010\u00062\b\u0010'\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/yy/appbase/deeplink/DeepLinkReportManager;", "Lcom/yy/framework/core/INotify;", "Landroidx/lifecycle/Observer;", "Lcom/yy/appbase/deeplink/data/DeepLinkBundle;", "()V", "ADD_WHATSAPP_STICKER", "", "SP_NAME", "TAG", "sSharedPreferences", "Landroid/content/SharedPreferences;", "checkReport", "", "getParam", "", "uuid", "", "getSp", "init", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onChanged", "bundle", "removeDeeplink", "uid", "reportDeeplink", "uri", "reportInviteCode", "inviteCode", "reportRelationship", "url", "isOldUser", "", "reportSpecialActive", "activeId", "inviteUid", "saveSource", "source", "campaign", "RelationParam", "appbase_debug"})
public final class DeepLinkReportManager
implements INotify,
Observer<DeepLinkBundle> {
    private static final String TAG = "DeepLinkReportManager";
    private static final String SP_NAME = "reportdeeplink";
    private static final String ADD_WHATSAPP_STICKER = "whatsAppSticker";
    private static volatile SharedPreferences sSharedPreferences;
    public static final DeepLinkReportManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SharedPreferences getSp() {
        if (sSharedPreferences == null) {
            DeepLinkReportManager deepLinkReportManager = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (deepLinkReportManager) {
                boolean bl3 = false;
                if (sSharedPreferences == null) {
                    Context context = RuntimeContext.sApplicationContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                    sSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(context, SP_NAME, 4);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        SharedPreferences sharedPreferences = sSharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        return sharedPreferences;
    }

    public final void init() {
        MLog.debug((Object)TAG, (String)"init", (Object[])new Object[0]);
        if (AccountUtil.getUid() <= 0L) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        } else {
            this.checkReport();
        }
        if (!RuntimeContext.sIsAppStartFinished) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        } else {
            this.checkReport();
        }
        DeepLinkService.INSTANCE.observeDeepLink((Observer<DeepLinkBundle>)((Observer)this));
    }

    public void notify(@Nullable Notification notification) {
        block0: {
            int n;
            block1: {
                Notification notification2 = notification;
                if (notification2 == null) break block0;
                Notification notification3 = notification2;
                boolean bl = false;
                boolean bl2 = false;
                Notification it = notification3;
                boolean bl3 = false;
                n = it.id;
                if (n != NotificationDef.N_STARTUP_FINISHED) break block1;
                INSTANCE.checkReport();
                break block0;
            }
            if (n != NotificationDef.N_LOGIN_SUCCESS) break block0;
            INSTANCE.checkReport();
        }
    }

    public void onChanged(@Nullable DeepLinkBundle bundle) {
        MLog.info((Object)TAG, (String)("receive dp bundle: " + bundle), (Object[])new Object[0]);
        if (bundle != null) {
            this.checkReport();
        }
    }

    public final void reportDeeplink(@NotNull String uri) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        MLog.info((Object)TAG, (String)"report uri: %s", (Object[])new Object[]{uri});
        long uid = AccountUtil.getUid() > 0L ? AccountUtil.getUid() : 0L;
        SharedPreferences $this$edit$iv = this.getSp();
        boolean instantly$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString("key_dp_report" + uid, uri);
        editor$iv.apply();
        this.checkReport();
    }

    public final void reportInviteCode(@Nullable String inviteCode) {
        CharSequence charSequence = inviteCode;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        HttpUtil.httpReqEx(UriProvider.UPLOAD_INVITE_CODE + "?inviteCode=" + inviteCode, null, null, 2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onResponse(@NotNull String response, @NotNull BaseResponseBean<Object> res, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Intrinsics.checkParameterIsNotNull(res, (String)"res");
                MLog.info((Object)"DeepLinkReportManager", (String)response, (Object[])new Object[0]);
            }

            public void onError(@NotNull Call call, @NotNull Exception e, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MLog.error((Object)"DeepLinkReportManager", (Throwable)e);
            }
        });
    }

    public final void reportRelationship(@Nullable String uid, @Nullable String url, boolean isOldUser) {
        CharSequence charSequence = uid;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        RelationParam param = new RelationParam();
        param.setUid(StringUtils.parseLong((String)uid));
        CharSequence charSequence2 = url;
        bl2 = false;
        boolean bl3 = false;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            param.setUrl(URLUtils.urlEncoderEncode((String)url));
        }
        param.setOld(isOldUser);
        HttpUtil.httpReqEx(UriProvider.UPLOAD_RELATION, param, null, 2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onResponse(@NotNull String response, @NotNull BaseResponseBean<Object> res, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Intrinsics.checkParameterIsNotNull(res, (String)"res");
                MLog.info((Object)"DeepLinkReportManager", (String)response, (Object[])new Object[0]);
            }

            public void onError(@NotNull Call call, @NotNull Exception e, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MLog.error((Object)"DeepLinkReportManager", (Throwable)e);
            }
        });
    }

    public final void reportSpecialActive(@Nullable String activeId, @Nullable String inviteUid, @Nullable String inviteCode) {
        if (Intrinsics.areEqual((Object)ADD_WHATSAPP_STICKER, (Object)activeId)) {
            MLog.info((Object)TAG, (String)"reportWhatsAppStickerInvite inviteUid: %s ", (Object[])new Object[]{inviteUid});
            CharSequence charSequence = inviteUid;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            String data2 = "{\"shareUid\":" + inviteUid + '}';
            String string2 = URLUtils.urlEncoderEncode((String)data2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLUtils.urlEncoderEncode(data)");
            data2 = string2;
            String url = UriProvider.getWhatsAppStickerReportInvite() + "?data=" + data2;
            HttpUtil.httpReq(url, null, 1, (INetRespCallback)new INetRespCallback<Object>(){

                public void onError(@NotNull Call call, @NotNull Exception e, int id2) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    MLog.error((Object)"DeepLinkReportManager", (String)"reportWhatsAppStickerInvite ex: %s", (Throwable)e, (Object[])new Object[0]);
                }

                public void onResponse(@NotNull String response, @NotNull BaseResponseBean<Object> res, int id2) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    Intrinsics.checkParameterIsNotNull(res, (String)"res");
                    MLog.info((Object)"DeepLinkReportManager", (String)"reportWhatsAppStickerInvite suc: %s", (Object[])new Object[]{response});
                }
            });
        }
    }

    public final void saveSource(@Nullable String source, @Nullable String campaign) {
        long uid = AccountUtil.getUid() > 0L ? AccountUtil.getUid() : 0L;
        String string2 = "key_dp_report_source" + uid;
        String string3 = source;
        if (string3 == null) {
            string3 = "";
        }
        SettingFlags.setStringValue((String)string2, (String)string3);
        String string4 = "key_dp_report_campaign" + uid;
        String string5 = campaign;
        if (string5 == null) {
            string5 = "";
        }
        SettingFlags.setStringValue((String)string4, (String)string5);
        String string6 = campaign;
        if (string6 == null) {
            string6 = "";
        }
        SettingFlags.setStringValue((String)"key_dp_report_campaign", (String)string6);
    }

    private final void checkReport() {
        if (AccountUtil.getUid() > 0L && RuntimeContext.sIsAppStartFinished) {
            long uid = AccountUtil.getUid();
            Map<String, String> param = this.getParam(uid);
            if (!FP.empty(param)) {
                MLog.info((Object)TAG, (String)"checkReport uid: %d, param: %s", (Object[])new Object[]{uid, param});
                Map<String, String> map = param;
                String dpUrl = map != null ? map.get("deeplink") : null;
                String string2 = UriProvider.getReportDeeplinkUrl();
                Map<String, String> map2 = param;
                if (map2 == null) {
                    Intrinsics.throwNpe();
                }
                HttpUtil.httpReq(string2, MapsKt.toMap(map2), 1, (INetRespCallback)new INetRespCallback<Object>(uid, dpUrl){
                    final /* synthetic */ long $uid;
                    final /* synthetic */ String $dpUrl;

                    public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                        MLog.error((Object)"DeepLinkReportManager", (String)"checkReport onError uid: %d", (Object[])new Object[]{this.$uid});
                    }

                    public void onResponse(@Nullable String response, @Nullable BaseResponseBean<Object> res, int id2) {
                        SharedPreferences.Editor editor$iv;
                        MLog.info((Object)"DeepLinkReportManager", (String)"checkReport onResponse uid: %d", (Object[])new Object[]{this.$uid});
                        DeepLinkReportManager.access$removeDeeplink(DeepLinkReportManager.INSTANCE, this.$uid);
                        SharedPreferences $this$edit$iv = DeepLinkReportManager.INSTANCE.getSp();
                        boolean instantly$iv = false;
                        boolean $i$f$edit = false;
                        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
                        SharedPreferences.Editor $this$edit = editor;
                        boolean bl = false;
                        $this$edit.putString("key_dp_report_last", this.$dpUrl);
                        editor$iv.apply();
                    }

                    public boolean needToken() {
                        return false;
                    }
                    {
                        this.$uid = $captured_local_variable$0;
                        this.$dpUrl = $captured_local_variable$1;
                    }
                });
            } else {
                MLog.info((Object)TAG, (String)"checkReport param is empty", (Object[])new Object[0]);
            }
        }
    }

    private final Map<String, String> getParam(long uuid) {
        long uid = uuid;
        String lastDp = this.getSp().getString("key_dp_report_last", "");
        String dp = this.getSp().getString("key_dp_report" + uid, "");
        if (TextUtils.isEmpty((CharSequence)dp)) {
            uid = 0L;
            dp = this.getSp().getString("key_dp_report" + uid, "");
        }
        if (!TextUtils.isEmpty((CharSequence)dp)) {
            if (Intrinsics.areEqual((Object)dp, (Object)lastDp)) {
                MLog.info((Object)TAG, (String)"dp == lastDp : %s", (Object[])new Object[]{lastDp});
                return null;
            }
            String source = SettingFlags.getStringValue((String)("key_dp_report_source" + uid));
            String campaign = SettingFlags.getStringValue((String)("key_dp_report_campaign" + uid));
            boolean bl = false;
            Map param = new LinkedHashMap();
            String string2 = dp;
            if (string2 == null) {
                string2 = "";
            }
            param.put("deeplink", string2);
            String string3 = source;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"source");
            param.put("channel", string3);
            String string4 = campaign;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"campaign");
            param.put("campaign", string4);
            return param;
        }
        return null;
    }

    private final void removeDeeplink(long uid) {
        SharedPreferences.Editor editor$iv;
        MLog.info((Object)TAG, (String)"removeDeeplink uid: %d", (Object[])new Object[]{uid});
        SharedPreferences $this$edit$iv = this.getSp();
        boolean instantly$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.remove("key_dp_report0");
        editor$iv.apply();
        $this$edit$iv = this.getSp();
        instantly$iv = false;
        $i$f$edit = false;
        SharedPreferences.Editor editor2 = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        $this$edit = editor2;
        boolean bl2 = false;
        $this$edit.remove("key_dp_report" + uid);
        editor$iv.apply();
        SettingFlags.removeKey((String)"key_dp_report_source0");
        SettingFlags.removeKey((String)"key_dp_report_campaign0");
        SettingFlags.removeKey((String)("key_dp_report_source" + uid));
        SettingFlags.removeKey((String)("key_dp_report_campaign" + uid));
    }

    private DeepLinkReportManager() {
    }

    static {
        DeepLinkReportManager deepLinkReportManager;
        INSTANCE = deepLinkReportManager = new DeepLinkReportManager();
    }

    public static final /* synthetic */ void access$removeDeeplink(DeepLinkReportManager $this, long uid) {
        $this.removeDeeplink(uid);
    }

    @DontProguardClass
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/yy/appbase/deeplink/DeepLinkReportManager$RelationParam;", "", "()V", "old", "", "getOld", "()Z", "setOld", "(Z)V", "uid", "", "getUid", "()J", "setUid", "(J)V", "url", "", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "appbase_debug"})
    public static final class RelationParam {
        private long uid;
        @Nullable
        private String url;
        private boolean old;

        public final long getUid() {
            return this.uid;
        }

        public final void setUid(long l) {
            this.uid = l;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@Nullable String string2) {
            this.url = string2;
        }

        public final boolean getOld() {
            return this.old;
        }

        public final void setOld(boolean bl) {
            this.old = bl;
        }
    }
}

