/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm.wrapper;

import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import io.objectbox.Property;
import io.objectbox.query.Query;
import io.objectbox.query.QueryBuilder;
import java.util.Date;
import java.util.HashMap;

public enum QueryFunction {
    STRING((Object)"", new Class[]{String.class}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, (String)value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.notEqual(property, (String)value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.greater(property, (String)value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.less(property, (String)value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, (String)value);
            return query;
        }
    }
    ,
    LONG((Object)0L, new Class[]{Long.TYPE, Long.class, Integer.TYPE, Integer.class}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, ((Number)value).longValue());
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.notEqual(property, ((Number)value).longValue());
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.greater(property, ((Number)value).longValue());
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.less(property, ((Number)value).longValue());
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, ((Number)value).longValue());
            return query;
        }
    }
    ,
    DOUBLE((Object)0.0, new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, ((Number)value).doubleValue(), 0.0);
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            if (RuntimeContext.sIsDebuggable) {
                throw new UnsupportedOperationException("unsupport double type use notEqual: " + property);
            }
            return builder;
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.greater(property, ((Number)value).doubleValue());
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.less(property, ((Number)value).doubleValue());
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, ((Number)value).doubleValue());
            return query;
        }
    }
    ,
    BYTE((Object)new byte[0], new Class[]{byte[].class}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, (byte[])value);
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            if (RuntimeContext.sIsDebuggable) {
                throw new UnsupportedOperationException("unsupport byte[] type use notEqual: " + property);
            }
            return builder;
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.greater(property, (byte[])value);
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.less(property, (byte[])value);
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, (byte[])value);
            return query;
        }
    }
    ,
    BOOLEAN((Object)false, new Class[]{Boolean.class, Boolean.TYPE}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, ((Boolean)value).booleanValue());
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.notEqual(property, ((Boolean)value).booleanValue());
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            if (RuntimeContext.sIsDebuggable) {
                throw new UnsupportedOperationException("unsupport boolean type use greater: " + property);
            }
            return builder;
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            if (RuntimeContext.sIsDebuggable) {
                throw new UnsupportedOperationException("unsupport boolean type use less: " + property);
            }
            return builder;
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, ((Boolean)value).booleanValue());
            return query;
        }
    }
    ,
    DATE((Object)new Date(), new Class[]{Date.class}){

        @Override
        public <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.equal(property, (Date)value);
        }

        @Override
        public <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.notEqual(property, (Date)value);
        }

        @Override
        public <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.greater(property, (Date)value);
        }

        @Override
        public <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> builder, @NonNull Property<T> property, @NonNull Object value) {
            return builder.less(property, (Date)value);
        }

        @Override
        public <T> Query<T> setParameter(@NonNull Query<T> query, @NonNull Property<T> property, @NonNull Object value) {
            query.setParameter(property, (Date)value);
            return query;
        }
    };

    @NonNull
    private final Class<?>[] mEntityClass;
    public final Object defaultValue;
    private static final HashMap<Class<?>, QueryFunction> FUNCTIONS_CLS_MAP;

    public abstract <T> QueryBuilder<T> equal(@NonNull QueryBuilder<T> var1, @NonNull Property<T> var2, @NonNull Object var3);

    public abstract <T> QueryBuilder<T> notEqual(@NonNull QueryBuilder<T> var1, @NonNull Property<T> var2, @NonNull Object var3);

    public abstract <T> QueryBuilder<T> greater(@NonNull QueryBuilder<T> var1, @NonNull Property<T> var2, @NonNull Object var3);

    public abstract <T> QueryBuilder<T> less(@NonNull QueryBuilder<T> var1, @NonNull Property<T> var2, @NonNull Object var3);

    public abstract <T> Query<T> setParameter(@NonNull Query<T> var1, @NonNull Property<T> var2, @NonNull Object var3);

    private QueryFunction(Object defaultValue, Class<?> ... entityClass) {
        this.mEntityClass = entityClass;
        this.defaultValue = defaultValue;
    }

    @NonNull
    public static QueryFunction getFunction(@NonNull Class<?> entityClass) {
        return FUNCTIONS_CLS_MAP.get(entityClass);
    }

    static {
        FUNCTIONS_CLS_MAP = new HashMap();
        for (QueryFunction queryFunction : QueryFunction.values()) {
            for (Class<?> cls : queryFunction.mEntityClass) {
                FUNCTIONS_CLS_MAP.put(cls, queryFunction);
            }
        }
    }
}

