/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm.cache;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.db.orm.JTableInfo;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import com.yy.appbase.db.orm.cache.CacheQueryBuilderWrapper;
import com.yy.appbase.db.orm.cache.JCacheTableInfoBuilder;
import com.yy.appbase.db.orm.wrapper.QueryBuilderWrapper;
import com.yy.base.cache.JCache;
import com.yy.base.cache.JCacheContainer;
import com.yy.base.cache.JCacheKey;
import com.yy.base.cache.JCacheValue;
import com.yy.base.cache.kvo.JKvoCache;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import java.util.List;

public class JCacheTableInfo<T extends KvoDbBean>
extends JTableInfo<T> {
    private static final String TAG_PREFIX = "JCacheTableInfo_";
    private final String mTag;
    private final JCache<T> mMemCache;

    public JCacheTableInfo(@NonNull JCacheTableInfoBuilder<T> builder) {
        super(builder);
        this.mTag = TAG_PREFIX + builder.entityClass.getSimpleName();
        this.mMemCache = this.buildMemCache(builder);
    }

    private JCache<T> buildMemCache(@NonNull JCacheTableInfoBuilder<T> builder) {
        final JCacheContainer.JCacheBuilder cacheBuilder = builder.cacheBuilder;
        JCacheContainer.JCacheBuilder cacheBuilderWrapper = new JCacheContainer.JCacheBuilder().clazz(builder.entityClass).expireTime(cacheBuilder.expireTime).minHardSize(cacheBuilder.minHardSize).cacheController(new JCache.CacheController<T>(){

            public T createNewCacheObject(@NonNull JCacheKey cacheKey) {
                KvoDbBean data2 = JCacheTableInfo.super.get(cacheKey.keyAt(0));
                if (data2 == null) {
                    return (Object)((KvoDbBean)((Object)cacheBuilder.cacheController.createNewCacheObject(cacheKey)));
                }
                return (Object)data2;
            }

            public void onNeedRefresh(@NonNull JCacheKey cacheKey, @NonNull JCacheValue<T> cacheObject) {
                cacheBuilder.cacheController.onNeedRefresh(cacheKey, cacheObject);
            }

            public boolean canValueBeTrimmed(JCacheKey cacheKey, T value) {
                return cacheBuilder.cacheController.canValueBeTrimmed(cacheKey, value);
            }
        });
        if (KvoSource.class.isAssignableFrom(builder.entityClass)) {
            return new JKvoCache(cacheBuilderWrapper);
        }
        return new JCache(cacheBuilderWrapper);
    }

    @Override
    @NonNull
    public T get(@NonNull Object primaryValue) {
        return (T)((Object)((KvoDbBean)((Object)this.mMemCache.get(JCacheKey.buildCacheKey((Object[])new Object[]{primaryValue})))));
    }

    @Override
    public void clear() {
        this.mMemCache.clear();
        super.clear();
    }

    @Override
    public QueryBuilderWrapper<T> query() {
        return new CacheQueryBuilderWrapper(this.mBox, this);
    }

    @Override
    @NonNull
    public List<T> getAll() {
        List list = super.getAll();
        this.mergeDbDataWithCache(list);
        return list;
    }

    public T mergeDbDataWithCache(@Nullable T data2) {
        if (data2 == null) {
            return null;
        }
        try {
            KvoDbBean existData = (KvoDbBean)((Object)this.mMemCache.putIfAbsent(JCacheKey.buildCacheKey((Object[])new Object[]{this.mPrimaryField.get(data2)}), data2));
            if (existData != null) {
                return (T)((Object)existData);
            }
        }
        catch (IllegalAccessException e) {
            MLog.error((Object)this.mTag, (String)("getAll error: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
        }
        return data2;
    }

    public void mergeDbDataWithCache(@NonNull List<T> list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                KvoDbBean data2 = (KvoDbBean)((Object)list.get(i));
                KvoDbBean existData = (KvoDbBean)((Object)this.mMemCache.putIfAbsent(JCacheKey.buildCacheKey((Object[])new Object[]{this.mPrimaryField.get((Object)data2)}), (Object)data2));
                if (existData == null) continue;
                list.set(i, (T)((Object)existData));
            }
        }
        catch (IllegalAccessException e) {
            MLog.error((Object)this.mTag, (String)("getAll error: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
        }
    }
}

