/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm;

import androidx.annotation.NonNull;
import com.yy.appbase.db.orm.JTableInfo;
import com.yy.appbase.db.orm.JTableInfoBuilder;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import io.objectbox.BoxStore;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JDb {
    private final ConcurrentHashMap<Class<? extends KvoDbBean>, JTableInfoBuilder<? extends KvoDbBean>> mTableBuilders;
    private final ConcurrentHashMap<Class<? extends KvoDbBean>, JTableInfo<? extends KvoDbBean>> mTables = new ConcurrentHashMap();

    public JDb(@NonNull BoxStore store) {
        this.mTableBuilders = this.createTableBuilders(store);
    }

    @NonNull
    protected abstract ConcurrentHashMap<Class<? extends KvoDbBean>, JTableInfoBuilder<? extends KvoDbBean>> createTableBuilders(@NonNull BoxStore var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T extends KvoDbBean> JTableInfo<T> tableInfo(@NonNull Class<T> entityClass) {
        JTableInfo<? extends KvoDbBean> constCache = this.mTables.get(entityClass);
        if (constCache != null) {
            return constCache;
        }
        Class<T> clazz = entityClass;
        synchronized (clazz) {
            constCache = this.mTables.get(entityClass);
            if (constCache != null) {
                return constCache;
            }
            constCache = this.mTableBuilders.get(entityClass).build();
            this.mTables.put(entityClass, constCache);
        }
        return constCache;
    }
}

