/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db;

import android.content.Context;
import android.util.Log;
import com.yy.appbase.data.BaseCImMsgBean;
import com.yy.appbase.data.CMsgSectionBean;
import com.yy.appbase.data.ChannelMsgsBean;
import com.yy.appbase.data.ChannelMsgsBean_;
import com.yy.appbase.db.ChannelDataBox;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.VersionUtil;
import io.objectbox.Box;
import io.objectbox.relation.ToMany;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ChannelMsgDb {
    private static final String TAG = "ChannelMsgLocal";
    public static final int READ_MAX_NUM = 500;
    public static final int UNREAD_MAX_NUM = 500;
    private ChannelDataBox dBservice;
    private HashMap<String, ChannelMsgsBean> groups;
    private IQueueTaskExecutor taskExecutor;
    private final HashMap<String, MyRunnable> saveBbRunnables;
    private boolean destroyed;

    public ChannelMsgDb(long uid) {
        block3: {
            this.dBservice = null;
            this.groups = new HashMap();
            this.taskExecutor = YYTaskExecutor.createAQueueExcuter();
            this.saveBbRunnables = new HashMap(5);
            this.destroyed = false;
            try {
                if (this.dBservice == null) {
                    this.dBservice = new ChannelDataBox(uid);
                }
            }
            catch (Exception e) {
                if (!RuntimeContext.sIsDebuggable) break block3;
                MLog.error((Object)TAG, (Throwable)e);
                RuntimeContext.isStartAtFirstInstalled();
                VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
                MLog.error((Object)TAG, (String)("sLastDebugVer " + RuntimeContext.sLastDebugVer + " new ver " + ver.aboutDisplayName(RuntimeContext.sApplicationContext)), (Object[])new Object[0]);
                MLog.error((Object)TAG, (Throwable)e);
                Log.e((String)TAG, (String)"init db error:", (Throwable)e);
                throw new RuntimeException("sLastDebugVer " + RuntimeContext.sLastDebugVer + " new ver " + ver.aboutDisplayName(RuntimeContext.sApplicationContext), e);
            }
        }
    }

    protected ChannelMsgsBean getGroupMsgsBean(String groupId) {
        if (this.dBservice == null) {
            return null;
        }
        ChannelMsgsBean groupMsgsBean = null;
        try {
            groupMsgsBean = this.groups.get(groupId);
            Box groupMsgsList = null;
            if (groupMsgsBean == null && (groupMsgsList = this.dBservice.boxForCurUser(ChannelMsgsBean.class)) != null) {
                groupMsgsBean = (ChannelMsgsBean)groupMsgsList.query().equal(ChannelMsgsBean_.groupId, groupId).build().findFirst();
                this.groups.put(groupId, groupMsgsBean);
            }
            if (groupMsgsBean == null) {
                return null;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return groupMsgsBean;
    }

    protected void addGroupMsgData(String groupId, ChannelMsgsBean bean) {
        if (this.dBservice == null) {
            return;
        }
        try {
            Box groupMsgsList = this.dBservice.boxForCurUser(ChannelMsgsBean.class);
            if (groupMsgsList != null) {
                groupMsgsList.put((Object)bean);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void deleteGroup(String groupId) {
        if (this.dBservice == null) {
            return;
        }
        try {
            ChannelMsgsBean groupMsgsBean;
            Box groupMsgsList = this.dBservice.boxForCurUser(ChannelMsgsBean.class);
            if (groupMsgsList != null && (groupMsgsBean = (ChannelMsgsBean)groupMsgsList.query().equal(ChannelMsgsBean_.groupId, groupId).build().findFirst()) != null) {
                groupMsgsList.remove((Object)groupMsgsBean);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void updateGroupMsgDataNotIncludeMsg(String groupId, long unreadNum, String lastReadMsgId, String lastMsgId, String lastNotHiidenMsgId) {
        if (this.dBservice == null) {
            return;
        }
        try {
            ChannelMsgsBean groupMsgsBean = this.getGroupMsgsBean(groupId);
            if (groupMsgsBean == null) {
                return;
            }
            Box groupMsgsList = this.dBservice.boxForCurUser(ChannelMsgsBean.class);
            if (groupMsgsList != null) {
                groupMsgsBean.unreadNum = unreadNum;
                groupMsgsBean.lastReadMsgId = lastReadMsgId;
                groupMsgsBean.lastMsgId = lastMsgId;
                groupMsgsBean.lastNotHiidenMsgId = lastNotHiidenMsgId;
                groupMsgsList.put((Object)groupMsgsBean);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public int getSectionSize(BaseCImMsgBean baseImMsgBean) {
        return baseImMsgBean.sections != null ? baseImMsgBean.sections.size() : 0;
    }

    public void addSection(BaseCImMsgBean baseImMsgBean, CMsgSectionBean sectionBean) {
        baseImMsgBean.sections.add((Object)sectionBean);
    }

    public List<CMsgSectionBean> getSections(BaseCImMsgBean baseImMsgBean, int sectionSize) {
        return baseImMsgBean.sections.subList(0, sectionSize);
    }

    public boolean removeMsgById(ChannelMsgsBean groupMsgsBea, long id2) {
        return groupMsgsBea.msgs.removeById(id2) != null;
    }

    public void removeMsgByIndex(ChannelMsgsBean groupMsgsBean, int index) {
        groupMsgsBean.msgs.remove(index);
    }

    public void removeMsg(ChannelMsgsBean groupMsgsBean, BaseCImMsgBean index) {
        groupMsgsBean.msgs.remove((Object)index);
    }

    public void addMsg(ChannelMsgsBean groupMsgsBean, int location, BaseCImMsgBean item) {
        groupMsgsBean.msgs.add(location, (Object)item);
    }

    public void addMsg(ChannelMsgsBean groupMsgsBean, BaseCImMsgBean item) {
        groupMsgsBean.msgs.add((Object)item);
    }

    public int indexOfId(ChannelMsgsBean groupMsgsBean, long fromID) {
        return groupMsgsBean.msgs.indexOfId(fromID);
    }

    public int getMsgsSize(ChannelMsgsBean groupMsgsBean) {
        return groupMsgsBean.msgs != null ? groupMsgsBean.msgs.size() : 0;
    }

    public List<BaseCImMsgBean> getMsgs(ChannelMsgsBean groupMsgsBean, int index, int size) {
        return groupMsgsBean.msgs.subList(index, size);
    }

    protected void saveMsgs(String groupId, ChannelMsgsBean groupMsgsBean) {
        this.saveMsgsInner(groupId, groupMsgsBean.msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMsgsInner(String groupId, ToMany<BaseCImMsgBean> msg) {
        MyRunnable oldRunnable;
        HashMap<String, MyRunnable> hashMap = this.saveBbRunnables;
        synchronized (hashMap) {
            oldRunnable = this.saveBbRunnables.get(groupId);
        }
        if (oldRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)oldRunnable);
        }
        MyRunnable nowRunnable = new MyRunnable(groupId, msg, this.taskExecutor);
        HashMap<String, MyRunnable> hashMap2 = this.saveBbRunnables;
        synchronized (hashMap2) {
            this.saveBbRunnables.put(groupId, nowRunnable);
        }
        YYTaskExecutor.postToMainThread((Runnable)nowRunnable, (long)(RuntimeContext.sIsDebuggable ? 2000L : 1000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginOut() {
        HashMap<String, MyRunnable> hashMap = this.saveBbRunnables;
        synchronized (hashMap) {
            Set<String> groupIds = this.saveBbRunnables.keySet();
            if (groupIds != null && groupIds.size() > 0) {
                for (String groupID : groupIds) {
                    MyRunnable oldRunnable = this.saveBbRunnables.get(groupID);
                    if (oldRunnable == null) continue;
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)oldRunnable);
                }
            }
        }
    }

    public void destroy() {
        this.destroyed = true;
    }

    private class MyRunnable
    implements Runnable {
        ToMany<BaseCImMsgBean> msg;
        IQueueTaskExecutor taskExecutor;
        String groupId;

        public MyRunnable(String groupId, ToMany<BaseCImMsgBean> msg, IQueueTaskExecutor taskExecutor) {
            this.msg = msg;
            this.taskExecutor = taskExecutor;
            this.groupId = groupId;
        }

        @Override
        public void run() {
            this.taskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!ChannelMsgDb.this.destroyed) {
                            MyRunnable.this.msg.applyChangesToDb();
                        }
                    }
                    catch (Throwable e) {
                        if (RuntimeContext.sIsDebuggable) {
                            throw new RuntimeException(e);
                        }
                        MLog.error((Object)ChannelMsgDb.TAG, (Throwable)e);
                    }
                    HashMap hashMap = ChannelMsgDb.this.saveBbRunnables;
                    synchronized (hashMap) {
                        if (ChannelMsgDb.this.saveBbRunnables != null) {
                            ChannelMsgDb.this.saveBbRunnables.remove(MyRunnable.this.groupId);
                        }
                    }
                }
            }, 0L);
        }
    }
}

