/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import android.text.TextUtils;
import com.yy.appbase.data.BaseDBBean;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.StringUtils;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;

@Entity
public class RechargeDbBean
extends BaseDBBean {
    @Id
    long id;
    @Index
    String orderId;
    String productId;
    double price;
    long diamond;
    String srcCurrencySymbol;
    int chargeConfigId;
    int useChannel;
    String gpOrderId;
    String purchaseToken;
    String purchaseData;
    String purchaseSign;
    String gameId;
    int state;
    long startTime;
    int retryCount;
    int productType;
    String payload;
    boolean isCurrencyCodeEnable;
    long revenueOrderId;
    boolean msgIntercept = false;

    public long getStartTime() {
        return this.startTime;
    }

    public double getPrice() {
        return this.price;
    }

    public long getDiamond() {
        return this.diamond;
    }

    public String getGameId() {
        return this.gameId;
    }

    public String getGpOrderId() {
        return this.gpOrderId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSrcCurrencySymbol() {
        return this.srcCurrencySymbol;
    }

    public boolean isCurrencyCodeEnable() {
        return this.isCurrencyCodeEnable;
    }

    public boolean msgIntercept() {
        return this.msgIntercept;
    }

    private RechargeDbBean() {
    }

    public RechargeDbBean(String orderId, String productId, double price, long diamond, String symbol, int cid, int channel, String gameId, int productType, String payload, boolean isCurrencyCodeEnable, boolean msgIntercept) {
        this.orderId = orderId;
        this.productId = productId;
        this.price = price;
        this.diamond = diamond;
        this.srcCurrencySymbol = symbol;
        this.chargeConfigId = cid;
        this.useChannel = channel;
        this.gameId = gameId;
        this.productType = productType;
        this.payload = payload;
        this.isCurrencyCodeEnable = isCurrencyCodeEnable;
        this.msgIntercept = msgIntercept;
        this.state = 1;
        this.startTime = System.currentTimeMillis();
    }

    public void setRevenueOrderId(long revenueOrderId) {
        this.revenueOrderId = revenueOrderId;
    }

    @Override
    public Object getIndex() {
        return this.orderId;
    }

    @Override
    protected long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id2) {
        this.id = id2;
    }

    @Override
    public int getMaxStoreNum() {
        return 100;
    }

    @Override
    public boolean canDelete() {
        return this.state == 0 || this.state == -1 || this.state == 10;
    }

    public boolean needCheckOrderStatus() {
        return this.state == 20 || this.state == 11 || this.state == 30;
    }

    public int needRetry() {
        boolean need;
        if (!this.isAbnormalState()) {
            return -1;
        }
        boolean bl = need = this.retryCount < 5 || System.currentTimeMillis() - this.startTime < DateUtils.ONE_DAY_MILLIS * 2L;
        if (!need) {
            this.state = -1;
            return 0;
        }
        return 1;
    }

    public void increaseRetryCount() {
        if (!this.isAbnormalState()) {
            return;
        }
        ++this.retryCount;
        long cur = System.currentTimeMillis();
        long dif = cur - this.startTime;
        if (dif >= DateUtils.ONE_DAY_MILLIS * 2L && this.retryCount >= 5) {
            this.state = -1;
        }
    }

    public void updateState(int state) {
        if (this.state != state) {
            this.retryCount = 0;
        }
        this.state = state;
    }

    public int getProductType() {
        return this.productType;
    }

    public String getPayload() {
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            return this.orderId;
        }
        return this.payload;
    }

    public String getOriginPayload() {
        return this.payload;
    }

    public int getState() {
        return this.state;
    }

    public void rechargeSuccess(String gpOrderId, String purchaseToken, String purchaseData, String purchaseSign) {
        this.gpOrderId = gpOrderId;
        this.purchaseToken = purchaseToken;
        this.purchaseData = purchaseData;
        this.purchaseSign = purchaseSign;
    }

    public void setDiamond(long diamond) {
        this.diamond = diamond;
    }

    public int getChargeConfigId() {
        return this.chargeConfigId;
    }

    public String getPurchaseData() {
        return this.purchaseData;
    }

    public String getPurchaseSign() {
        return this.purchaseSign;
    }

    public String getPurchaseToken() {
        return this.purchaseToken;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public long getRechargeOrderId() {
        if (this.revenueOrderId > 0L) {
            return this.revenueOrderId;
        }
        if (this.orderId.length() > 11) {
            this.revenueOrderId = StringUtils.parseLong((String)this.orderId.substring(11));
        }
        return this.revenueOrderId;
    }

    public int getUseChannel() {
        return this.useChannel;
    }

    private boolean isAbnormalState() {
        return this.state == 1 || this.state == 21;
    }

    public String toString() {
        return "RechargeDbBean{orderId='" + this.orderId + '\'' + ", productId='" + this.productId + '\'' + ", price=" + this.price + ", diamond=" + this.diamond + ", state=" + this.state + ", retryCount=" + this.retryCount + ", gpOrderId='" + this.gpOrderId + '\'' + '}';
    }

    public static interface State {
        public static final int unknown = 0;
        public static final int start = 1;
        public static final int success = 2;
        public static final int rechargeCancel = 10;
        public static final int rechargeSuccess = 11;
        public static final int rechargeFail = 12;
        public static final int reportSuccess = 20;
        public static final int reportFail = 21;
        public static final int broTimeout = 30;
        public static final int shouldDelete = -1;
    }
}

