/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonStringBuilder {
    private JSONObject jsonObject;

    private JsonStringBuilder() {
    }

    public static JsonStringBuilder newBuilder() {
        return new JsonStringBuilder();
    }

    public synchronized JsonStringBuilder put(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return this;
        }
        if (this.jsonObject == null) {
            this.jsonObject = JsonParser.obtainJSONObject();
        }
        try {
            this.jsonObject.put(key, value);
        }
        catch (JSONException e) {
            MLog.error((Object)"JsonStringBuilder", (String)"put json error key: %s, value: %s", (Throwable)e, (Object[])new Object[]{key, value});
        }
        return this;
    }

    public synchronized JsonStringBuilder merge(JSONObject json) {
        if (json == null) {
            return this;
        }
        if (this.jsonObject == null) {
            this.jsonObject = JsonParser.obtainJSONObject();
        }
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.put(key, json.opt(key));
        }
        return this;
    }

    public synchronized JsonStringBuilder merge(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return this;
        }
        try {
            JSONObject json = JsonParser.obtainJSONObject((String)jsonStr);
            this.merge(json);
        }
        catch (JSONException e) {
            MLog.error((Object)"JsonStringBuilder", (String)"merge jsonStr: %s", (Throwable)e, (Object[])new Object[]{jsonStr});
        }
        return this;
    }

    public synchronized JsonStringBuilder putAll(Map<String, Object> ext2) {
        if (FP.empty(ext2)) {
            return this;
        }
        for (Map.Entry<String, Object> entry : ext2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public synchronized String buildJson() {
        if (this.jsonObject != null) {
            return this.jsonObject.toString();
        }
        return "";
    }

    public synchronized JSONObject jsonObject() {
        return this.jsonObject;
    }
}

