/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import androidx.annotation.Nullable;
import com.yy.appbase.data.BaseDBBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.TimeUtils;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import net.ihago.money.api.mask.MaskIconInfo;

@Entity
public class EffectMaskDBBean
extends BaseDBBean {
    @Id
    public long entityId;
    @Index
    long index;
    public int id;
    public String operationType;
    public String name;
    public String md5;
    public String thumb;
    public String tip;
    public String url;
    public String resourceType;
    public String recommendPic;
    public String expandJson;
    public long expireTime;
    public int privilege;
    public static final int PRIVILEGE_DEFAULT = 0;
    public static final int PRIVILEGE_NORMAL = 1;
    public static final int PRIVILEGE_ADVANCE = 2;

    public String toString() {
        return "EffectBean{id=" + this.id + ", operationType='" + this.operationType + '\'' + ", name='" + this.name + '\'' + ", md5='" + this.md5 + '\'' + ", thumb='" + this.thumb + '\'' + ", tip='" + this.tip + '\'' + ", url='" + this.url + '\'' + ", resourceType='" + this.resourceType + '\'' + ", recommendPic='" + this.recommendPic + '\'' + ", expandJson='" + this.expandJson + '\'' + ", expireTime='" + this.expireTime + '\'' + ", privilege='" + this.privilege + '\'' + '}';
    }

    @Override
    public Object getIndex() {
        return this.index;
    }

    @Override
    protected long getId() {
        return this.entityId;
    }

    @Override
    protected void setId(long id2) {
        this.entityId = id2;
    }

    @Nullable
    public static EffectMaskDBBean from(MaskIconInfo info) {
        if (info == null) {
            return null;
        }
        EffectMaskDBBean bean = new EffectMaskDBBean();
        bean.id = info.id;
        bean.operationType = info.operation_type;
        bean.name = info.name;
        bean.md5 = info.md5;
        bean.thumb = info.thumb;
        bean.tip = info.tip;
        bean.url = info.url;
        bean.resourceType = info.resource_type;
        bean.recommendPic = info.recommend_pic;
        bean.expandJson = info.expand_json;
        MLog.info((Object)"EffectMaskDBBean", (String)"info.time_left=%s, %s", (Object[])new Object[]{info.time_left, info.name});
        bean.expireTime = info.time_left > 0 ? TimeUtils.getServiceRealTime() + (long)info.time_left.intValue() * 1000L : -1L;
        MLog.info((Object)"EffectMaskDBBean", (String)" bean.expireTime=%s, %s, %s", (Object[])new Object[]{bean.expireTime, info.name, TimeUtils.getServiceRealTime()});
        bean.privilege = info.privilege_type.getValue();
        return bean;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaskPrivilegeType {
    }
}

