/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.config;

import com.yy.appbase.config.BossConfigData;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.appbase.service.IBossConfigService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class BossConfigService
extends DefaultController
implements IBossConfigService {
    private static final String TAG = "BossConfigService";
    private static final String HAGO = "hago";
    private static final String APP = "app";

    public BossConfigService(Environment env) {
        super(env);
    }

    @Override
    public <T> void getBossConfig(final String key, final ConfigCallback<T> callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getBossConfig key: %s", (Object[])new Object[]{key});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", key);
        HttpUtil.httpReq(this.getBossConfigUrl(), params, 1, new INetRespOriginJsonParseCallback<BossConfigData>(){

            @Override
            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)BossConfigService.TAG, (String)"getBossConfig onError", (Throwable)e, (Object[])new Object[0]);
                if (callback != null) {
                    callback.onError(e);
                }
            }

            @Override
            public void onResponse(String response, BaseResponseBean<BossConfigData> res, int id2) {
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)BossConfigService.TAG, (String)("getBossConfig onResponse id: " + id2 + "  BaseResponseBean = " + response), (Object[])new Object[0]);
                }
                if (callback == null) {
                    return;
                }
                YYTaskExecutor.execute(() -> {
                    try {
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
                        if (jsonObject.has("data")) {
                            JSONObject dataOb = jsonObject.getJSONObject("data");
                            if (dataOb.has("soundConfig")) {
                                JSONObject sound = dataOb.getJSONObject("soundConfig");
                                String result = sound.getString("value");
                                Object data2 = JsonParser.parseJsonTye((String)result, (Type)callback2.rType);
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.info((Object)BossConfigService.TAG, (String)("data = " + data2 + "  \ngetBossConfig key = " + key + "  value = " + result), (Object[])new Object[0]);
                                }
                                YYTaskExecutor.postToMainThread(() -> callback.onSuccess(data2));
                            }
                        } else {
                            callback.onError(new Exception(response == null ? StringUtils.formatWitUSLocal((String)"\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0ckey: %s", (Object[])new Object[]{key}) : res.message));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                });
            }

            @Override
            public boolean needToken() {
                return false;
            }
        }, this.getHeaders());
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(APP, HAGO);
        return headers;
    }

    public String getBossConfigUrl() {
        return UriProvider.getBossConfigUrl();
    }

    @DontProguardClass
    private static class BossConfigBean<D> {
        public static final int HTTP_OK = 1;
        public int code;
        public String message;
        public D data;

        private BossConfigBean() {
        }
    }

    @DontProguardClass
    public static abstract class ConfigCallback<R> {
        public Type rType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

        public abstract void onSuccess(R var1);

        public abstract void onError(Exception var1);
    }
}

