/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.component;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CustomCountDownTimer {
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private long millisInFuture;
    private final long countdownInterval;
    private long stopTimeInFuture;
    private boolean isCancelled = false;
    private TimerTickListener tickListener;
    private ScheduledExecutorService scheduler;

    public CustomCountDownTimer(long millisInFuture, long countDownInterval, TimerTickListener tickListener) {
        this.millisInFuture = millisInFuture;
        this.stopTimeInFuture = SystemClock.elapsedRealtime() + this.millisInFuture;
        this.countdownInterval = countDownInterval;
        this.tickListener = tickListener;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public synchronized void start() {
        this.isCancelled = false;
        this.scheduler.scheduleWithFixedDelay(new TimerRunnable(), 0L, this.countdownInterval, TimeUnit.MILLISECONDS);
    }

    public final synchronized void cancel() {
        this.isCancelled = true;
    }

    public void extendTime(long delta) {
        this.stopTimeInFuture += delta;
        this.millisInFuture += delta;
    }

    private class TimerRunnable
    implements Runnable {
        private TimerRunnable() {
        }

        @Override
        public void run() {
            CustomCountDownTimer.this.mainThreadHandler.post(new Runnable(){
                long millisLeft;
                {
                    this.millisLeft = CustomCountDownTimer.this.stopTimeInFuture - SystemClock.elapsedRealtime();
                }

                @Override
                public void run() {
                    if (CustomCountDownTimer.this.isCancelled) {
                        CustomCountDownTimer.this.tickListener.onCancel();
                        CustomCountDownTimer.this.scheduler.shutdown();
                    } else if (this.millisLeft <= 0L) {
                        CustomCountDownTimer.this.tickListener.onFinish();
                        CustomCountDownTimer.this.scheduler.shutdown();
                    } else {
                        CustomCountDownTimer.this.tickListener.onTick(this.millisLeft);
                    }
                }
            });
        }
    }

    public static interface TimerTickListener {
        public void onTick(long var1);

        public void onFinish();

        public void onCancel();
    }
}

