/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.commoneventreport;

import com.yy.appbase.commoneventreport.CommonEventReportService;
import com.yy.appbase.commoneventreport.EventQueue;
import com.yy.appbase.commoneventreport.EventReportModel;
import com.yy.appbase.commoneventreport.ReportEvent;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.cevent.BatchPublishRes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0015H\u0002J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yy/appbase/commoneventreport/CommonEventReportService;", "", "()V", "TAG", "", "value", "", "mEnable", "getMEnable", "()Z", "setMEnable", "(Z)V", "mLastReportTime", "", "mQueue", "Lcom/yy/appbase/commoneventreport/EventQueue;", "getMQueue", "()Lcom/yy/appbase/commoneventreport/EventQueue;", "mQueue$delegate", "Lkotlin/Lazy;", "mReportInterval", "", "mReportMaxCount", "mReportModel", "Lcom/yy/appbase/commoneventreport/EventReportModel;", "getMReportModel", "()Lcom/yy/appbase/commoneventreport/EventReportModel;", "mReportModel$delegate", "mReportTask", "Ljava/lang/Runnable;", "doReport", "", "getReportInterval", "reportEvent", "event", "Lcom/yy/appbase/commoneventreport/ReportEvent;", "tryReport", "appbase_debug"})
public final class CommonEventReportService {
    private static final String TAG = "CommonEventReportService";
    private static int mReportInterval;
    private static int mReportMaxCount;
    private static long mLastReportTime;
    private static boolean mEnable;
    private static final Lazy mQueue$delegate;
    private static final Lazy mReportModel$delegate;
    private static final Runnable mReportTask;
    public static final CommonEventReportService INSTANCE;

    public final boolean getMEnable() {
        return mEnable;
    }

    public final void setMEnable(boolean value) {
        mEnable = value;
        if (value) {
            this.tryReport();
        }
    }

    private final EventQueue getMQueue() {
        Lazy lazy = mQueue$delegate;
        CommonEventReportService commonEventReportService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventQueue)lazy.getValue();
    }

    private final EventReportModel getMReportModel() {
        Lazy lazy = mReportModel$delegate;
        CommonEventReportService commonEventReportService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventReportModel)lazy.getValue();
    }

    public final void reportEvent(@NotNull ReportEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.getReportInterval() < 0) {
            MLog.info((Object)TAG, (String)"server had close event report", (Object[])new Object[0]);
            return;
        }
        if (!mEnable) {
            if (!event.getCanAbandon()) {
                this.getMQueue().enqueue(event);
            }
            return;
        }
        this.getMQueue().enqueue(event);
        this.tryReport();
    }

    private final void tryReport() {
        if (!this.getMQueue().hasEvent()) {
            MLog.debug((Object)TAG, (String)"try report event empty", (Object[])new Object[0]);
            return;
        }
        if (System.currentTimeMillis() - mLastReportTime < (long)this.getReportInterval()) {
            long delay = (long)this.getReportInterval() - (System.currentTimeMillis() - mLastReportTime);
            MLog.debug((Object)TAG, (String)("report event delay=" + delay), (Object[])new Object[0]);
            YYTaskExecutor.removeTask((Runnable)mReportTask);
            YYTaskExecutor.execute((Runnable)mReportTask, (long)delay);
            return;
        }
        this.doReport();
    }

    private final void doReport() {
        ArrayList<ReportEvent> reportList = this.getMQueue().consume(mReportMaxCount);
        MLog.info((Object)TAG, (String)("report event size=" + reportList.size()), (Object[])new Object[0]);
        Collection collection = reportList;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        boolean it = bl2;
        boolean bl4 = false;
        mLastReportTime = System.currentTimeMillis();
        INSTANCE.getMReportModel().reportEvent(reportList, (Function1<? super BatchPublishRes, Unit>)((Function1)new Function1<BatchPublishRes, Unit>(){

            public void invoke(@NotNull BatchPublishRes res) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                MLog.debug((Object)"CommonEventReportService", (String)("report result:(" + res.batch_size + '-' + res.interval + ')'), (Object[])new Object[0]);
                Integer n = res.batch_size;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"res.batch_size");
                CommonEventReportService.access$setMReportMaxCount$p(CommonEventReportService.INSTANCE, n);
                Integer n2 = res.interval;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"res.interval");
                CommonEventReportService.access$setMReportInterval$p(CommonEventReportService.INSTANCE, n2);
                CommonEventReportService.access$tryReport(CommonEventReportService.INSTANCE);
            }
        }));
    }

    private final int getReportInterval() {
        return mReportInterval * 1000;
    }

    private CommonEventReportService() {
    }

    static {
        CommonEventReportService commonEventReportService;
        INSTANCE = commonEventReportService = new CommonEventReportService();
        mReportInterval = 1;
        mReportMaxCount = 10;
        mQueue$delegate = LazyKt.lazy((Function0)mQueue.2.INSTANCE);
        mReportModel$delegate = LazyKt.lazy((Function0)mReportModel.2.INSTANCE);
        mReportTask = mReportTask.1.INSTANCE;
    }

    public static final /* synthetic */ int access$getMReportMaxCount$p(CommonEventReportService $this) {
        CommonEventReportService commonEventReportService = $this;
        return mReportMaxCount;
    }

    public static final /* synthetic */ void access$setMReportMaxCount$p(CommonEventReportService $this, int n) {
        CommonEventReportService commonEventReportService = $this;
        mReportMaxCount = n;
    }

    public static final /* synthetic */ int access$getMReportInterval$p(CommonEventReportService $this) {
        CommonEventReportService commonEventReportService = $this;
        return mReportInterval;
    }

    public static final /* synthetic */ void access$setMReportInterval$p(CommonEventReportService $this, int n) {
        CommonEventReportService commonEventReportService = $this;
        mReportInterval = n;
    }

    public static final /* synthetic */ void access$tryReport(CommonEventReportService $this) {
        $this.tryReport();
    }

    public static final /* synthetic */ void access$doReport(CommonEventReportService $this) {
        $this.doReport();
    }
}

