/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.common.helper;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/yy/appbase/common/helper/ViewHelper;", "", "()V", "checkVerticalVisible", "", "view", "Landroid/view/View;", "checkVisible", "getAbsoluteVisibleHeight", "", "outer", "getVisibleHeight", "getVisiblePercent", "", "getVisibleWidth", "appbase_debug"})
public final class ViewHelper {
    public static final ViewHelper INSTANCE;

    public final boolean checkVisible(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Rect rect = new Rect();
        return view.getGlobalVisibleRect(rect);
    }

    public final boolean checkVerticalVisible(@NotNull View view) {
        View parentView;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof View)) {
            viewParent = null;
        }
        return (parentView = (View)viewParent) == null || this.getAbsoluteVisibleHeight(view, parentView) > 0;
    }

    public final int getAbsoluteVisibleHeight(@NotNull View view, @NotNull View outer) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)outer, (String)"outer");
        Rect outerRect = new Rect();
        outer.getGlobalVisibleRect(outerRect);
        Rect viewRect = new Rect();
        view.getGlobalVisibleRect(viewRect);
        int visibleTop = RangesKt.coerceAtLeast((int)viewRect.top, (int)outerRect.top);
        int visibleBottom = RangesKt.coerceAtMost((int)viewRect.bottom, (int)outerRect.bottom);
        return visibleBottom > visibleTop ? visibleBottom - visibleTop : 0;
    }

    public final int getVisibleHeight(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        return rect.height();
    }

    public final int getVisibleWidth(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        return rect.width();
    }

    public final float getVisiblePercent(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        if (view.getWidth() > 0 && view.getHeight() > 0) {
            return (float)(rect.width() * rect.height()) / (float)(view.getWidth() * view.getHeight());
        }
        return 0.0f;
    }

    private ViewHelper() {
    }

    static {
        ViewHelper viewHelper;
        INSTANCE = viewHelper = new ViewHelper();
    }
}

