/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.common.helper;

import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yy.appbase.common.helper.ItemInvisible;
import com.yy.appbase.common.helper.ItemVisible;
import com.yy.appbase.common.helper.OnItemShowListener;
import com.yy.appbase.common.helper.OnItemVisibleChangeListener;
import com.yy.appbase.common.helper.OnVisibleRangeChangeListener;
import com.yy.appbase.common.helper.ViewHelper;
import com.yy.appbase.common.helper.ViewVisibleInfo;
import com.yy.appbase.common.helper.VisibleCheckCallback;
import com.yy.appbase.common.helper.VisibleCheckTimerTask;
import com.yy.appbase.common.helper.VisibleItem;
import com.yy.appbase.common.helper.VisibleState;
import com.yy.base.logger.MLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dJ\u000e\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020!J,\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0011H\u0002J\u0018\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0006\u0010/\u001a\u00020#J\u0018\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u00020\u0014H\u0002J\u000e\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\u000eJ\u0018\u00106\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00112\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010:\u001a\u00020;H\u0002J \u0010<\u001a\u00020#2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020#2\u0006\u00105\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u0011H\u0016J \u0010@\u001a\u00020#2\u0006\u00105\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0011H\u0016J$\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120(H\u0016J\b\u0010F\u001a\u00020#H\u0002J\u0006\u0010G\u001a\u00020#J\u000e\u0010H\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dJ\u000e\u0010I\u001a\u00020#2\u0006\u0010$\u001a\u00020!J\u0006\u0010J\u001a\u00020#J\u0006\u0010K\u001a\u00020#R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/yy/appbase/common/helper/RecyclerViewItemRecorder;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "Lcom/yy/appbase/common/helper/VisibleCheckCallback;", "threshold", "", "(J)V", "checkRealVisible", "", "getCheckRealVisible", "()Z", "setCheckRealVisible", "(Z)V", "currRangeVisibleStartTime", "currRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "currVisibleItemMap", "", "", "Lcom/yy/appbase/common/helper/VisibleItem;", "currVisibleRange", "Lkotlin/ranges/IntRange;", "isNewRound", "<set-?>", "isRecording", "itemShowListeners", "", "Lcom/yy/appbase/common/helper/OnItemShowListener;", "itemVisibleChangeListeners", "", "Lcom/yy/appbase/common/helper/OnItemVisibleChangeListener;", "visibleCheckTimerTasks", "Lcom/yy/appbase/common/helper/VisibleCheckTimerTask;", "visibleRangeChangeListeners", "Lcom/yy/appbase/common/helper/OnVisibleRangeChangeListener;", "addItemShowListener", "", "listener", "addItemVisibleChangeListener", "addVisibleRangeChangeListener", "calculateNewVisibleMap", "", "lastRange", "currRange", "time", "checkItemCurrRealVisible", "pos", "checkVisibleChange", "clear", "findCurrRealVisibleRange", "first", "last", "findRecyclerViewVisibleRange", "init", "recyclerView", "notifyItemShow", "info", "Lcom/yy/appbase/common/helper/ViewVisibleInfo;", "notifyItemVisibleChange", "state", "Lcom/yy/appbase/common/helper/VisibleState;", "notifyVisibleRangeChange", "lastRemainTime", "onScrollStateChanged", "newState", "onScrolled", "dx", "dy", "onVisibleCheck", "task", "visibleMap", "recordRecyclerView", "refresh", "removeItemVisibleChangeListener", "removeVisibleRangeChangeListener", "start", "stop", "appbase_debug"})
public final class RecyclerViewItemRecorder
extends RecyclerView.OnScrollListener
implements VisibleCheckCallback {
    private boolean isNewRound;
    private RecyclerView currRecyclerView;
    private boolean isRecording;
    private boolean checkRealVisible;
    private long currRangeVisibleStartTime;
    private IntRange currVisibleRange;
    private final Map<Integer, VisibleItem> currVisibleItemMap;
    private final List<VisibleCheckTimerTask> visibleCheckTimerTasks;
    private final List<OnItemShowListener> itemShowListeners;
    private Set<OnItemVisibleChangeListener> itemVisibleChangeListeners;
    private Set<OnVisibleRangeChangeListener> visibleRangeChangeListeners;
    private final long threshold;

    public final boolean isRecording() {
        return this.isRecording;
    }

    public final boolean getCheckRealVisible() {
        return this.checkRealVisible;
    }

    public final void setCheckRealVisible(boolean bl) {
        this.checkRealVisible = bl;
    }

    public final void init(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        this.currRecyclerView = recyclerView;
    }

    public final void addItemVisibleChangeListener(@NotNull OnItemVisibleChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.itemVisibleChangeListeners.add(listener2);
    }

    public final void removeItemVisibleChangeListener(@NotNull OnItemVisibleChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.itemVisibleChangeListeners.remove(listener2);
    }

    public final void addVisibleRangeChangeListener(@NotNull OnVisibleRangeChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.visibleRangeChangeListeners.add(listener2);
    }

    public final void removeVisibleRangeChangeListener(@NotNull OnVisibleRangeChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.visibleRangeChangeListeners.remove(listener2);
    }

    public final void start() {
        this.isRecording = true;
        this.isNewRound = true;
        this.recordRecyclerView();
    }

    public final void stop() {
        this.checkVisibleChange(this.currVisibleRange, IntRange.Companion.getEMPTY());
        Iterable $this$forEach$iv = this.visibleCheckTimerTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisibleCheckTimerTask it = (VisibleCheckTimerTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.visibleCheckTimerTasks.clear();
        this.currRangeVisibleStartTime = 0L;
        this.currVisibleRange = IntRange.Companion.getEMPTY();
        this.currVisibleItemMap.clear();
        this.isRecording = false;
    }

    public final void refresh() {
        if (this.isRecording) {
            this.stop();
            this.start();
        }
    }

    public final void clear() {
        if (this.isRecording) {
            this.stop();
        }
        this.itemShowListeners.clear();
        this.itemVisibleChangeListeners.clear();
        this.visibleRangeChangeListeners.clear();
        RecyclerView recyclerView = this.currRecyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
        }
        this.currRecyclerView = null;
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        if (newState == 0) {
            this.recordRecyclerView();
        }
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        if (this.isNewRound) {
            this.recordRecyclerView();
            this.isNewRound = false;
        }
    }

    private final void recordRecyclerView() {
        if (!this.isRecording) {
            return;
        }
        IntRange lastRange = this.currVisibleRange;
        IntRange currRange = this.findRecyclerViewVisibleRange();
        long lastStartTime = this.currRangeVisibleStartTime;
        long currStartTime = System.currentTimeMillis();
        this.notifyVisibleRangeChange(currRange, lastRange, lastRange.isEmpty() ? 0L : currStartTime - lastStartTime);
        Map<Integer, VisibleItem> newVisibleItemMap = this.calculateNewVisibleMap(lastRange, currRange, currStartTime);
        Object $this$forEach$iv = this.visibleCheckTimerTasks;
        boolean $i$f$forEach22 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            VisibleCheckTimerTask it = (VisibleCheckTimerTask)element$iv;
            boolean bl = false;
            it.clearIfNotIn(currRange);
        }
        $this$forEach$iv = newVisibleItemMap;
        $i$f$forEach22 = false;
        if (!$this$forEach$iv.isEmpty()) {
            $this$forEach$iv = new VisibleCheckTimerTask(newVisibleItemMap, this, this.threshold);
            $i$f$forEach22 = false;
            boolean bl = false;
            Object it = $this$forEach$iv;
            boolean bl2 = false;
            this.visibleCheckTimerTasks.add((VisibleCheckTimerTask)it);
            ((VisibleCheckTimerTask)$this$forEach$iv).post();
        }
        this.checkVisibleChange(lastRange, currRange);
        Map<Integer, VisibleItem> $i$f$forEach22 = this.currVisibleItemMap;
        boolean bl = false;
        Iterator<Map.Entry<Integer, VisibleItem>> it = $i$f$forEach22.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, VisibleItem> entry = it.next();
            if (currRange.contains(((Number)entry.getKey()).intValue())) continue;
            it.remove();
        }
        this.currVisibleItemMap.putAll(newVisibleItemMap);
        this.currRangeVisibleStartTime = currStartTime;
        this.currVisibleRange = currRange;
    }

    private final IntRange findRecyclerViewVisibleRange() {
        RecyclerView recyclerView = this.currRecyclerView;
        Object lm = recyclerView != null ? recyclerView.getLayoutManager() : null;
        RecyclerView.LayoutManager layoutManager = lm;
        if (layoutManager instanceof LinearLayoutManager) {
            int first = ((LinearLayoutManager)lm).findFirstVisibleItemPosition();
            int last = ((LinearLayoutManager)lm).findLastVisibleItemPosition();
            return this.findCurrRealVisibleRange(first, last);
        }
        if (layoutManager instanceof GridLayoutManager) {
            int first = ((GridLayoutManager)lm).findFirstVisibleItemPosition();
            int last = ((GridLayoutManager)lm).findLastVisibleItemPosition();
            return this.findCurrRealVisibleRange(first, last);
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int[] firstItems = new int[((StaggeredGridLayoutManager)lm).getSpanCount()];
            ((StaggeredGridLayoutManager)lm).findFirstVisibleItemPositions(firstItems);
            int[] lastItems = new int[((StaggeredGridLayoutManager)lm).getSpanCount()];
            ((StaggeredGridLayoutManager)lm).findLastVisibleItemPositions(lastItems);
            int first = firstItems[0];
            int last = lastItems[((StaggeredGridLayoutManager)lm).getSpanCount() - 1];
            return this.findCurrRealVisibleRange(first, last);
        }
        return IntRange.Companion.getEMPTY();
    }

    private final boolean checkItemCurrRealVisible(int pos) {
        boolean bl;
        RecyclerView.ViewHolder holder;
        RecyclerView recyclerView = this.currRecyclerView;
        Object object = holder = recyclerView != null ? recyclerView.findViewHolderForAdapterPosition(pos) : null;
        if (holder == null) {
            bl = false;
        } else if (this.checkRealVisible) {
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            bl = ViewHelper.INSTANCE.checkVisible(view);
        } else {
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            bl = ViewHelper.INSTANCE.checkVerticalVisible(view);
        }
        return bl;
    }

    private final IntRange findCurrRealVisibleRange(int first, int last) {
        IntRange intRange;
        if (first >= 0 && last >= 0) {
            int realLast;
            int realFirst;
            for (realFirst = first; !this.checkItemCurrRealVisible(realFirst) && realFirst <= last; ++realFirst) {
            }
            for (realLast = last; !this.checkItemCurrRealVisible(realLast) && realLast >= realFirst; --realLast) {
            }
            if (realFirst <= realLast) {
                int n = realFirst;
                intRange = new IntRange(n, realLast);
            } else {
                intRange = IntRange.Companion.getEMPTY();
            }
        } else {
            intRange = IntRange.Companion.getEMPTY();
        }
        return intRange;
    }

    private final void checkVisibleChange(IntRange lastRange, IntRange currRange) {
        int i;
        int n;
        long currTime = System.currentTimeMillis();
        IntRange intRange = lastRange;
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                if (!currRange.contains(i)) {
                    VisibleItem visibleItem = this.currVisibleItemMap.get(i);
                    long visibleStartTime = visibleItem != null ? visibleItem.getVisibleTimeStamp() : currTime;
                    long visibleDuration = currTime - visibleStartTime;
                    this.notifyItemVisibleChange(i, new ItemInvisible(visibleDuration));
                }
                if (i == n) break;
                ++i;
            }
        }
        IntRange intRange2 = currRange;
        i = intRange2.getFirst();
        if (i <= (n = intRange2.getLast())) {
            while (true) {
                if (!lastRange.contains(i)) {
                    this.notifyItemVisibleChange(i, new ItemVisible());
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void notifyVisibleRangeChange(IntRange currRange, IntRange lastRange, long lastRemainTime) {
        Iterable $this$forEach$iv = this.visibleRangeChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnVisibleRangeChangeListener it = (OnVisibleRangeChangeListener)element$iv;
            boolean bl = false;
            it.onVisibleRangeChange(currRange, lastRange, lastRemainTime);
        }
    }

    private final void notifyItemVisibleChange(int pos, VisibleState state) {
        Iterable $this$forEach$iv = this.itemVisibleChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnItemVisibleChangeListener it = (OnItemVisibleChangeListener)element$iv;
            boolean bl = false;
            it.onItemVisibleChange(pos, state);
        }
    }

    private final Map<Integer, VisibleItem> calculateNewVisibleMap(IntRange lastRange, IntRange currRange, long time) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)currRange;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int pos = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            if (lastRange.contains(pos)) continue;
            result.put(pos, new VisibleItem(pos, time));
        }
        return result;
    }

    @Override
    public void onVisibleCheck(@NotNull VisibleCheckTimerTask task2, @NotNull Map<Integer, VisibleItem> visibleMap) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        Intrinsics.checkParameterIsNotNull(visibleMap, (String)"visibleMap");
        IntRange visibleRange = this.findRecyclerViewVisibleRange();
        Iterable $this$forEach$iv = visibleMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisibleItem it = (VisibleItem)element$iv;
            boolean bl = false;
            if (!visibleRange.contains(it.getPos())) continue;
            ViewVisibleInfo viewVisibleInfo = new ViewVisibleInfo();
            int n = it.getPos();
            RecyclerViewItemRecorder recyclerViewItemRecorder = this;
            boolean bl2 = false;
            boolean bl3 = false;
            ViewVisibleInfo $this$apply = viewVisibleInfo;
            boolean bl4 = false;
            if (this.currRecyclerView != null) {
                RecyclerView recyclerView;
                boolean bl5 = false;
                boolean bl6 = false;
                RecyclerView recyclerView2 = recyclerView;
                boolean bl7 = false;
                RecyclerView.ViewHolder holder = recyclerView2.findViewHolderForAdapterPosition(it.getPos());
                if (holder != null) {
                    View view = holder.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
                    $this$apply.setVisibleHeight(ViewHelper.INSTANCE.getAbsoluteVisibleHeight(view, (View)recyclerView2));
                    View view2 = holder.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
                    $this$apply.setTotalHeight(view2.getMeasuredHeight());
                }
            }
            ViewVisibleInfo viewVisibleInfo2 = viewVisibleInfo;
            recyclerViewItemRecorder.notifyItemShow(n, viewVisibleInfo2);
        }
        this.visibleCheckTimerTasks.remove(task2);
    }

    private final void notifyItemShow(int pos, ViewVisibleInfo info) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"RecyclerViewItemRecorder", (String)("notifyItemShow pos=" + pos), (Object[])new Object[0]);
        }
        Iterable $this$forEach$iv = this.itemShowListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnItemShowListener it = (OnItemShowListener)element$iv;
            boolean bl = false;
            it.onItemShow(pos, info);
        }
    }

    public final void addItemShowListener(@NotNull OnItemShowListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.itemShowListeners.add(listener2);
    }

    public RecyclerViewItemRecorder(long threshold) {
        this.threshold = threshold;
        this.isNewRound = true;
        this.currVisibleRange = IntRange.Companion.getEMPTY();
        RecyclerViewItemRecorder recyclerViewItemRecorder = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        recyclerViewItemRecorder.currVisibleItemMap = object;
        recyclerViewItemRecorder = this;
        bl = false;
        recyclerViewItemRecorder.visibleCheckTimerTasks = object = (List)new ArrayList();
        recyclerViewItemRecorder = this;
        bl = false;
        recyclerViewItemRecorder.itemShowListeners = object = (List)new ArrayList();
        recyclerViewItemRecorder = this;
        bl = false;
        recyclerViewItemRecorder.itemVisibleChangeListeners = object = (Set)new LinkedHashSet();
        recyclerViewItemRecorder = this;
        bl = false;
        recyclerViewItemRecorder.visibleRangeChangeListeners = object = (Set)new LinkedHashSet();
    }

    public /* synthetic */ RecyclerViewItemRecorder(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 1000L;
        }
        this(l);
    }

    public RecyclerViewItemRecorder() {
        this(0L, 1, null);
    }
}

