/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.animation.AnimationAdapter;
import com.yy.appbase.ui.utils.AnimatorUtils;

public class ScaleAnimationAdapter
extends AnimationAdapter {
    private float mFrom;
    private int mHeight = 0;
    private int mOffsetY = 0;
    private boolean isCanAnim = true;

    public ScaleAnimationAdapter(RecyclerView.Adapter adapter) {
        super((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
    }

    @Override
    @Nullable
    protected Animator[] getAnimators(final View view, final int direction) {
        if (!AnimatorUtils.canAnimation() || !this.isCanAnim) {
            return null;
        }
        int width = view.getMeasuredWidth();
        if (width <= 0) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    ScaleAnimationAdapter.this.setPivot(view, direction);
                }
            });
        } else {
            this.setPivot(view, direction);
        }
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{this.mFrom, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{this.mFrom, 1.0f});
        return new ObjectAnimator[]{scaleX, scaleY};
    }

    @Override
    @Nullable
    protected PropertyValuesHolder[] getAnimatorValuesHolders(final View view, final int direction) {
        if (!AnimatorUtils.canAnimation() || !this.isCanAnim) {
            return null;
        }
        int width = view.getMeasuredWidth();
        if (width <= 0) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    ScaleAnimationAdapter.this.setPivot(view, direction);
                }
            });
        } else {
            this.setPivot(view, direction);
        }
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{this.mFrom, 1.0f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{this.mFrom, 1.0f});
        return new PropertyValuesHolder[]{scaleX, scaleY};
    }

    public void setOffsetY(int offsetY) {
        this.mOffsetY = offsetY;
    }

    public void setScaleFrom(float from) {
        this.mFrom = from;
    }

    private void setPivot(View view, int direction) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        if (direction == 2) {
            view.setPivotY((float)this.mOffsetY);
        } else {
            view.setPivotY((float)(-this.mOffsetY));
        }
    }

    public void setCanAnim(boolean canAnim) {
        this.isCanAnim = canAnim;
    }
}

