/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.account;

import android.content.SharedPreferences;
import android.text.format.DateUtils;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import java.util.Date;

public class AccountUtil {
    private static final String TAG = "AccountUtil";
    private static volatile long sUid = 0L;
    private static volatile int sLoginType;
    private static volatile boolean sNewRegister;
    private static volatile String registerCountry;
    private static volatile String realCountry;
    private static final String KEY_REGISTER_TIME = "register_time_";
    private static final String KEY_LAST_LOGIN_TIME = "last_login_time";
    private static final String KEY_CONTINUOUS_LOGIN_COUNT = "continuous_login_count";
    private static boolean isSevenDayNoLogin;
    private static String lastLoginTimeKey;
    private static int sResultType;
    public static final String KEY_ZALO_BIND = "key_zalo_accout_bind_";

    public static long getUid() {
        return sUid;
    }

    public static void updateUid(long uid) {
        sUid = uid;
        MLog.info((Object)TAG, (String)"uid:%s", (Object[])new Object[]{uid});
    }

    public static String getLoginChannel() {
        if (sLoginType != 10) {
            return "other";
        }
        return SettingFlags.getStringValue((String)"key_login_channel", (String)"other");
    }

    public static void setLoginType(int type2) {
        sLoginType = type2;
    }

    public static int getsLoginType() {
        return sLoginType;
    }

    public static void setResultType(int resultType) {
        sResultType = resultType;
    }

    public static int getResultType() {
        return sResultType;
    }

    public static boolean isLoginByGuest() {
        return sLoginType == 10;
    }

    public static void setRealCountry(String realCountry) {
        AccountUtil.realCountry = realCountry;
    }

    public static String registerCountry() {
        return registerCountry;
    }

    public static String realCountry() {
        return realCountry;
    }

    public static void setRegisterCountry(String country) {
        if (country != null) {
            registerCountry = country.toUpperCase();
        }
    }

    public static SharedPreferences getAccountSetting() {
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, String.valueOf(AccountUtil.getUid()), 0);
    }

    public static boolean isNewRegister() {
        return sNewRegister || EnvSettings.instance().isTodayRegisteredTest();
    }

    public static void setNewRegister(boolean newRegister) {
        MLog.info((Object)TAG, (String)("setNewRegister: " + newRegister), (Object[])new Object[0]);
        sNewRegister = newRegister;
        if (newRegister) {
            SettingFlags.setLongValue((String)AccountUtil.registerTimeKey(), (long)System.currentTimeMillis());
        }
    }

    public static void updateRegisterTimes(long timeSpace) {
        MLog.info((Object)TAG, (String)("updateRegisterTimes: " + timeSpace), (Object[])new Object[0]);
        if (AccountUtil.getRegisterTime() == 0L) {
            MLog.info((Object)TAG, (String)("updateRegisterTimes: " + timeSpace), (Object[])new Object[0]);
            SettingFlags.setLongValue((String)AccountUtil.registerTimeKey(), (long)timeSpace);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_REGISTER_TIME_UPDATE));
        }
    }

    public static void upDateLastLoginTime() {
        if (!AccountUtil.getLastLoginTimeKey().equals(lastLoginTimeKey)) {
            AccountUtil.updateIsSevenDayNoLogin();
            AccountUtil.updateContinuousLoginDayCount();
            MLog.info((Object)TAG, (String)"lastLoginTimeKey", (Object[])new Object[0]);
            SettingFlags.setLongValue((String)AccountUtil.getLastLoginTimeKey(), (long)System.currentTimeMillis());
            lastLoginTimeKey = AccountUtil.getLastLoginTimeKey();
        }
    }

    private static void updateContinuousLoginDayCount() {
        long lastLoginTime = AccountUtil.getLastLoginTime();
        if (DateUtils.isToday((long)lastLoginTime)) {
            return;
        }
        String spKey = AccountUtil.getContinuousLoginDayKey();
        if (DateUtils.isToday((long)(new Date(lastLoginTime).getTime() + 86400000L))) {
            int continuousLoginDayCount = SettingFlags.getIntValue((String)AccountUtil.getContinuousLoginDayKey(), (int)0);
            SettingFlags.setIntValue((String)spKey, (int)(continuousLoginDayCount + 1));
        } else {
            SettingFlags.setIntValue((String)spKey, (int)1);
        }
    }

    public static int getContinuousLoginDayCount() {
        return SettingFlags.getIntValue((String)AccountUtil.getContinuousLoginDayKey(), (int)1);
    }

    public static long getRegisterTime() {
        long registerTime = 0L;
        String key = AccountUtil.registerTimeKey();
        registerTime = SettingFlags.containKey((String)key) ? SettingFlags.getLongValue((String)key) : SharedPreferencesUtils.getDefaultPrf().getLong(key, 0L);
        return registerTime;
    }

    public static long getLastLoginTime() {
        long lastLoginTime = 0L;
        String key = AccountUtil.getLastLoginTimeKey();
        lastLoginTime = SettingFlags.containKey((String)key) ? SettingFlags.getLongValue((String)key) : SharedPreferencesUtils.getDefaultPrf().getLong(key, 0L);
        return lastLoginTime;
    }

    public static boolean isInTwentyFourHours() {
        long registerTime = AccountUtil.getRegisterTime();
        long nowTime = System.currentTimeMillis();
        return nowTime <= registerTime || nowTime - registerTime <= 86400000L;
    }

    public static boolean isNewRegisterInThreeDays() {
        long registerTime = AccountUtil.getRegisterTime();
        if (registerTime == 0L) {
            return false;
        }
        long during = System.currentTimeMillis() - registerTime;
        return during < 259200000L;
    }

    public static boolean isTodayRegister() {
        long registerTime = AccountUtil.getRegisterTime();
        return DateUtils.isToday((long)registerTime) || EnvSettings.instance().isTodayRegisteredTest();
    }

    public static synchronized boolean isSevenDayNoLogin() {
        return isSevenDayNoLogin;
    }

    private static void updateIsSevenDayNoLogin() {
        long lastLoginTime = AccountUtil.getLastLoginTime();
        if (lastLoginTime > 0L) {
            int days = (int)((System.currentTimeMillis() - lastLoginTime) / 86400000L);
            MLog.info((Object)TAG, (String)"updateIsSevenDayNoLogin days = %d", (Object[])new Object[]{days});
            isSevenDayNoLogin = days > 6;
        }
    }

    private static String registerTimeKey() {
        return KEY_REGISTER_TIME + sUid;
    }

    private static String getLastLoginTimeKey() {
        return KEY_LAST_LOGIN_TIME + sUid;
    }

    private static String getContinuousLoginDayKey() {
        return KEY_CONTINUOUS_LOGIN_COUNT + sUid;
    }

    public static boolean isShowZaloBind() {
        return sLoginType != 1 && (LanguageUtils.isVietnamese() || RuntimeContext.sIsDebuggable);
    }

    public static boolean hideFacebookBind() {
        return sLoginType == 7 || SettingFlags.getBoolean((String)(KEY_ZALO_BIND + sUid), (boolean)false);
    }

    static {
        sNewRegister = false;
        registerCountry = "";
        realCountry = "";
        isSevenDayNoLogin = false;
        sResultType = -1;
    }
}

