/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.ABType;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IABConfig;
import com.yy.appbase.abtest.RandomAB;
import com.yy.appbase.abtest.localab.LocalPercent;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ABConfig<T extends IAB>
extends KvoSource
implements IABConfig<T> {
    private static final String TAG = "ABConfig";
    private String abTestId = "";
    private final Set<T> testList = new HashSet<T>();
    public static final String kvo_test = "test";
    @KvoFieldAnnotation(name="test")
    private T test;
    @Deprecated
    private T defaultTest;
    private ABType abType = ABType.NONE;

    private ABConfig() {
    }

    public static ABConfig<IAB> obtain(@NonNull String abTestId, IAB ... testList) {
        return ABConfig.obtainWithDefault(abTestId, null, testList);
    }

    @Deprecated
    public static ABConfig<IAB> obtainWithDefault(@NonNull String abTestId, @Nullable IAB defaultTest, IAB ... testList) {
        return ABConfig.obtainWithDefault(abTestId, null, defaultTest, testList);
    }

    @Deprecated
    private static ABConfig<IAB> obtainWithDefault(@NonNull String abTestId, ABType type2, @Nullable IAB defaultTest, IAB ... testList) {
        if (TextUtils.isEmpty((CharSequence)abTestId)) {
            throw new IllegalArgumentException("abTestId can not be empty!");
        }
        if (defaultTest instanceof RandomAB && FP.empty((Object[])testList)) {
            throw new IllegalArgumentException("testList can not be empty, while defaultTest is RandomAB!");
        }
        ABConfig<IAB> config = new ABConfig<IAB>();
        config.abTestId = abTestId;
        if (!FP.empty((Object[])testList)) {
            config.testList.addAll(Arrays.asList(testList));
        } else {
            config.testList.addAll(Arrays.asList(NAB.A, NAB.B, NAB.C, NAB.D, NAB.E, NAB.F, NAB.H, NAB.I));
        }
        config.defaultTest = defaultTest;
        if (type2 == null || type2 == ABType.NONE) {
            ABConfig.checkType(config);
        } else {
            config.abType = type2;
        }
        NewABDefine.INSTANCE.addConfig(config);
        return config;
    }

    @Override
    @NotNull
    public String getTestId() {
        return this.abTestId;
    }

    private static void checkType(ABConfig<IAB> config) {
        IAB current = config.getTestInner();
        if (current != null) {
            config.abType = current instanceof NAB ? ABType.NEW : ABType.OLD;
        }
        for (IAB ab : config.testList) {
            ABType type2;
            ABType aBType = type2 = ab instanceof NAB ? ABType.NEW : ABType.OLD;
            if (config.abType == ABType.NONE) {
                config.abType = ab instanceof NAB ? ABType.NEW : ABType.OLD;
                continue;
            }
            if (config.abType == type2) continue;
            throw new IllegalArgumentException("testList must be the same type of " + (Object)((Object)config.abType));
        }
    }

    synchronized void setTestAndSave(T newValue) {
        this.setValue(kvo_test, newValue);
    }

    public void setLocalTest(T localTest) {
        if (RuntimeContext.sIsDebuggable) {
            if (localTest == null) {
                SettingFlags.removeKey((String)this.abTestId);
            } else {
                SettingFlags.setIntValue((String)this.abTestId, (int)ABType.LOCAL.value());
                this.setTestAndSave(localTest);
            }
        }
    }

    @Override
    public void setTest(T value) {
        MLog.debug((Object)TAG, (String)("setTest value: " + value), (Object[])new Object[0]);
        this.setTestAndSave(value);
    }

    @Override
    public boolean isValid() {
        T current = this.getTestInner();
        return current != null && current.isValid();
    }

    private T randomTest() {
        int size = this.testList.size();
        int random = LocalPercent.random(size);
        int i = 0;
        for (IAB ab : this.testList) {
            if (i == random) {
                return (T)ab;
            }
            ++i;
        }
        return null;
    }

    @Override
    @Nullable
    public T getTest() {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"abTestId:%s, value:%s", (Object[])new Object[]{this.abTestId, this.test != null ? this.test.toString() : ""});
        }
        this.report();
        return this.getTestInner();
    }

    @Nullable
    public T getTestWithoutReport() {
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"abTestId:%s, value:%s", (Object[])new Object[]{this.abTestId, this.test != null ? this.test.toString() : ""});
        }
        return this.getTestInner();
    }

    synchronized T getTestInner() {
        return this.test;
    }

    @Override
    public boolean matchA() {
        return this.match(NAB.A);
    }

    @Override
    public boolean matchB() {
        return this.match(NAB.B);
    }

    @Override
    public boolean matchC() {
        return this.match(NAB.C);
    }

    @Override
    public boolean matchD() {
        return this.match(NAB.D);
    }

    @Override
    public boolean matchE() {
        return this.match(NAB.E);
    }

    @Override
    public boolean matchF() {
        return this.match(NAB.F);
    }

    @Override
    public boolean matchH() {
        return this.match(NAB.H);
    }

    @Override
    public boolean matchI() {
        return this.match(NAB.I);
    }

    private boolean match(IAB compare) {
        T current = this.getTest();
        return compare != null && compare.equals(current);
    }

    private void report() {
        NewABDefine.INSTANCE.report(this);
    }

    @Deprecated
    @NonNull
    public T getTestOrDefault() {
        if (!this.isValid()) {
            T ab = this.defaultTest;
            if (this.defaultTest != null) {
                if (this.defaultTest instanceof RandomAB) {
                    ab = this.randomTest();
                }
                MLog.info((Object)TAG, (String)"getTestOrDefault set default test: %s", (Object[])new Object[]{ab});
            } else {
                String msg = StringUtils.formatWitUSLocal((String)"abTestId: %s, defaultTest is null, you need to init by #obtainWithDefault() with defaultTest", (Object[])new Object[]{this.abTestId});
                if (RuntimeContext.sIsDebuggable) {
                    throw new IllegalArgumentException(msg);
                }
                ab = this.randomTest();
                MLog.error((Object)TAG, (String)"random test: %s, msg: %s", (Object[])new Object[]{ab, msg});
            }
            this.setTestAndSave(ab);
        }
        return this.getTest();
    }

    public String getHiidoValue() {
        if (!this.isValid()) {
            return "";
        }
        return this.getTestInner().getHiidoValue();
    }

    public String getValue(String key) {
        T current = this.getTestInner();
        return current == null ? "" : current.getValue(key);
    }

    public ABType getAbType() {
        if (RuntimeContext.sIsDebuggable && SettingFlags.containKey((String)this.abTestId)) {
            int type2 = SettingFlags.getIntValue((String)this.abTestId);
            return ABType.of(type2);
        }
        return this.abType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ABConfig) {
            return this.abTestId.equals(((ABConfig)obj).abTestId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.abTestId.hashCode();
    }

    public String toString() {
        return "ABConfig{abTestId='" + this.abTestId + '\'' + ", test=" + this.getTestInner() + '}';
    }
}

