/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.perfcat;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.apm.perfcat.PerfCatHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/yy/hiyo/apm/perfcat/PerfCatHelper;", "", "()V", "SCHEME_RECORD_URI", "", "SCHEME_START_URI", "SCHEME_STOP_RECORD_URI", "SCHEME_STOP_URI", "TAG", "VER_CODE", "", "packageName", "copyAssetsFile", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "verCode", "installApk", "", "isAppInstall", "Landroid/content/pm/PackageInfo;", "mContext", "perfcatIsInstall", "", "recordPerfCat", "startPerfCat", "stopPerfCat", "stopRecordPerfCat", "apm_release"})
public final class PerfCatHelper {
    private static final String TAG = "PerfCatHelper";
    private static final int VER_CODE = 2;
    private static String SCHEME_START_URI;
    private static String SCHEME_STOP_URI;
    private static String SCHEME_RECORD_URI;
    private static String SCHEME_STOP_RECORD_URI;
    private static String packageName;
    public static final PerfCatHelper INSTANCE;

    public final boolean startPerfCat() {
        try {
            if (!this.perfcatIsInstall()) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)SCHEME_START_URI));
            intent.addFlags(0x10000000);
            RuntimeContext.sApplicationContext.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"perfcat.apk\u53ea\u4f1a\u5728\u672c\u5730\u73af\u5883\u5f15\u5165\uff0c\u8bf7\u5148\u5728\u672c\u5730\u73af\u5883\u5b89\u88c5\u4e0aperfcat\u7136\u540e\u518d\u4f7f\u7528", (int)0);
            return false;
        }
    }

    public final boolean stopPerfCat() {
        try {
            if (!this.perfcatIsInstall()) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)SCHEME_STOP_URI));
            intent.addFlags(0x10000000);
            RuntimeContext.sApplicationContext.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"perfcat.apk\u53ea\u4f1a\u5728\u672c\u5730\u73af\u5883\u5f15\u5165\uff0c\u8bf7\u5148\u5728\u672c\u5730\u73af\u5883\u5b89\u88c5\u4e0aperfcat\u7136\u540e\u518d\u4f7f\u7528", (int)0);
            return false;
        }
    }

    public final boolean stopRecordPerfCat() {
        try {
            if (!this.perfcatIsInstall()) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)SCHEME_STOP_RECORD_URI));
            intent.addFlags(0x10000000);
            RuntimeContext.sApplicationContext.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"perfcat.apk\u53ea\u4f1a\u5728\u672c\u5730\u73af\u5883\u5f15\u5165\uff0c\u8bf7\u5148\u5728\u672c\u5730\u73af\u5883\u5b89\u88c5\u4e0aperfcat\u7136\u540e\u518d\u4f7f\u7528", (int)0);
            return false;
        }
    }

    public final boolean recordPerfCat() {
        try {
            if (!this.perfcatIsInstall()) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)SCHEME_RECORD_URI));
            intent.addFlags(0x10000000);
            RuntimeContext.sApplicationContext.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"perfcat.apk\u53ea\u4f1a\u5728\u672c\u5730\u73af\u5883\u5f15\u5165\uff0c\u8bf7\u5148\u5728\u672c\u5730\u73af\u5883\u5b89\u88c5\u4e0aperfcat\u7136\u540e\u518d\u4f7f\u7528", (int)0);
            return false;
        }
    }

    private final boolean perfcatIsInstall() {
        PackageInfo packageInfo;
        boolean isInstall;
        block5: {
            isInstall = false;
            packageInfo = null;
            try {
                Context context = RuntimeContext.sApplicationContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                packageInfo = context.getPackageManager().getPackageInfo("com.yy.perfcat", 0);
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block5;
                MLog.info((Object)TAG, (String)"\u6ca1\u6709\u53d1\u73b0\u5b89\u88c5\u7684\u5305\u540d", (Object[])new Object[0]);
            }
        }
        if (packageInfo != null) {
            int versionCode = packageInfo.versionCode;
            if (versionCode < 2) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u5347\u7ea7perfcat,\u8bf7\u5347\u7ea7\u5b8c\u6210\u540e\u91cd\u65b0\u542f\u52a8", (int)0);
                YYTaskExecutor.execute((Runnable)new Runnable(versionCode){
                    final /* synthetic */ int $versionCode;

                    public final void run() {
                        Context context = RuntimeContext.sApplicationContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                        PerfCatHelper.access$installApk(PerfCatHelper.INSTANCE, context, this.$versionCode);
                    }
                    {
                        this.$versionCode = n;
                    }
                });
                return isInstall;
            }
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u5b89\u88c5perfcat,\u8bf7\u5b89\u88c5\u5b8c\u6210\u540e\u91cd\u65b0\u542f\u52a8", (int)0);
            YYTaskExecutor.execute((Runnable)perfcatIsInstall.2.INSTANCE);
            return isInstall;
        }
        isInstall = true;
        return isInstall;
    }

    private final void installApk(Context context, int verCode) {
        Uri uri = this.copyAssetsFile(context, verCode);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(uri, context){
            final /* synthetic */ Uri $uri;
            final /* synthetic */ Context $context;

            public final void run() {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                if (Build.VERSION.SDK_INT >= 24) {
                    intent.addFlags(1);
                }
                intent.setDataAndType(this.$uri, "application/vnd.android.package-archive");
                intent.addFlags(0x10000000);
                this.$context.startActivity(intent);
            }
            {
                this.$uri = uri;
                this.$context = context;
            }
        });
    }

    private final Uri copyAssetsFile(Context context, int verCode) {
        Uri uri;
        try {
            InputStream inputStream = context.getAssets().open("perfcat.apk.1");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.assets.open(\"perfcat.apk.1\")");
            InputStream mInputStream = inputStream;
            StringBuilder stringBuilder = new StringBuilder();
            File file = FileStorageUtils.getInstance().getExternalFileDir("perfcat");
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileStorageUtils.getInst\u2026xternalFileDir(\"perfcat\")");
            File mFile = new File(stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("perfcat_").append(verCode).append(".apk").toString());
            if (!mFile.exists()) {
                mFile.createNewFile();
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u5f00\u59cb\u62f7\u8d1d", (Object[])new Object[0]);
            }
            FileOutputStream mFileOutputStream = new FileOutputStream(mFile);
            byte[] mbyte = new byte[1024];
            int i = 0;
            while (true) {
                int n = mInputStream.read(mbyte);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                i = it;
                if (n <= 0) break;
                mFileOutputStream.write(mbyte, 0, i);
            }
            mInputStream.close();
            mFileOutputStream.close();
            Uri uri2 = null;
            try {
                uri2 = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)(packageName + ".fileprovider"), (File)mFile) : Uri.fromFile((File)mFile);
            }
            catch (ActivityNotFoundException e) {
                MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{mFile.getAbsolutePath()}, null, null);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("\u62f7\u8d1d\u5b8c\u6bd5\uff1a" + uri2), (Object[])new Object[0]);
            }
            uri = uri2;
        }
        catch (IOException e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"perfcat.apk.1 not existsor write err", (Object[])new Object[0]);
            uri = null;
        }
        catch (Exception e) {
            uri = null;
        }
        return uri;
    }

    private final PackageInfo isAppInstall(Context mContext) {
        PackageInfo mInfo;
        block2: {
            mInfo = null;
            try {
                mInfo = mContext.getPackageManager().getPackageInfo("com.yy.perfcat", 0);
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block2;
                MLog.info((Object)TAG, (String)"\u6ca1\u6709\u53d1\u73b0\u5b89\u88c5\u7684\u5305\u540d", (Object[])new Object[0]);
            }
        }
        return mInfo;
    }

    private PerfCatHelper() {
    }

    static {
        PerfCatHelper perfCatHelper;
        INSTANCE = perfCatHelper = new PerfCatHelper();
        SCHEME_START_URI = "perfcat://test/start?packageName=com.yy.hiyo";
        SCHEME_STOP_URI = "perfcat://test/stop?packageName=com.yy.hiyo";
        SCHEME_RECORD_URI = "perfcat://test/record?packageName=com.yy.hiyo";
        SCHEME_STOP_RECORD_URI = "perfcat://test/stopRecord?packageName=com.yy.hiyo";
        packageName = "com.yy.hiyo";
        String string = RuntimeContext.sPackageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RuntimeContext.sPackageName");
        packageName = string;
        SCHEME_START_URI = "perfcat://test/start?packageName=" + packageName;
        SCHEME_STOP_URI = "perfcat://test/stop?packageName=" + packageName;
        SCHEME_RECORD_URI = "perfcat://test/record?packageName=" + packageName;
        SCHEME_STOP_RECORD_URI = "perfcat://test/stopRecord?packageName=" + packageName;
    }

    public static final /* synthetic */ void access$installApk(PerfCatHelper $this, Context context, int verCode) {
        $this.installApk(context, verCode);
    }
}

