/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.monitor;

import androidx.annotation.WorkerThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.apm.filestorage.FileStorageCloudConfig;
import com.yy.hiyo.apm.filestorage.FileStoragePref;
import com.yy.hiyo.apm.filestorage.internal.Constants;
import com.yy.hiyo.apm.filestorage.internal.FileInfo;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.LiteFileInfo;
import com.yy.hiyo.apm.filestorage.internal.monitor.FileStorageMonitor;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0017\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001a\u0010\u0019\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoRecursiveTask;", "", "()V", "fileDirs", "", "", "fullReport", "", "rootDir", "Ljava/io/File;", "rootDirPath", "rootDirType", "", "execute", "", "report", "fileInfo", "Lcom/yy/hiyo/apm/filestorage/internal/FileInfo;", "saveDirInfo", "Lcom/yy/hiyo/apm/filestorage/internal/LiteFileInfo;", "file", "fileSizeSubFile", "saveFileInfoUnRecursive", "traversalDirInfo", "depth", "traversalFileRecursive", "validateFileInfo", "apm_release"})
public final class FileInfoRecursiveTask {
    private int rootDirType;
    private File rootDir;
    private String rootDirPath;
    private List<String> fileDirs;
    private boolean fullReport;

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void execute(@NotNull File rootDir, int rootDirType, boolean fullReport) {
        block6: {
            File file;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
            if (!rootDir.exists()) {
                if (RuntimeContext.sIsDebuggable) {
                    throw (Throwable)new RuntimeException("rootDir not exist");
                }
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)("FileInfoTask execute: rootDir = " + rootDir.getAbsolutePath() + " ,fullReport = " + fullReport), (Object[])new Object[0]);
            }
            this.rootDir = rootDir;
            String string = rootDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rootDir.absolutePath");
            this.rootDirPath = string;
            File[] fileArray = rootDir.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"rootDir.listFiles()");
            Object object = fileArray;
            FileInfoRecursiveTask fileInfoRecursiveTask = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var9_11 = $this$mapTo$iv$iv;
            int n = ((void)var9_11).length;
            for (int i = 0; i < n; ++i) {
                void item$iv$iv;
                void var13_16 = item$iv$iv = var9_11[i];
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file");
                String string2 = v2.getAbsolutePath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            fileInfoRecursiveTask.fileDirs = collection;
            this.rootDirType = rootDirType;
            this.fullReport = fullReport;
            FileStorageCloudConfig.Config config = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
            if (config == null) break block6;
            object = config;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            LiteFileInfo rootLiteFileInfo = new LiteFileInfo(0L, 0, 3, null);
            int depth = fullReport ? ((FileStorageCloudConfig.Config)it).getFullReportConfig().getDepth() : ((FileStorageCloudConfig.Config)it).getInspectConfig().getDepth();
            List<String> list = this.fileDirs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileDirs");
            }
            for (String dir : list) {
                if (StringUtils.isEmpty((String)dir) || !(file = new File(dir)).exists()) continue;
                LiteFileInfo liteFileInfo = this.traversalFileRecursive(file, depth);
                LiteFileInfo liteFileInfo2 = rootLiteFileInfo;
                liteFileInfo2.setSubFileNum(liteFileInfo2.getSubFileNum() + liteFileInfo.getSubFileNum());
                LiteFileInfo liteFileInfo3 = rootLiteFileInfo;
                liteFileInfo3.setFileSize(liteFileInfo3.getFileSize() + liteFileInfo.getFileSize());
            }
            this.saveDirInfo(rootDir, rootLiteFileInfo);
        }
    }

    private final LiteFileInfo traversalFileRecursive(File file, int depth) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (file == null) {
            return liteFileInfo;
        }
        if (file.isFile()) {
            liteFileInfo = this.saveDirInfo(file);
        } else if (file.isDirectory()) {
            if (depth >= 0) {
                liteFileInfo = this.traversalDirInfo(file, depth - 1);
                this.saveDirInfo(file, liteFileInfo);
            } else {
                liteFileInfo = this.saveFileInfoUnRecursive(file);
            }
        }
        return liteFileInfo;
    }

    private final LiteFileInfo saveFileInfoUnRecursive(File file) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (file == null) {
            return liteFileInfo;
        }
        if (file.isFile()) {
            liteFileInfo = this.saveDirInfo(file);
        } else if (file.isDirectory()) {
            liteFileInfo = FileStorageHelper.traversalDir$default(FileStorageHelper.INSTANCE, file, null, 2, null);
        }
        return liteFileInfo;
    }

    private final LiteFileInfo saveDirInfo(File file) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (file == null) {
            return liteFileInfo;
        }
        liteFileInfo.setFileSize(FileStorageHelper.INSTANCE.getFileSize(file));
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        String string2 = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.absolutePath");
        FileInfo fileInfo = new FileInfo(string, string2, 0, 0L, 0L, 0, 0, 0, 0, 0, 1020, null);
        fileInfo.setRootDir(this.rootDirType);
        fileInfo.setFileType(FileStorageHelper.INSTANCE.getFileType(file));
        fileInfo.setLastModified(file.lastModified());
        fileInfo.setFileSize(FileStorageHelper.INSTANCE.getFileSize(file));
        fileInfo.setReadable(file.canRead() ? 1 : 0);
        fileInfo.setWritable(file.canWrite() ? 1 : 0);
        fileInfo.setExecutable(file.canExecute() ? 1 : 0);
        if (file.isFile()) {
            fileInfo.setFileSize(FileStorageHelper.INSTANCE.getFileSize(file));
            liteFileInfo.setFileSize(fileInfo.getFileSize());
            fileInfo.setSubFileNum(1);
            liteFileInfo.setSubFileNum(fileInfo.getSubFileNum());
        }
        this.report(fileInfo);
        return liteFileInfo;
    }

    private final void saveDirInfo(File file, LiteFileInfo fileSizeSubFile) {
        block0: {
            File file2 = file;
            if (file2 == null) break block0;
            File file3 = file2;
            boolean bl = false;
            boolean bl2 = false;
            File it = file3;
            boolean bl3 = false;
            String string = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            String string2 = it.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.absolutePath");
            FileInfo fileInfo = new FileInfo(string, string2, 0, 0L, 0L, 0, 0, 0, 0, 0, 1020, null);
            fileInfo.setRootDir(this.rootDirType);
            fileInfo.setLastModified(it.lastModified());
            fileInfo.setFileType(FileStorageHelper.INSTANCE.getFileType(it));
            fileInfo.setFileSize(fileSizeSubFile.getFileSize());
            fileInfo.setReadable(it.canRead() ? 1 : 0);
            fileInfo.setWritable(it.canWrite() ? 1 : 0);
            fileInfo.setExecutable(it.canExecute() ? 1 : 0);
            fileInfo.setSubFileNum(fileSizeSubFile.getSubFileNum());
            this.report(fileInfo);
        }
    }

    private final LiteFileInfo traversalDirInfo(File file, int depth) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (file == null || !file.isDirectory()) {
            return liteFileInfo;
        }
        if (depth >= 0) {
            File[] files = file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                boolean bl = false;
                File[] fileArray2 = fileArray;
                boolean bl2 = false;
                if (!(fileArray2.length == 0)) {
                    int tmpDepth = depth - 1;
                    for (File f : files) {
                        LiteFileInfo tmpFileSizeSubFileNum = this.traversalFileRecursive(f, tmpDepth);
                        liteFileInfo.setFileSize(liteFileInfo.getFileSize() + tmpFileSizeSubFileNum.getFileSize());
                        liteFileInfo.setSubFileNum(liteFileInfo.getSubFileNum() + tmpFileSizeSubFileNum.getSubFileNum());
                    }
                }
            }
        } else {
            liteFileInfo = this.saveFileInfoUnRecursive(file);
        }
        return liteFileInfo;
    }

    private final boolean validateFileInfo(FileInfo fileInfo) {
        FileStorageCloudConfig.Config config = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
        if (config != null) {
            boolean onlyReportDir;
            long fileMinSize;
            FileStorageCloudConfig.Config config2 = config;
            boolean bl = false;
            boolean bl2 = false;
            FileStorageCloudConfig.Config it = config2;
            boolean bl3 = false;
            long l = fileMinSize = this.fullReport ? it.getFullReportConfig().getFileMinSize() : it.getInspectConfig().getFileMinSize();
            if (fileInfo.getFileSize() < fileMinSize) {
                boolean dirIgnoreMinSizeLimit;
                boolean bl4 = dirIgnoreMinSizeLimit = this.fullReport ? it.getFullReportConfig().getDirIgnoreMinSizeLimit() : it.getInspectConfig().getDirIgnoreMinSizeLimit();
                return fileInfo.getFileType() == Constants.FileType.INSTANCE.getDIR() && dirIgnoreMinSizeLimit;
            }
            boolean bl5 = onlyReportDir = this.fullReport ? it.getFullReportConfig().getOnlyReportDir() : it.getInspectConfig().getOnlyReportDir();
            if (onlyReportDir && fileInfo.getFileType() != Constants.FileType.INSTANCE.getDIR()) {
                return false;
            }
        }
        return true;
    }

    private final void report(FileInfo fileInfo) {
        if (!this.validateFileInfo(fileInfo)) {
            return;
        }
        try {
            JSONObject values = fileInfo.toJson(FileStorageMonitor.Companion.getTaskId());
            MLog.debug((Object)"FileStorageMonitor", (String)("report detail: " + values), (Object[])new Object[0]);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (!RuntimeContext.sIsDebuggable) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"real report detail", (Object[])new Object[0]);
            }
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagofile");
            statContent.put("type", Constants.ReportType.INSTANCE.getDETAIL());
            statContent.put("fn", fileInfo.getFileName());
            statContent.put("fp", fileInfo.getFilePath());
            statContent.put("rd", fileInfo.getRootDir());
            statContent.put("ft", fileInfo.getFileType());
            statContent.put("fs", fileInfo.getFileSize());
            statContent.put("lm", fileInfo.getLastModified());
            statContent.put("fw", fileInfo.getWritable());
            statContent.put("fr", fileInfo.getReadable());
            statContent.put("fe", fileInfo.getExecutable());
            statContent.put("sfn", fileInfo.getSubFileNum());
            long taskId = this.fullReport ? FileStorageMonitor.Companion.getTaskId() + 1L : FileStorageMonitor.Companion.getTaskId();
            statContent.put("tid", taskId);
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }
}

