/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.monitor;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.apm.filestorage.FileStorageCloudConfig;
import com.yy.hiyo.apm.filestorage.FileStoragePref;
import com.yy.hiyo.apm.filestorage.internal.Constants;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.LiteFileInfo;
import com.yy.hiyo.apm.filestorage.internal.monitor.FileInfoInspector;
import com.yy.hiyo.apm.filestorage.internal.monitor.FileStorageMonitor;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\f\u0018\u00002\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0007J4\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector;", "", "errorCallBack", "Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector$ErrorCallBack;", "(Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector$ErrorCallBack;)V", "availableExternalSize", "", "availableInternalSize", "maxStorageSize", "totalExternalSize", "totalInternalSize", "traversalCallBack", "com/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector$traversalCallBack$1", "Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector$traversalCallBack$1;", "checkSingleFile", "", "file", "Ljava/io/File;", "checkStorage", "inspectRoot", "report", "path", "", "size", "subFileNum", "", "errorType", "rootDir", "ErrorCallBack", "apm_release"})
public final class FileInfoInspector {
    private long totalInternalSize;
    private long availableInternalSize;
    private long availableExternalSize;
    private long totalExternalSize;
    private long maxStorageSize;
    private final traversalCallBack.1 traversalCallBack;
    private final ErrorCallBack errorCallBack;

    @WorkerThread
    public final void inspectRoot() {
        block7: {
            LiteFileInfo externalFilesFileInfo;
            LiteFileInfo externalCacheFileInfo;
            LiteFileInfo dataFilesLiteFileInfo;
            LiteFileInfo dataCacheLiteFileInfo;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"inspectRoot", (Object[])new Object[0]);
            }
            FileStorageCloudConfig.Config config = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
            if (config == null) break block7;
            FileStorageCloudConfig.Config config2 = config;
            boolean bl = false;
            boolean bl2 = false;
            FileStorageCloudConfig.Config config3 = config2;
            boolean bl3 = false;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"inspectRoot start", (Object[])new Object[0]);
            }
            long totalSize = 0L;
            int totalSubFileNum = 0;
            int errorType = 0;
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            File dataCachesDir = context.getCacheDir();
            LiteFileInfo liteFileInfo = dataCacheLiteFileInfo = FileStorageHelper.INSTANCE.traversalDir(dataCachesDir, this.traversalCallBack);
            boolean bl4 = false;
            boolean bl5 = false;
            LiteFileInfo $this$run22 = liteFileInfo;
            boolean $i$a$-run-FileInfoInspector$inspectRoot$1$52 = false;
            totalSize += $this$run22.getFileSize();
            totalSubFileNum += $this$run22.getSubFileNum();
            File file = dataCachesDir;
            this.report(file != null ? file.getAbsolutePath() : null, $this$run22.getFileSize(), $this$run22.getSubFileNum(), 0, Constants.RootDirType.INSTANCE.getDATA_CACHE());
            Context context2 = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"RuntimeContext.sApplicationContext");
            File dataFilesDir = context2.getFilesDir();
            LiteFileInfo liteFileInfo2 = dataFilesLiteFileInfo = FileStorageHelper.INSTANCE.traversalDir(dataFilesDir, this.traversalCallBack);
            boolean $this$run22 = false;
            $i$a$-run-FileInfoInspector$inspectRoot$1$52 = false;
            LiteFileInfo $this$run32 = liteFileInfo2;
            boolean bl6 = false;
            totalSize += $this$run32.getFileSize();
            totalSubFileNum += $this$run32.getSubFileNum();
            File file2 = dataFilesDir;
            this.report(file2 != null ? file2.getAbsolutePath() : null, $this$run32.getFileSize(), $this$run32.getSubFileNum(), 0, Constants.RootDirType.INSTANCE.getDATA_FILES());
            Context context3 = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"RuntimeContext.sApplicationContext");
            File externalCacheDir = context3.getExternalCacheDir();
            LiteFileInfo $i$a$-run-FileInfoInspector$inspectRoot$1$52 = externalCacheFileInfo = FileStorageHelper.INSTANCE.traversalDir(externalCacheDir, this.traversalCallBack);
            boolean $this$run32 = false;
            boolean bl7 = false;
            LiteFileInfo $this$run = $i$a$-run-FileInfoInspector$inspectRoot$1$52;
            boolean bl8 = false;
            totalSize += $this$run.getFileSize();
            totalSubFileNum += $this$run.getSubFileNum();
            File file3 = externalCacheDir;
            this.report(file3 != null ? file3.getAbsolutePath() : null, $this$run.getFileSize(), $this$run.getSubFileNum(), 0, Constants.RootDirType.INSTANCE.getEXTERNAL_CACHE());
            File externalFilesDir = RuntimeContext.sApplicationContext.getExternalFilesDir(null);
            LiteFileInfo liteFileInfo3 = externalFilesFileInfo = FileStorageHelper.INSTANCE.traversalDir(RuntimeContext.sApplicationContext.getExternalFilesDir(null), this.traversalCallBack);
            boolean bl9 = false;
            boolean bl10 = false;
            LiteFileInfo $this$run4 = liteFileInfo3;
            boolean bl11 = false;
            File file4 = externalFilesDir;
            this.report(file4 != null ? file4.getAbsolutePath() : null, $this$run4.getFileSize(), $this$run4.getSubFileNum(), 0, Constants.RootDirType.INSTANCE.getEXTERNAL_FILES());
            if ((totalSubFileNum += $this$run4.getSubFileNum()) > config3.getInspectConfig().getSubFileOverNum() && ((totalSize += $this$run4.getFileSize()) > config3.getInspectConfig().getFileOverSize() || totalSize > this.maxStorageSize)) {
                errorType = Constants.ErrorType.INSTANCE.getFILE_OVER_NUM_AND_SIZE();
            } else if (totalSubFileNum > config3.getInspectConfig().getSubFileOverNum()) {
                errorType = Constants.ErrorType.INSTANCE.getSUB_FILE_OVER_NUM();
            } else if (totalSize > config3.getInspectConfig().getFileOverSize() || totalSize > this.maxStorageSize) {
                errorType = Constants.ErrorType.INSTANCE.getFILE_OVER_SIZE();
            }
            FileInfoInspector.report$default(this, "root", totalSize, totalSubFileNum, errorType, 0, 16, null);
            this.errorCallBack.onError(errorType);
        }
    }

    private final void report(String path, long size, int subFileNum, int errorType, int rootDir) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageMonitor", (String)("report summary: taskId = " + FileStorageMonitor.Companion.getTaskId() + " ,rootDir = " + path + " ,size = " + size + " ,subFileNum = " + subFileNum + " ,errorType = " + errorType), (Object[])new Object[0]);
        }
        if (!RuntimeContext.sIsDebuggable) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"real report summary", (Object[])new Object[0]);
            }
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagofile");
            statContent.put("type", Constants.ReportType.INSTANCE.getSUMMARY());
            statContent.put("fp", path);
            statContent.put("rd", rootDir);
            statContent.put("fs", size);
            statContent.put("sfn", subFileNum);
            statContent.put("et", errorType);
            statContent.put("tid", FileStorageMonitor.Companion.getTaskId());
            statContent.put("aes", this.availableExternalSize);
            statContent.put("tes", this.totalExternalSize);
            statContent.put("ais", this.availableInternalSize);
            statContent.put("tis", this.totalInternalSize);
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    static /* synthetic */ void report$default(FileInfoInspector fileInfoInspector2, String string, long l, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        fileInfoInspector2.report(string, l, n, n2, n3);
    }

    private final void checkStorage() {
        if (this.totalInternalSize == 0L) {
            this.totalInternalSize = YYFileUtils.getSystemTotalSize();
            this.availableInternalSize = YYFileUtils.getSystemAvailable();
            FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
            if (fileStorageUtils.isExternalStorageAvailable()) {
                this.availableExternalSize = YYFileUtils.getSDCardAvailableSize();
                this.totalExternalSize = YYFileUtils.getSDCardTotalSize();
            } else {
                this.availableExternalSize = -1L;
                this.totalExternalSize = -1L;
            }
            this.maxStorageSize = this.totalExternalSize > 0L ? this.totalExternalSize / (long)10 : this.totalInternalSize / (long)10;
        }
        MLog.debug((Object)"FileStorageMonitor", (String)("totalInternalSize = " + this.totalInternalSize + " , availableInternalSize = " + this.availableInternalSize + ' ' + ", totalExternalSize = " + this.totalExternalSize + ", availableExternalSize = " + this.availableExternalSize), (Object[])new Object[0]);
    }

    private final void checkSingleFile(File file) {
        block3: {
            if (!file.isFile()) {
                return;
            }
            FileStorageCloudConfig.Config config = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
            if (config == null) break block3;
            FileStorageCloudConfig.Config config2 = config;
            boolean bl = false;
            boolean bl2 = false;
            FileStorageCloudConfig.Config it = config2;
            boolean bl3 = false;
            long fileSize = FileStorageHelper.INSTANCE.getFileSize(file);
            if (fileSize > it.getInspectConfig().getSingleFileOverSize()) {
                FileInfoInspector.report$default(this, file.getAbsolutePath(), fileSize, 1, Constants.ErrorType.INSTANCE.getSINGLE_FILE_OVER_SIZE(), 0, 16, null);
            }
            if (fileSize <= 0L) {
                FileInfoInspector.report$default(this, file.getAbsolutePath(), fileSize, 1, Constants.ErrorType.INSTANCE.getSINGLE_FILE_SIZE_ZERO(), 0, 16, null);
            }
        }
    }

    public FileInfoInspector(@NotNull ErrorCallBack errorCallBack) {
        Intrinsics.checkParameterIsNotNull((Object)errorCallBack, (String)"errorCallBack");
        this.errorCallBack = errorCallBack;
        this.traversalCallBack = new FileStorageHelper.TraversalCallBack(this){
            final /* synthetic */ FileInfoInspector this$0;

            public void onTraversalFile(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                FileInfoInspector.access$checkSingleFile(this.this$0, file);
            }

            public boolean skipRecord(@NotNull File dir) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                if (!dir.isDirectory()) {
                    return false;
                }
                FileStorageCloudConfig.Config config = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
                if (config != null) {
                    FileStorageCloudConfig.Config config2 = config;
                    boolean bl = false;
                    boolean bl2 = false;
                    FileStorageCloudConfig.Config config3 = config2;
                    boolean bl3 = false;
                    if (!config3.getWhitelist().getEnable()) {
                        return false;
                    }
                    Iterable $this$forEach$iv = config3.getWhitelist().getItems();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FileStorageCloudConfig.WhitelistItem it = (FileStorageCloudConfig.WhitelistItem)element$iv;
                        boolean bl4 = false;
                        try {
                            File file = new File(FileStorageHelper.INSTANCE.getRootDir(it.getRootDir()), it.getDirName());
                            if (!file.exists() || !file.isDirectory() || !Intrinsics.areEqual((Object)file.getAbsolutePath(), (Object)dir.getAbsolutePath())) continue;
                            return true;
                        }
                        catch (Exception e) {
                            MLog.error((Object)"FileStorageMonitor", (String)("skipRecord error " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                }
                return false;
            }
            {
                this.this$0 = $outer;
            }
        };
        this.checkStorage();
    }

    public static final /* synthetic */ void access$checkSingleFile(FileInfoInspector $this, File file) {
        $this.checkSingleFile(file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileInfoInspector$ErrorCallBack;", "", "onError", "", "errorType", "", "apm_release"})
    public static interface ErrorCallBack {
        public void onError(int var1);
    }
}

