/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.cleaner;

import com.yy.base.logger.MLog;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.apm.filestorage.FileStorageCloudConfig;
import com.yy.hiyo.apm.filestorage.FileStoragePref;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.cleaner.ExpireCleanStrategy;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/cleaner/OverTotalSizeCleanStrategy;", "Lcom/yy/hiyo/apm/filestorage/internal/cleaner/ExpireCleanStrategy;", "parentDirPath", "", "expiredDays", "", "maxSize", "", "skipSubDir", "", "(Ljava/lang/String;IJZ)V", "cleanInner", "", "apm_release"})
public final class OverTotalSizeCleanStrategy
extends ExpireCleanStrategy {
    private long maxSize;

    @Override
    protected void cleanInner() {
        if (FileStoragePref.INSTANCE.getStorageNotEnoughProvider$apm_release().isStorageNotEnough()) {
            Object object = FileStoragePref.INSTANCE.getCloudConfig$apm_release();
            this.maxSize /= (long)(object != null && (object = ((FileStorageCloudConfig.Config)object).getCleanConfig()) != null ? ((FileStorageCloudConfig.CleanConfig)object).getSizeWeight() : 2);
        }
        if (this.getLiteFileInfo().getFileSize() < this.maxSize) {
            return;
        }
        Iterable $this$forEach$iv = this.getSubFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (!file.isFile()) {
                return;
            }
            boolean expired = FileStorageHelper.INSTANCE.isExpired(file.lastModified(), this.getExpiredDays$apm_release());
            if (!expired) continue;
            YYFileUtils.delete((File)file);
            if (!MLog.isLogLevelBlowInfo()) continue;
            MLog.info((Object)"FileStorageCleaner", (String)(" delete file : " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    public OverTotalSizeCleanStrategy(@NotNull String parentDirPath, int expiredDays, long maxSize, boolean skipSubDir) {
        Intrinsics.checkParameterIsNotNull((Object)parentDirPath, (String)"parentDirPath");
        super(parentDirPath, expiredDays, skipSubDir);
        this.maxSize = maxSize;
    }

    public /* synthetic */ OverTotalSizeCleanStrategy(String string, int n, long l, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(string, n, l, bl);
    }
}

