/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.cleaner;

import com.yy.base.logger.MLog;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.cleaner.ExpireCleanStrategy;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/cleaner/OverSubNumCleanStrategy;", "Lcom/yy/hiyo/apm/filestorage/internal/cleaner/ExpireCleanStrategy;", "parentDirPath", "", "expiredDays", "", "maxSubNum", "skipSubDir", "", "(Ljava/lang/String;IIZ)V", "cleanInner", "", "apm_release"})
public final class OverSubNumCleanStrategy
extends ExpireCleanStrategy {
    private final int maxSubNum;

    @Override
    protected void cleanInner() {
        if (this.getLiteFileInfo().getSubFileNum() < this.maxSubNum) {
            return;
        }
        Iterable $this$forEach$iv = this.getSubFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (!file.isFile()) {
                return;
            }
            boolean expired = FileStorageHelper.INSTANCE.isExpired(file.lastModified(), this.getExpiredDays$apm_release());
            if (!expired) continue;
            YYFileUtils.delete((File)file);
            if (!MLog.isLogLevelBlowInfo()) continue;
            MLog.info((Object)"FileStorageCleaner", (String)(" delete file : " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    public OverSubNumCleanStrategy(@NotNull String parentDirPath, int expiredDays, int maxSubNum, boolean skipSubDir) {
        Intrinsics.checkParameterIsNotNull((Object)parentDirPath, (String)"parentDirPath");
        super(parentDirPath, expiredDays, skipSubDir);
        this.maxSubNum = maxSubNum;
    }

    public /* synthetic */ OverSubNumCleanStrategy(String string, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(string, n, n2, bl);
    }
}

