/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.cleaner;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.apm.filestorage.FileStorageCloudConfig;
import com.yy.hiyo.apm.filestorage.FileStorageConfig;
import com.yy.hiyo.apm.filestorage.FileStoragePref;
import com.yy.hiyo.apm.filestorage.ICleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.cleaner.EmptyFileCleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.cleaner.ExpireCleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.cleaner.MixExpireCleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.cleaner.OverSubNumCleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.cleaner.OverTotalSizeCleanStrategy;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0018J#\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\b\u001aJ\u0012\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/cleaner/FileStorageCleaner;", "Lcom/yy/framework/core/INotify;", "()V", "cleaning", "", "config", "Lcom/yy/hiyo/apm/filestorage/FileStorageCloudConfig$CleanConfig;", "init", "storageItems", "", "Lcom/yy/hiyo/apm/filestorage/FileStorageCloudConfig$FileStorageConfig;", "strategyMap", "", "", "Lcom/yy/hiyo/apm/filestorage/ICleanStrategy;", "checkValid", "cleanForeground", "", "cleanForeground$apm_release", "cleanInner", "extendLife", "file", "Ljava/io/File;", "filePath", "extendLife$apm_release", "initialize", "initialize$apm_release", "notify", "notification", "Lcom/yy/framework/core/Notification;", "realClean", "registerDirsInternal", "registerStrategy", "Lcom/yy/hiyo/apm/filestorage/FileStorageConfig;", "dirPath", "apm_release"})
public final class FileStorageCleaner
implements INotify {
    private FileStorageCloudConfig.CleanConfig config;
    private final Map<String, ICleanStrategy> strategyMap;
    private List<FileStorageCloudConfig.FileStorageConfig> storageItems;
    private volatile boolean init;
    private volatile boolean cleaning;

    public final void initialize$apm_release(@NotNull FileStorageCloudConfig.CleanConfig config, @NotNull List<FileStorageCloudConfig.FileStorageConfig> storageItems) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(storageItems, (String)"storageItems");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)" initialize ", (Object[])new Object[0]);
        }
        this.config = config;
        this.storageItems = storageItems;
        this.init = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ FileStorageCleaner this$0;

            public final void run() {
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this.this$0);
                NotificationCenter.getGlobalInstance().register(NotificationDef.CLEAR_CACHE_DATA, (INotify)this.this$0);
            }
            {
                this.this$0 = fileStorageCleaner2;
            }
        });
        this.cleanForeground$apm_release();
    }

    public final void cleanForeground$apm_release() {
        block6: {
            block5: {
                if (!this.checkValid()) break block5;
                FileStorageCloudConfig.CleanConfig cleanConfig = this.config;
                if (cleanConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                if (cleanConfig.getForeground()) break block6;
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)" clean in foreground ", (Object[])new Object[0]);
        }
        this.cleanInner();
    }

    public final void extendLife$apm_release(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (!this.checkValid()) {
            return;
        }
        this.extendLife(new File(filePath));
    }

    private final void registerDirsInternal() {
        Map.Entry<String, FileStorageConfig> it;
        Map.Entry<String, Object> element$iv;
        Object tmpEmptyFileStrategy;
        boolean bl;
        File tempDir;
        Map<String, ICleanStrategy> map = this.strategyMap;
        boolean bl2 = false;
        if (!map.isEmpty()) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)" registerDirsInternal... ", (Object[])new Object[0]);
        }
        FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
        File file = tempDir = fileStorageUtils.getTempDir();
        if (file != null) {
            File file2 = file;
            boolean bl3 = false;
            boolean bl4 = false;
            File it2 = file2;
            bl = false;
            String string = it2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            tmpEmptyFileStrategy = new EmptyFileCleanStrategy(string, false, 0, 4, null);
            String string2 = it2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.absolutePath");
            OverTotalSizeCleanStrategy tmpOverSizeStrategy = new OverTotalSizeCleanStrategy(string2, 1, 0x6400000L, false);
            String string3 = it2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.absolutePath");
            OverSubNumCleanStrategy tmpOverSubNumStrategy = new OverSubNumCleanStrategy(string3, 1, 200, false);
            MixExpireCleanStrategy tmpMixCleanStrategy = new MixExpireCleanStrategy(CollectionsKt.listOf((Object[])new ExpireCleanStrategy[]{(ExpireCleanStrategy)tmpEmptyFileStrategy, tmpOverSizeStrategy, tmpOverSubNumStrategy}));
            String string4 = it2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.absolutePath");
            this.strategyMap.put(string4, tmpMixCleanStrategy);
        }
        Map<String, FileStorageConfig> externalStrategyMap = FileStoragePref.INSTANCE.getDirRegister$apm_release().registerDirs();
        Map<String, ICleanStrategy> $this$forEach$iv = externalStrategyMap;
        boolean $i$f$forEach = false;
        Map<String, ICleanStrategy> map2 = $this$forEach$iv;
        bl = false;
        tmpEmptyFileStrategy = map2.entrySet().iterator();
        while (tmpEmptyFileStrategy.hasNext()) {
            it = element$iv = tmpEmptyFileStrategy.next();
            boolean bl5 = false;
            String dirPath = it.getKey();
            FileStorageConfig config = it.getValue();
            this.registerStrategy(config, dirPath);
        }
        List<FileStorageCloudConfig.FileStorageConfig> list = this.storageItems;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storageItems");
        }
        $this$forEach$iv = list;
        $i$f$forEach = false;
        map2 = $this$forEach$iv.iterator();
        while (map2.hasNext()) {
            File bl5;
            Object element$iv2 = map2.next();
            FileStorageCloudConfig.FileStorageConfig it3 = (FileStorageCloudConfig.FileStorageConfig)element$iv2;
            boolean bl6 = false;
            if (it3.getMaxSize() <= 0L && it3.getMaxSubFile() <= 0) continue;
            File rootDir = FileStorageHelper.INSTANCE.getRootDir(it3.getRootDir());
            if (rootDir == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            File root = bl5;
            boolean bl9 = false;
            String dirPath = root.getAbsolutePath() + File.separator + it3.getDirName();
            FileStorageConfig config = new FileStorageConfig(it3.getExpiredDays(), it3.getMaxSize(), it3.getMaxSubFile(), it3.getSkipSubDir(), null, 16, null);
            this.registerStrategy(config, dirPath);
        }
        if (RuntimeContext.sIsDebuggable) {
            $this$forEach$iv = this.strategyMap;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            boolean bl10 = false;
            Iterator<Map.Entry<String, ICleanStrategy>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl11 = false;
                MLog.debug((Object)"FileStorageCleaner", (String)("strategyMap: [" + it.getKey() + "]-->[" + (ICleanStrategy)((Object)it.getValue()) + ']'), (Object[])new Object[0]);
            }
        }
    }

    private final void registerStrategy(FileStorageConfig config, String dirPath) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)("registerStrategy: dirPath = " + dirPath + ", config = " + config), (Object[])new Object[0]);
        }
        if (config.getCleanStrategy() != null) {
            ICleanStrategy iCleanStrategy = config.getCleanStrategy();
            if (iCleanStrategy == null) {
                Intrinsics.throwNpe();
            }
            this.strategyMap.put(dirPath, iCleanStrategy);
            return;
        }
        if (config.getMaxSize() > 0L && config.getMaxSubFile() > 0) {
            OverTotalSizeCleanStrategy overSizeCleanStrategy = new OverTotalSizeCleanStrategy(dirPath, config.getExpiredDays(), config.getMaxSize(), config.getSkipSubDir());
            OverSubNumCleanStrategy overSubNumCleanStrategy = new OverSubNumCleanStrategy(dirPath, config.getExpiredDays(), config.getMaxSubFile(), config.getSkipSubDir());
            MixExpireCleanStrategy mixCleanStrategy = new MixExpireCleanStrategy(CollectionsKt.listOf((Object[])new ExpireCleanStrategy[]{overSizeCleanStrategy, overSubNumCleanStrategy}));
            this.strategyMap.put(dirPath, mixCleanStrategy);
        } else if (config.getMaxSize() > 0L) {
            OverTotalSizeCleanStrategy overSizeCleanStrategy = new OverTotalSizeCleanStrategy(dirPath, config.getExpiredDays(), config.getMaxSize(), config.getSkipSubDir());
            this.strategyMap.put(dirPath, overSizeCleanStrategy);
        } else if (config.getMaxSubFile() > 0) {
            OverSubNumCleanStrategy overSubNumCleanStrategy = new OverSubNumCleanStrategy(dirPath, config.getExpiredDays(), config.getMaxSubFile(), config.getSkipSubDir());
            this.strategyMap.put(dirPath, overSubNumCleanStrategy);
        }
    }

    private final void cleanInner() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)" cleanInner ", (Object[])new Object[0]);
        }
        if (FileStorageHelper.INSTANCE.validateClean()) {
            this.realClean();
        }
    }

    private final void realClean() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)" clean actually start ", (Object[])new Object[0]);
        }
        this.registerDirsInternal();
        this.cleaning = true;
        Map<String, ICleanStrategy> $this$forEach$iv = this.strategyMap;
        boolean $i$f$forEach = false;
        Map<String, ICleanStrategy> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ICleanStrategy>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ICleanStrategy> element$iv;
            Map.Entry<String, ICleanStrategy> it = element$iv = iterator.next();
            boolean bl2 = false;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageCleaner", (String)(it.getValue() + "  running"), (Object[])new Object[0]);
            }
            it.getValue().clean();
        }
        this.cleaning = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notify(@Nullable Notification notification) {
        Notification notification2 = notification;
        if (notification2 != null) {
            if (notification2.id == NotificationDef.N_FOREGROUND_CHANGE) {
                MLog.debug((Object)"FileStorageCleaner", (String)"notify N_FOREGROUND_CHANGE ", (Object[])new Object[0]);
                if (!this.checkValid()) {
                    return;
                }
                Object object = notification.extObj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                boolean isForeground = (Boolean)object;
                if (isForeground) return;
                FileStorageCloudConfig.CleanConfig cleanConfig = this.config;
                if (cleanConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                if (cleanConfig.getForeground() || !RuntimeContext.sIsMoveTaskToBack) return;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FileStorageCleaner", (String)" clean in background ", (Object[])new Object[0]);
                }
                FileStoragePref.INSTANCE.getQueueExecutor$apm_release().execute(new Runnable(this){
                    final /* synthetic */ FileStorageCleaner this$0;

                    public final void run() {
                        FileStorageCleaner.access$cleanInner(this.this$0);
                    }
                    {
                        this.this$0 = fileStorageCleaner2;
                    }
                }, 1000L);
                return;
            }
        }
        Notification notification3 = notification;
        if (notification3 == null) return;
        if (notification3.id != NotificationDef.CLEAR_CACHE_DATA) return;
        MLog.debug((Object)"FileStorageCleaner", (String)"notify CLEAR_CACHE_DATA ", (Object[])new Object[0]);
        if (!this.checkValid()) {
            return;
        }
        FileStoragePref.INSTANCE.getQueueExecutor$apm_release().execute(new Runnable(this){
            final /* synthetic */ FileStorageCleaner this$0;

            public final void run() {
                FileStorageCleaner.access$realClean(this.this$0);
            }
            {
                this.this$0 = fileStorageCleaner2;
            }
        }, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkValid() {
        if (!this.init) return false;
        if (this.cleaning) return false;
        FileStorageCloudConfig.CleanConfig cleanConfig = this.config;
        if (cleanConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (!cleanConfig.getEnable()) return false;
        return true;
    }

    private final void extendLife(File file) {
        block9: {
            ICleanStrategy cleanStrategy;
            if (!this.checkValid()) {
                return;
            }
            if (!file.exists()) {
                MLog.error((Object)"FileStorageCleaner", (String)(" file not exist: " + file.getAbsolutePath()), (Object[])new Object[0]);
                return;
            }
            if (!file.isFile()) {
                if (RuntimeContext.sIsDebuggable) {
                    throw (Throwable)new IllegalArgumentException("file is not file: " + file.getAbsolutePath());
                }
                MLog.error((Object)"FileStorageCleaner", (String)(" file is not file: " + file.getAbsolutePath()), (Object[])new Object[0]);
                return;
            }
            if (file.getParent() == null) {
                if (RuntimeContext.sIsDebuggable) {
                    throw (Throwable)new IllegalArgumentException("file " + file.getAbsolutePath() + " parent null");
                }
                MLog.error((Object)"FileStorageCleaner", (String)(" file " + file.getAbsolutePath() + " parent null"), (Object[])new Object[0]);
                return;
            }
            Map<String, ICleanStrategy> map = this.strategyMap;
            String string = file.getParent();
            boolean bl = false;
            Map<String, ICleanStrategy> map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(string)) {
                this.registerDirsInternal();
                if (RuntimeContext.sIsDebuggable) {
                    map = this.strategyMap;
                    string = file.getParent();
                    bl = false;
                    map2 = map;
                    bl2 = false;
                    if (!map2.containsKey(string)) {
                        throw (Throwable)new IllegalArgumentException("file " + file.getParent() + " is not in  clean strategies");
                    }
                }
                MLog.error((Object)"FileStorageCleaner", (String)(" file " + file.getParent() + " is not in  clean strategies"), (Object[])new Object[0]);
                return;
            }
            ICleanStrategy iCleanStrategy = cleanStrategy = this.strategyMap.get(file.getParent());
            if (iCleanStrategy == null) break block9;
            iCleanStrategy.extendLife(file);
        }
    }

    public FileStorageCleaner() {
        Map map;
        FileStorageCleaner fileStorageCleaner2 = this;
        boolean bl = false;
        fileStorageCleaner2.strategyMap = map = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ void access$cleanInner(FileStorageCleaner $this) {
        $this.cleanInner();
    }

    public static final /* synthetic */ void access$realClean(FileStorageCleaner $this) {
        $this.realClean();
    }
}

