/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.apm.filestorage.internal.Constants;
import com.yy.hiyo.apm.filestorage.internal.LiteFileInfo;
import java.io.File;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bJ\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\r\u00a8\u0006\u001a"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/FileStorageHelper;", "", "()V", "getFileSize", "", "file", "Ljava/io/File;", "getFileType", "", "f", "getRootDir", "rootDirType", "isExpired", "", "recordTime", "expiredDays", "traversalDir", "Lcom/yy/hiyo/apm/filestorage/internal/LiteFileInfo;", "dir", "callBack", "Lcom/yy/hiyo/apm/filestorage/internal/FileStorageHelper$TraversalCallBack;", "traversalSkipSubDir", "validateClean", "validateFullReport", "validateInspectReport", "TraversalCallBack", "apm_release"})
public final class FileStorageHelper {
    public static final FileStorageHelper INSTANCE;

    public final boolean validateFullReport() {
        if (!SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"validateFullReport\uff1aMetricSwitch Off", (Object[])new Object[0]);
            }
            return false;
        }
        long curTimeMills = System.currentTimeMillis();
        long recordTimeMillis = SettingFlags.getLongValue((String)"file_info_full_report");
        if (!(recordTimeMillis <= 0L || curTimeMills >= recordTimeMillis && this.isExpired(recordTimeMillis, 7))) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"validateFullReport\uff1acurTimeMills < recordTimeMillis+7 ", (Object[])new Object[0]);
            }
            return false;
        }
        SettingFlags.setLongValue((String)"file_info_full_report", (long)curTimeMills);
        return true;
    }

    public final boolean validateInspectReport() {
        if (!SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"validateInspectReport\uff1aMetricSwitch Off", (Object[])new Object[0]);
            }
            return false;
        }
        long curTimeMills = System.currentTimeMillis();
        long recordTimeMillis = SettingFlags.getLongValue((String)"file_info_inspect_report");
        if (!(recordTimeMillis <= 0L || curTimeMills >= recordTimeMillis && this.isExpired(recordTimeMillis, 1))) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"validateInspectReport\uff1acurTimeMills < recordTimeMillis+1 ", (Object[])new Object[0]);
            }
            return false;
        }
        SettingFlags.setLongValue((String)"file_info_inspect_report", (long)curTimeMills);
        return true;
    }

    public final boolean validateClean() {
        if (RuntimeContext.sIsDebuggable) {
            return true;
        }
        long curTimeMills = System.currentTimeMillis();
        long recordTimeMillis = SettingFlags.getLongValue((String)"file_info_clean");
        if (!(recordTimeMillis <= 0L || curTimeMills >= recordTimeMillis && this.isExpired(recordTimeMillis, 1))) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageCleaner", (String)"validateClean\uff1acurTimeMills < recordTimeMillis+1 ", (Object[])new Object[0]);
            }
            return false;
        }
        SettingFlags.setLongValue((String)"file_info_clean", (long)curTimeMills);
        return true;
    }

    @NotNull
    public final LiteFileInfo traversalDir(@Nullable File dir, @Nullable TraversalCallBack callBack) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return liteFileInfo;
        }
        try {
            int n;
            int n2;
            LinkedList<File> dirs = new LinkedList<File>();
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                n2 = 0;
                File[] fileArray2 = fileArray;
                int n3 = 0;
                if (!(fileArray2.length == 0)) {
                    fileArray2 = files;
                    n3 = fileArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        File file;
                        File file2 = file = fileArray2[n2];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        if (file2.isDirectory() && (callBack == null || !callBack.skipRecord(file))) {
                            dirs.add(file);
                            continue;
                        }
                        liteFileInfo.setFileSize(liteFileInfo.getFileSize() + file.length());
                        LiteFileInfo liteFileInfo2 = liteFileInfo;
                        n = liteFileInfo2.getSubFileNum();
                        liteFileInfo2.setSubFileNum(n + 1);
                        TraversalCallBack traversalCallBack2 = callBack;
                        if (traversalCallBack2 == null) continue;
                        traversalCallBack2.onTraversalFile(file);
                    }
                }
            }
            File tmpFile = null;
            while (!dirs.isEmpty()) {
                File file = tmpFile = (File)dirs.removeFirst();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tmpFile");
                if (file.isDirectory()) {
                    files = tmpFile.listFiles();
                    if (files == null) continue;
                    File[] fileArray = files;
                    int n4 = 0;
                    if (fileArray.length == 0) continue;
                    File[] fileArray3 = files;
                    n = fileArray3.length;
                    for (n4 = 0; n4 < n; ++n4) {
                        File file3;
                        File file4 = file3 = fileArray3[n4];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                        if (file4.isDirectory()) {
                            dirs.add(file3);
                            continue;
                        }
                        liteFileInfo.setFileSize(liteFileInfo.getFileSize() + file3.length());
                        LiteFileInfo liteFileInfo3 = liteFileInfo;
                        int n5 = liteFileInfo3.getSubFileNum();
                        liteFileInfo3.setSubFileNum(n5 + 1);
                        TraversalCallBack traversalCallBack3 = callBack;
                        if (traversalCallBack3 == null) continue;
                        traversalCallBack3.onTraversalFile(file3);
                    }
                    continue;
                }
                liteFileInfo.setFileSize(liteFileInfo.getFileSize() + tmpFile.length());
                LiteFileInfo liteFileInfo4 = liteFileInfo;
                n2 = liteFileInfo4.getSubFileNum();
                liteFileInfo4.setSubFileNum(n2 + 1);
                TraversalCallBack traversalCallBack4 = callBack;
                if (traversalCallBack4 == null) continue;
                traversalCallBack4.onTraversalFile(tmpFile);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"FileStorageMonitor", (String)("traversalDir error:" + e.getMessage()), (Object[])new Object[0]);
        }
        return liteFileInfo;
    }

    public static /* synthetic */ LiteFileInfo traversalDir$default(FileStorageHelper fileStorageHelper, File file, TraversalCallBack traversalCallBack2, int n, Object object) {
        if ((n & 2) != 0) {
            traversalCallBack2 = null;
        }
        return fileStorageHelper.traversalDir(file, traversalCallBack2);
    }

    @NotNull
    public final LiteFileInfo traversalSkipSubDir(@Nullable File dir) {
        LiteFileInfo liteFileInfo = new LiteFileInfo(0L, 0, 3, null);
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return liteFileInfo;
        }
        try {
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = 0;
                File[] fileArray2 = fileArray;
                int n2 = 0;
                if (!(fileArray2.length == 0)) {
                    fileArray2 = files;
                    n2 = fileArray2.length;
                    for (n = 0; n < n2; ++n) {
                        File file;
                        File file2 = file = fileArray2[n];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        if (file2.isDirectory()) continue;
                        liteFileInfo.setFileSize(liteFileInfo.getFileSize() + file.length());
                        LiteFileInfo liteFileInfo2 = liteFileInfo;
                        int n3 = liteFileInfo2.getSubFileNum();
                        liteFileInfo2.setSubFileNum(n3 + 1);
                    }
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)"FileStorageMonitor", (String)("traversalDir error:" + e.getMessage()), (Object[])new Object[0]);
        }
        return liteFileInfo;
    }

    public final long getFileSize(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.length();
    }

    public final int getFileType(@NotNull File f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        return f.isDirectory() ? Constants.FileType.INSTANCE.getDIR() : (f.isFile() ? Constants.FileType.INSTANCE.getFILE() : Constants.FileType.INSTANCE.getOTHER());
    }

    @Nullable
    public final File getRootDir(int rootDirType) {
        File file;
        int n = rootDirType;
        if (n == Constants.RootDirType.INSTANCE.getDATA_CACHE()) {
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            file = context.getCacheDir();
        } else if (n == Constants.RootDirType.INSTANCE.getDATA_FILES()) {
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            file = context.getFilesDir();
        } else if (n == Constants.RootDirType.INSTANCE.getEXTERNAL_CACHE()) {
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            file = context.getExternalCacheDir();
        } else if (n == Constants.RootDirType.INSTANCE.getEXTERNAL_FILES()) {
            file = RuntimeContext.sApplicationContext.getExternalFilesDir(null);
        } else {
            throw (Throwable)new RuntimeException("rootDirType not match");
        }
        return file;
    }

    public final boolean isExpired(long recordTime, int expiredDays) {
        return (System.currentTimeMillis() - recordTime) / (long)1000 / (long)3600 / (long)24 > (long)expiredDays;
    }

    private FileStorageHelper() {
    }

    static {
        FileStorageHelper fileStorageHelper;
        INSTANCE = fileStorageHelper = new FileStorageHelper();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/FileStorageHelper$TraversalCallBack;", "", "onTraversalFile", "", "file", "Ljava/io/File;", "skipRecord", "", "dir", "apm_release"})
    public static interface TraversalCallBack {
        public void onTraversalFile(@NotNull File var1);

        public boolean skipRecord(@NotNull File var1);
    }
}

