/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.monitor;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.apm.filestorage.FileStorageCloudConfig;
import com.yy.hiyo.apm.filestorage.internal.Constants;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.monitor.FileInfoInspector;
import com.yy.hiyo.apm.filestorage.internal.monitor.FileInfoRecursiveTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileStorageMonitor;", "", "()V", "fullReportConfig", "Lcom/yy/hiyo/apm/filestorage/FileStorageCloudConfig$FullReportConfig;", "inspectConfig", "Lcom/yy/hiyo/apm/filestorage/FileStorageCloudConfig$InspectConfig;", "executeFileInfoTask", "", "rootDir", "Ljava/io/File;", "rootDirType", "", "fullReport", "", "scanRootDir", "startWithConfig", "Companion", "apm_release"})
public final class FileStorageMonitor {
    private FileStorageCloudConfig.FullReportConfig fullReportConfig;
    private FileStorageCloudConfig.InspectConfig inspectConfig;
    private static long taskId;
    public static final Companion Companion;

    public final void startWithConfig(@NotNull FileStorageCloudConfig.FullReportConfig fullReportConfig, @NotNull FileStorageCloudConfig.InspectConfig inspectConfig) {
        Intrinsics.checkParameterIsNotNull((Object)fullReportConfig, (String)"fullReportConfig");
        Intrinsics.checkParameterIsNotNull((Object)inspectConfig, (String)"inspectConfig");
        this.fullReportConfig = fullReportConfig;
        this.inspectConfig = inspectConfig;
        if (!fullReportConfig.getEnable() && !inspectConfig.getEnable()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"inspect fail by not enable", (Object[])new Object[0]);
            }
            taskId = 0L;
            return;
        }
        taskId = System.currentTimeMillis() / (long)1000 / (long)3600;
        if (inspectConfig.getEnable() && FileStorageHelper.INSTANCE.validateInspectReport()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"inspect summary", (Object[])new Object[0]);
            }
            FileInfoInspector fileInfoInspector2 = new FileInfoInspector(new FileInfoInspector.ErrorCallBack(this){
                final /* synthetic */ FileStorageMonitor this$0;

                public void onError(int errorType) {
                    if (errorType > 0) {
                        FileStorageMonitor.access$scanRootDir(this.this$0, false);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
            fileInfoInspector2.inspectRoot();
        }
        if (fullReportConfig.getEnable() && FileStorageHelper.INSTANCE.validateFullReport()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"reportFull task start", (Object[])new Object[0]);
            }
            this.scanRootDir(true);
        }
    }

    private final void scanRootDir(boolean fullReport) {
        block4: {
            File externalFilesDir;
            File externalCacheDir;
            File dataFilesDir;
            boolean bl;
            File dataCacheDir;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"FileStorageMonitor", (String)"scanRootDir start...", (Object[])new Object[0]);
            }
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            File file = dataCacheDir = context.getCacheDir();
            if (file != null) {
                File file2 = file;
                boolean bl2 = false;
                bl = false;
                File it = file2;
                boolean bl3 = false;
                this.executeFileInfoTask(it, Constants.RootDirType.INSTANCE.getDATA_CACHE(), fullReport);
            }
            Context context2 = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"RuntimeContext.sApplicationContext");
            File file3 = dataFilesDir = context2.getFilesDir();
            if (file3 != null) {
                File file4 = file3;
                bl = false;
                boolean bl4 = false;
                File it = file4;
                boolean bl5 = false;
                this.executeFileInfoTask(it, Constants.RootDirType.INSTANCE.getDATA_FILES(), fullReport);
            }
            Context context3 = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"RuntimeContext.sApplicationContext");
            File file5 = externalCacheDir = context3.getExternalCacheDir();
            if (file5 != null) {
                File file6 = file5;
                boolean bl6 = false;
                boolean bl7 = false;
                File it = file6;
                boolean bl8 = false;
                this.executeFileInfoTask(it, Constants.RootDirType.INSTANCE.getEXTERNAL_CACHE(), fullReport);
            }
            File file7 = externalFilesDir = RuntimeContext.sApplicationContext.getExternalFilesDir(null);
            if (file7 == null) break block4;
            File file8 = file7;
            boolean bl9 = false;
            boolean bl10 = false;
            File it = file8;
            boolean bl11 = false;
            this.executeFileInfoTask(it, Constants.RootDirType.INSTANCE.getEXTERNAL_FILES(), fullReport);
        }
    }

    private final void executeFileInfoTask(File rootDir, int rootDirType, boolean fullReport) {
        FileInfoRecursiveTask fileInfoTask;
        FileInfoRecursiveTask fileInfoRecursiveTask = fileInfoTask = new FileInfoRecursiveTask();
        boolean bl = false;
        boolean bl2 = false;
        FileInfoRecursiveTask $this$run = fileInfoRecursiveTask;
        boolean bl3 = false;
        $this$run.execute(rootDir, rootDirType, fullReport);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$scanRootDir(FileStorageMonitor $this, boolean fullReport) {
        $this.scanRootDir(fullReport);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/monitor/FileStorageMonitor$Companion;", "", "()V", "taskId", "", "getTaskId", "()J", "setTaskId", "(J)V", "apm_release"})
    public static final class Companion {
        public final long getTaskId() {
            return taskId;
        }

        public final void setTaskId(long l) {
            taskId = l;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

