/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.cleaner;

import com.yy.base.logger.MLog;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.cleaner.ExpireCleanStrategy;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/cleaner/OverSizeCleanStrategy;", "Lcom/yy/hiyo/apm/filestorage/internal/cleaner/ExpireCleanStrategy;", "parentDirPath", "", "expiredDays", "", "singleMaxSize", "", "(Ljava/lang/String;IJ)V", "cleanInner", "", "apm_release"})
public final class OverSizeCleanStrategy
extends ExpireCleanStrategy {
    private final long singleMaxSize;

    @Override
    protected void cleanInner() {
        Iterable $this$forEach$iv = this.getSubFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.isFile()) {
                return;
            }
            if (it.length() < this.singleMaxSize) {
                return;
            }
            boolean expired = FileStorageHelper.INSTANCE.isExpired(it.lastModified(), this.getExpiredDays$apm_release());
            if (!expired) continue;
            YYFileUtils.delete((File)it);
            if (!MLog.isLogLevelBlowInfo()) continue;
            MLog.info((Object)"FileStorageCleaner", (String)(" delete file : " + it.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    public OverSizeCleanStrategy(@NotNull String parentDirPath, int expiredDays, long singleMaxSize) {
        Intrinsics.checkParameterIsNotNull((Object)parentDirPath, (String)"parentDirPath");
        super(parentDirPath, expiredDays, false, 4, null);
        this.singleMaxSize = singleMaxSize;
    }
}

