/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.filestorage.internal.cleaner;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.apm.filestorage.ICleanStrategy;
import com.yy.hiyo.apm.filestorage.internal.FileStorageHelper;
import com.yy.hiyo.apm.filestorage.internal.LiteFileInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH$J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/yy/hiyo/apm/filestorage/internal/cleaner/ExpireCleanStrategy;", "Lcom/yy/hiyo/apm/filestorage/ICleanStrategy;", "parentDirPath", "", "expiredDays", "", "skipSubDir", "", "(Ljava/lang/String;IZ)V", "getExpiredDays$apm_release", "()I", "liteFileInfo", "Lcom/yy/hiyo/apm/filestorage/internal/LiteFileInfo;", "getLiteFileInfo", "()Lcom/yy/hiyo/apm/filestorage/internal/LiteFileInfo;", "setLiteFileInfo", "(Lcom/yy/hiyo/apm/filestorage/internal/LiteFileInfo;)V", "parentDir", "Ljava/io/File;", "getParentDir", "()Ljava/io/File;", "setParentDir", "(Ljava/io/File;)V", "subFiles", "", "getSubFiles", "()Ljava/util/List;", "setSubFiles", "(Ljava/util/List;)V", "clean", "", "cleanInner", "extendLife", "file", "traversalSubFiles", "apm_release"})
public abstract class ExpireCleanStrategy
implements ICleanStrategy {
    @NotNull
    protected File parentDir;
    @NotNull
    protected LiteFileInfo liteFileInfo;
    @NotNull
    protected List<File> subFiles;
    private String parentDirPath;
    private final int expiredDays;
    private boolean skipSubDir;

    @NotNull
    protected final File getParentDir() {
        File file = this.parentDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
        }
        return file;
    }

    protected final void setParentDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.parentDir = file;
    }

    @NotNull
    protected final LiteFileInfo getLiteFileInfo() {
        LiteFileInfo liteFileInfo = this.liteFileInfo;
        if (liteFileInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"liteFileInfo");
        }
        return liteFileInfo;
    }

    protected final void setLiteFileInfo(@NotNull LiteFileInfo liteFileInfo) {
        Intrinsics.checkParameterIsNotNull((Object)liteFileInfo, (String)"<set-?>");
        this.liteFileInfo = liteFileInfo;
    }

    @NotNull
    protected final List<File> getSubFiles() {
        List<File> list = this.subFiles;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subFiles");
        }
        return list;
    }

    protected final void setSubFiles(@NotNull List<File> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.subFiles = list;
    }

    @Override
    public void extendLife(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        file.setLastModified(System.currentTimeMillis());
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)(" extendLife: " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    @Override
    public void clean() {
        File file = this.parentDir = new File(this.parentDirPath);
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
        }
        if (!file.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append(" dir not exist: ");
            File file2 = this.parentDir;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
            }
            MLog.error((Object)"FileStorageCleaner", (String)stringBuilder.append(file2.getAbsolutePath()).toString(), (Object[])new Object[0]);
            return;
        }
        File file3 = this.parentDir;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
        }
        if (!file3.isDirectory()) {
            if (RuntimeContext.sIsDebuggable) {
                StringBuilder stringBuilder = new StringBuilder().append("dir is not Directory: ");
                File file4 = this.parentDir;
                if (file4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
                }
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(file4.getAbsolutePath()).toString());
            }
            StringBuilder stringBuilder = new StringBuilder().append("dir is not Directory: ");
            File file5 = this.parentDir;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
            }
            MLog.error((Object)"FileStorageCleaner", (String)stringBuilder.append(file5.getAbsolutePath()).toString(), (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FileStorageCleaner", (String)(" clean start : " + this.parentDirPath + " --> " + this), (Object[])new Object[0]);
        }
        this.traversalSubFiles();
        this.cleanInner();
    }

    /*
     * WARNING - void declaration
     */
    private final void traversalSubFiles() {
        LiteFileInfo liteFileInfo;
        List list;
        ExpireCleanStrategy expireCleanStrategy = this;
        boolean bl = false;
        expireCleanStrategy.subFiles = list = (List)new ArrayList();
        if (this.skipSubDir) {
            File file = this.parentDir;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
            }
            liteFileInfo = FileStorageHelper.INSTANCE.traversalSkipSubDir(file);
        } else {
            File file = this.parentDir;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
            }
            liteFileInfo = this.liteFileInfo = FileStorageHelper.INSTANCE.traversalDir(file, new FileStorageHelper.TraversalCallBack(this){
                final /* synthetic */ ExpireCleanStrategy this$0;

                public void onTraversalFile(@NotNull File file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    this.this$0.getSubFiles().add(file);
                }

                public boolean skipRecord(@NotNull File dir) {
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    return false;
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        if (this.skipSubDir) {
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                File file = this.parentDir;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parentDir");
                }
                File[] fileArray = file.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"parentDir.listFiles()");
                File[] fileArray2 = fileArray;
                expireCleanStrategy = this;
                boolean $i$f$filter = false;
                void var3_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var6_10 = $this$filterTo$iv$iv;
                int n = ((void)var6_10).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var6_10[i];
                    boolean bl2 = false;
                    void v5 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                    if (!v5.isFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                expireCleanStrategy.subFiles = CollectionsKt.toMutableList((Collection)list);
            }
            catch (Exception e) {
                MLog.error((Object)"FileStorageCleaner", (String)" listFiles error=%s", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    protected abstract void cleanInner();

    public final int getExpiredDays$apm_release() {
        return this.expiredDays;
    }

    public ExpireCleanStrategy(@NotNull String parentDirPath, int expiredDays, boolean skipSubDir) {
        Intrinsics.checkParameterIsNotNull((Object)parentDirPath, (String)"parentDirPath");
        this.parentDirPath = parentDirPath;
        this.expiredDays = expiredDays;
        this.skipSubDir = skipSubDir;
    }

    public /* synthetic */ ExpireCleanStrategy(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(string, n, bl);
    }
}

