/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.basicPerf.memory;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import com.yy.hiyo.apm.basicPerf.memory.HeapInfo;
import com.yy.hiyo.apm.basicPerf.memory.PssInfo;
import com.yy.hiyo.apm.basicPerf.memory.RamInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/yy/hiyo/apm/basicPerf/memory/MemoryUtil;", "", "()V", "appHeapInfo", "Lcom/yy/hiyo/apm/basicPerf/memory/HeapInfo;", "getAppHeapInfo", "()Lcom/yy/hiyo/apm/basicPerf/memory/HeapInfo;", "ramTotalMemByFile", "", "getRamTotalMemByFile", "()J", "sActivityManager", "Landroid/app/ActivityManager;", "getAppPssInfo", "Lcom/yy/hiyo/apm/basicPerf/memory/PssInfo;", "context", "Landroid/content/Context;", "getRamInfo", "Lcom/yy/hiyo/apm/basicPerf/memory/RamInfo;", "getRamTotalMem", "activityManager", "apm_release"})
public final class MemoryUtil {
    private static ActivityManager sActivityManager;
    public static final MemoryUtil INSTANCE;

    @NotNull
    public final HeapInfo getAppHeapInfo() {
        Runtime runtime = Runtime.getRuntime();
        HeapInfo heapInfo = new HeapInfo();
        heapInfo.setFreeMemKb(runtime.freeMemory() / (long)1024);
        heapInfo.setMaxMemKb(Runtime.getRuntime().maxMemory() / (long)1024);
        heapInfo.setAllocatedKb((Runtime.getRuntime().totalMemory() - runtime.freeMemory()) / (long)1024);
        return heapInfo;
    }

    @NotNull
    public final PssInfo getAppPssInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int pid = Process.myPid();
        if (sActivityManager == null) {
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            sActivityManager = (ActivityManager)object;
        }
        Debug.MemoryInfo memoryInfo = null;
        if (Build.VERSION.SDK_INT > 28) {
            memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
        } else {
            Debug.MemoryInfo[] memInfos;
            ActivityManager activityManager = sActivityManager;
            if (activityManager == null) {
                Intrinsics.throwNpe();
            }
            if ((memInfos = activityManager.getProcessMemoryInfo(new int[]{Process.myPid()})) != null && memInfos.length > 0) {
                memoryInfo = memInfos[0];
            }
        }
        PssInfo pssInfo = new PssInfo();
        Debug.MemoryInfo memoryInfo2 = memoryInfo;
        if (memoryInfo2 == null) {
            Intrinsics.throwNpe();
        }
        pssInfo.setTotalPssKb(memoryInfo2.getTotalPss());
        pssInfo.setDalvikPssKb(memoryInfo.dalvikPss);
        pssInfo.setNativePssKb(memoryInfo.nativePss);
        pssInfo.setOtherPssKb(memoryInfo.otherPss);
        return pssInfo;
    }

    @Nullable
    public final RamInfo getRamInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (sActivityManager == null) {
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            sActivityManager = (ActivityManager)object;
        }
        ActivityManager activityManager = sActivityManager;
        if (activityManager != null) {
            ActivityManager activityManager2 = activityManager;
            boolean bl = false;
            boolean bl2 = false;
            ActivityManager it = activityManager2;
            boolean bl3 = false;
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            it.getMemoryInfo(mi);
            RamInfo ramMemoryInfo = new RamInfo();
            ramMemoryInfo.setAvailMemKb(mi.availMem / (long)1024);
            ramMemoryInfo.setLowMemory(mi.lowMemory);
            ramMemoryInfo.setLowMemThresholdKb(mi.threshold / (long)1024);
            ramMemoryInfo.setTotalMemKb(INSTANCE.getRamTotalMem(it));
            return ramMemoryInfo;
        }
        return null;
    }

    private final long getRamTotalMem(ActivityManager activityManager) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(mi);
        return mi.totalMem / (long)1024;
    }

    private final long getRamTotalMemByFile() {
        String dir = "/proc/meminfo";
        try {
            String memoryLine;
            FileReader fr = new FileReader(dir);
            BufferedReader br = new BufferedReader(fr, 2048);
            String string = memoryLine = br.readLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"memoryLine");
            CharSequence charSequence = string;
            int n = StringsKt.indexOf$default((CharSequence)memoryLine, (String)"MemTotal:", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String subMemoryLine = string3;
            br.close();
            charSequence = subMemoryLine;
            String string4 = "\\D+";
            bl = false;
            string4 = new Regex(string4);
            String string5 = "";
            boolean bl2 = false;
            charSequence = string4.replace(charSequence, string5);
            boolean bl3 = false;
            return Integer.parseInt(charSequence);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private MemoryUtil() {
    }

    static {
        MemoryUtil memoryUtil;
        INSTANCE = memoryUtil = new MemoryUtil();
    }
}

