/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.basicPerf.cpu;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.yy.base.logger.MLog;
import com.yy.base.utils.IOUtils;
import com.yy.hiyo.apm.basicPerf.cpu.CpuInfo;
import com.yy.hiyo.apm.basicPerf.cpu.CpuSnapshot;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CpuUsage_1 {
    private static final String TAG = "CpuUsage";
    private static boolean isReadFromFile = CpuUsage_1.cpuFileUsability();
    private static CpuSnapshot sLastCpuSnapshot;
    private static final int BUFFER_SIZE = 1024;

    public static CpuInfo getCpuInfo(boolean reset) {
        if (reset) {
            sLastCpuSnapshot = null;
        }
        if (isReadFromFile) {
            if (sLastCpuSnapshot == null) {
                sLastCpuSnapshot = CpuUsage_1.parse(CpuUsage_1.getCpuRateOfDevice(), CpuUsage_1.getCpuRateOfApp());
                return CpuInfo.INVALID;
            }
            CpuSnapshot current = CpuUsage_1.parse(CpuUsage_1.getCpuRateOfDevice(), CpuUsage_1.getCpuRateOfApp());
            float totalTime = (float)(current.total - CpuUsage_1.sLastCpuSnapshot.total) * 1.0f;
            if (totalTime <= 0.0f) {
                MLog.error((Object)TAG, (String)"totalTime must greater than 0", (Object[])new Object[0]);
                return CpuInfo.INVALID;
            }
            long idleTime = current.idle - CpuUsage_1.sLastCpuSnapshot.idle;
            double totalRatio = (totalTime - (float)idleTime) / totalTime;
            double appRatio = (float)(current.app - CpuUsage_1.sLastCpuSnapshot.app) / totalTime;
            double userRatio = (float)(current.user - CpuUsage_1.sLastCpuSnapshot.user) / totalTime;
            double systemRatio = (float)(current.system - CpuUsage_1.sLastCpuSnapshot.system) / totalTime;
            double ioWaitRatio = (float)(current.ioWait - CpuUsage_1.sLastCpuSnapshot.ioWait) / totalTime;
            return new CpuInfo(CpuUsage_1.filterCpuRatio(totalRatio), CpuUsage_1.filterCpuRatio(appRatio), CpuUsage_1.filterCpuRatio(userRatio), CpuUsage_1.filterCpuRatio(systemRatio), CpuUsage_1.filterCpuRatio(ioWaitRatio));
        }
        return CpuUsage_1.getCpuInfoFromShell();
    }

    public static CpuInfo getCpuInfo() {
        return CpuUsage_1.getCpuInfo(false);
    }

    private static double filterCpuRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            return 0.0;
        }
        return ratio;
    }

    private static boolean cpuFileUsability() {
        File stat = new File("/proc/stat");
        if (!stat.exists() || !stat.canRead()) {
            return false;
        }
        int pid = android.os.Process.myPid();
        File statPid = new File("/proc/" + pid + "/stat");
        return statPid.exists() && statPid.canRead();
    }

    private static String getCpuRateOfDevice() {
        String string;
        String cpuRate;
        BufferedReader cpuReader;
        block6: {
            cpuReader = null;
            cpuReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1024);
            cpuRate = cpuReader.readLine();
            if (cpuRate != null) break block6;
            String string2 = "";
            IOUtils.safeClose((Closeable)cpuReader);
            return string2;
        }
        try {
            string = cpuRate.trim();
        }
        catch (Throwable e) {
            try {
                String string3 = "";
                return string3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.safeClose(cpuReader);
            }
        }
        IOUtils.safeClose((Closeable)cpuReader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCpuRateOfApp() {
        String string;
        String pidCpuRate;
        BufferedReader pidReader;
        block6: {
            pidReader = null;
            int pid = android.os.Process.myPid();
            pidReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1024);
            pidCpuRate = pidReader.readLine();
            if (pidCpuRate != null) break block6;
            String string2 = "";
            IOUtils.safeClose((Closeable)pidReader);
            return string2;
        }
        try {
            string = pidCpuRate;
        }
        catch (Throwable throwable) {
            try {
                String string3 = "";
                return string3;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.safeClose(pidReader);
            }
        }
        IOUtils.safeClose((Closeable)pidReader);
        return string;
    }

    @VisibleForTesting
    static CpuSnapshot parse(String cpuRate, String pidCpuRate) {
        String[] cpuInfoArray = cpuRate.split("\\s+");
        if (cpuInfoArray.length < 9) {
            throw new IllegalStateException("cpu info array size must great than 9");
        }
        long user = Long.parseLong(cpuInfoArray[2]);
        long nice = Long.parseLong(cpuInfoArray[3]);
        long system = Long.parseLong(cpuInfoArray[4]);
        long idle = Long.parseLong(cpuInfoArray[5]);
        long ioWait = Long.parseLong(cpuInfoArray[6]);
        long total = user + nice + system + idle + ioWait + Long.parseLong(cpuInfoArray[7]) + Long.parseLong(cpuInfoArray[8]);
        String[] pidCpuInfoList = pidCpuRate.split(" ");
        if (pidCpuInfoList.length < 17) {
            throw new IllegalStateException("pid cpu info array size must great than 17");
        }
        long appCpuTime = Long.parseLong(pidCpuInfoList[13]) + Long.parseLong(pidCpuInfoList[14]) + Long.parseLong(pidCpuInfoList[15]) + Long.parseLong(pidCpuInfoList[16]);
        return new CpuSnapshot(user, system, idle, ioWait, total, appCpuTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CpuInfo getCpuInfoFromShell() {
        Process process = null;
        CpuInfo cpuInfo = new CpuInfo();
        try {
            String line;
            process = Runtime.getRuntime().exec("top -n 1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int cpuIndex = -1;
            Map<String, Float> cpuDevice = null;
            while ((line = reader.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                Map<String, Float> tempCpuDevice = CpuUsage_1.parseCpuRateOfDeviceAndTotalByShell(line);
                if (tempCpuDevice != null) {
                    cpuDevice = tempCpuDevice;
                    Float total = cpuDevice.get("cpu");
                    Float user = cpuDevice.get("user");
                    Float sys = cpuDevice.get("sys");
                    Float idle = cpuDevice.get("idle");
                    Float iow = cpuDevice.get("iow");
                    if (total != null && total.floatValue() > 0.0f && iow != null && iow.floatValue() >= 0.0f) {
                        cpuInfo.ioWaitRatio = iow.floatValue() / total.floatValue();
                    }
                    if (total != null && total.floatValue() > 0.0f && sys != null && sys.floatValue() >= 0.0f) {
                        cpuInfo.sysCpuRatio = sys.floatValue() / total.floatValue();
                    }
                    if (total != null && total.floatValue() > 0.0f && idle != null && idle.floatValue() >= 0.0f) {
                        cpuInfo.totalUseRatio = (total.floatValue() - idle.floatValue()) / total.floatValue();
                    }
                    if (total == null || !(total.floatValue() > 0.0f) || user == null || !(user.floatValue() >= 0.0f)) continue;
                    cpuInfo.userCpuRatio = user.floatValue() / total.floatValue();
                    continue;
                }
                int tempIndex = CpuUsage_1.parseCPUIndex(line);
                if (tempIndex != -1) {
                    cpuIndex = tempIndex;
                    continue;
                }
                float tempAppRatio = CpuUsage_1.parseCpuRateOfAppByShell(line, cpuIndex, cpuDevice == null ? null : cpuDevice.get("cpu"));
                if (tempAppRatio == -1.0f) continue;
                cpuInfo.appCpuRatio = tempAppRatio;
                CpuInfo cpuInfo2 = cpuInfo;
                return cpuInfo2;
            }
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return cpuInfo;
    }

    @VisibleForTesting
    static int parseCPUIndex(String line) {
        if (line.contains("CPU")) {
            String[] titles = line.split("\\s+");
            for (int i = 0; i < titles.length; ++i) {
                if (!titles[i].contains("CPU")) continue;
                return i;
            }
        }
        return -1;
    }

    @VisibleForTesting
    static Map<String, Float> parseCpuRateOfDeviceAndTotalByShell(String line) {
        if (line.matches("^\\d+%\\w+.+\\d+%\\w+")) {
            String lineLowerCase = line.toLowerCase(Locale.US);
            String[] cpuList = lineLowerCase.split("\\s+");
            HashMap<String, Float> cpuMap = new HashMap<String, Float>();
            try {
                for (String s : cpuList) {
                    String[] cpuItem = s.split("%");
                    if (cpuItem.length != 2) {
                        throw new IllegalStateException("parseCpuRateOfDeviceAndTotalByShell but cpuItem.length != 2");
                    }
                    cpuMap.put(cpuItem[1], Float.valueOf(Float.parseFloat(cpuItem[0])));
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException("parseCpuRateOfDeviceAndTotalByShell but " + e);
            }
            return cpuMap;
        }
        return null;
    }

    @VisibleForTesting
    static float parseCpuRateOfAppByShell(String line, int cpuIndex, Float cpuTotal) {
        if (line.startsWith(String.valueOf(android.os.Process.myPid()))) {
            if (cpuIndex == -1) {
                throw new IllegalStateException("parseCpuRateOfAppByShell but cpuIndex == -1:" + line);
            }
            String[] param = line.split("\\s+");
            if (param.length <= cpuIndex) {
                throw new IllegalStateException("parseCpuRateOfAppByShell but param.length <= cpuIndex:" + line);
            }
            String cpu = param[cpuIndex];
            if (cpu.endsWith("%")) {
                cpu = cpu.substring(0, cpu.lastIndexOf("%"));
            }
            if (cpuTotal == null || cpuTotal.floatValue() <= 0.0f) {
                throw new IllegalStateException("parseCpuRateOfAppByShell but cpuTotal == null || cpuTotal <= 0:" + line);
            }
            try {
                return Float.parseFloat(cpu) / cpuTotal.floatValue();
            }
            catch (Throwable e) {
                throw new IllegalStateException("parseCpuRateOfAppByShell but " + e + ":" + line);
            }
        }
        return -1.0f;
    }

    public static void reset() {
        sLastCpuSnapshot = null;
    }
}

