/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm.basicPerf;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.MainThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.apm.basicPerf.BasicPerfTracer;
import com.yy.hiyo.apm.basicPerf.IBasicPerfAdapter;
import com.yy.hiyo.apm.basicPerf.cpu.CpuUsage;
import com.yy.hiyo.apm.basicPerf.fps.FpsData;
import com.yy.hiyo.apm.basicPerf.memory.MemoryUtil;
import com.yy.hiyo.apm.basicPerf.memory.RamInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0007J\u0010\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0007J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020'H\u0007J\b\u0010,\u001a\u00020'H\u0007J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0002J\b\u00101\u001a\u00020'H\u0002J\b\u00102\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/yy/hiyo/apm/basicPerf/BasicPerfTracer;", "", "()V", "BASIC_PERF_THREAD_NAME", "", "DEBUG", "", "TAG", "adapter", "Lcom/yy/hiyo/apm/basicPerf/IBasicPerfAdapter;", "getAdapter", "()Lcom/yy/hiyo/apm/basicPerf/IBasicPerfAdapter;", "setAdapter", "(Lcom/yy/hiyo/apm/basicPerf/IBasicPerfAdapter;)V", "backgroundHandler", "Landroid/os/Handler;", "basicEnable", "beginRamInfo", "Lcom/yy/hiyo/apm/basicPerf/memory/RamInfo;", "cpuRate", "", "Ljava/lang/Float;", "cpuUsage", "Lcom/yy/hiyo/apm/basicPerf/cpu/CpuUsage;", "endRamInfo", "fpsData", "Lcom/yy/hiyo/apm/basicPerf/fps/FpsData;", "fpsEnable", "handlerThread", "Landroid/os/HandlerThread;", "hasGetConfig", "hasInit", "mFpsTag", "mTag", "recordEndFpsMap", "", "recordMap", "recordStartFpsMap", "beginFpsTrace", "", "tag", "beginTrace", "cleanFpsData", "endFpsTrace", "endTrace", "fpsCollectDelay", "", "initConfig", "initialize", "reset", "tryQuit", "apm_release"})
public final class BasicPerfTracer {
    @NotNull
    public static final String TAG = "BasicPerfTracer";
    private static final String BASIC_PERF_THREAD_NAME = "ht-basicperf";
    private static final boolean DEBUG = false;
    private static RamInfo beginRamInfo;
    private static RamInfo endRamInfo;
    private static Float cpuRate;
    private static boolean basicEnable;
    private static boolean hasGetConfig;
    @Nullable
    private static IBasicPerfAdapter adapter;
    private static String mTag;
    private static Handler backgroundHandler;
    private static HandlerThread handlerThread;
    private static final Map<String, Boolean> recordMap;
    private static CpuUsage cpuUsage;
    private static boolean fpsEnable;
    private static final Map<String, Boolean> recordStartFpsMap;
    private static final Map<String, Boolean> recordEndFpsMap;
    private static FpsData fpsData;
    private static String mFpsTag;
    private static boolean hasInit;
    public static final BasicPerfTracer INSTANCE;

    @Nullable
    public final IBasicPerfAdapter getAdapter() {
        return adapter;
    }

    public final void setAdapter(@Nullable IBasicPerfAdapter iBasicPerfAdapter) {
        adapter = iBasicPerfAdapter;
    }

    private final void initialize() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        recordMap.put("game", false);
        recordMap.put("party", false);
        recordMap.put("discovery", false);
        recordStartFpsMap.put("party", false);
        recordStartFpsMap.put("game", false);
        recordEndFpsMap.put("party", false);
        recordEndFpsMap.put("game", false);
        try {
            cpuUsage = new CpuUsage();
            HandlerThread handlerThread = BasicPerfTracer.handlerThread = new HandlerThread(BASIC_PERF_THREAD_NAME);
            if (handlerThread == null) {
                Intrinsics.throwNpe();
            }
            handlerThread.start();
            HandlerThread handlerThread2 = BasicPerfTracer.handlerThread;
            if (handlerThread2 == null) {
                Intrinsics.throwNpe();
            }
            backgroundHandler = new Handler(handlerThread2.getLooper());
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private final void initConfig() {
        block1: {
            if (hasGetConfig) break block1;
            IBasicPerfAdapter iBasicPerfAdapter = adapter;
            if (iBasicPerfAdapter != null) {
                IBasicPerfAdapter iBasicPerfAdapter2 = iBasicPerfAdapter;
                boolean bl = false;
                boolean bl2 = false;
                IBasicPerfAdapter it = iBasicPerfAdapter2;
                boolean bl3 = false;
                basicEnable = DEBUG ? true : it.isBasicEnable();
                fpsEnable = DEBUG ? true : it.isFPSEnable();
                hasGetConfig = true;
            }
        }
    }

    @MainThread
    public final void beginTrace(@NotNull String tag) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.initConfig();
            if (!basicEnable || StringUtils.isEmpty((String)tag)) {
                return;
            }
            this.initialize();
            Handler handler = backgroundHandler;
            if (handler == null) break block1;
            handler.post(new Runnable(tag){
                final /* synthetic */ String $tag;

                public final void run() {
                    block11: {
                        block10: {
                            if (!BasicPerfTracer.access$getRecordMap$p(BasicPerfTracer.INSTANCE).containsKey(this.$tag)) break block10;
                            V v = BasicPerfTracer.access$getRecordMap$p(BasicPerfTracer.INSTANCE).get(this.$tag);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!((Boolean)v).booleanValue()) break block11;
                        }
                        return;
                    }
                    if (StringUtils.isNotEmpty((String)BasicPerfTracer.access$getMTag$p(BasicPerfTracer.INSTANCE))) {
                        return;
                    }
                    try {
                        MLog.debug((Object)"BasicPerfTracer", (String)("beginTrace: " + this.$tag), (Object[])new Object[0]);
                        BasicPerfTracer.access$setMTag$p(BasicPerfTracer.INSTANCE, this.$tag);
                        Map map = BasicPerfTracer.access$getRecordMap$p(BasicPerfTracer.INSTANCE);
                        String string = BasicPerfTracer.access$getMTag$p(BasicPerfTracer.INSTANCE);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        map.put(string, true);
                        Context context = RuntimeContext.sApplicationContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                        BasicPerfTracer.access$setBeginRamInfo$p(BasicPerfTracer.INSTANCE, MemoryUtil.INSTANCE.getRamInfo(context));
                        if (Build.VERSION.SDK_INT < 26) {
                            CpuUsage cpuUsage = BasicPerfTracer.access$getCpuUsage$p(BasicPerfTracer.INSTANCE);
                            if (cpuUsage != null) {
                                cpuUsage.getCpuInfo();
                            }
                        }
                        MLog.debug((Object)"BasicPerfTracer", (String)"[%s] begin trace basic perf; RamInfo: %s", (Object[])new Object[]{BasicPerfTracer.access$getMTag$p(BasicPerfTracer.INSTANCE), BasicPerfTracer.access$getBeginRamInfo$p(BasicPerfTracer.INSTANCE)});
                    }
                    catch (Exception e) {
                        MLog.error((Object)"BasicPerfTracer", (Throwable)e);
                    }
                }
                {
                    this.$tag = string;
                }
            });
        }
    }

    @MainThread
    public final void endTrace() {
        block1: {
            if (!basicEnable) {
                return;
            }
            Handler handler = backgroundHandler;
            if (handler == null) break block1;
            handler.postDelayed((Runnable)endTrace.1.INSTANCE, 500L);
        }
    }

    private final void reset() {
        mTag = null;
        cpuRate = Float.valueOf(0.0f);
        beginRamInfo = null;
        endRamInfo = null;
        CpuUsage cpuUsage = BasicPerfTracer.cpuUsage;
        if (cpuUsage != null) {
            cpuUsage.reset();
        }
        this.tryQuit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void tryQuit() {
        boolean quit = true;
        Iterable $this$forEach$iv = recordMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean it = (Boolean)element$iv;
            boolean bl = false;
            quit = quit && it;
        }
        if (!quit) return;
        try {
            MLog.debug((Object)TAG, (String)"quitSafely", (Object[])new Object[0]);
            HandlerThread handlerThread = BasicPerfTracer.handlerThread;
            if (handlerThread != null) {
                handlerThread.quitSafely();
            }
            backgroundHandler = null;
            if (cpuUsage != null) return;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    @MainThread
    public final void beginFpsTrace(@NotNull String tag) {
        block9: {
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                this.initConfig();
                if (!fpsEnable || StringUtils.isEmpty((String)tag)) {
                    return;
                }
                this.initialize();
                if (!recordStartFpsMap.containsKey(tag)) break block8;
                Boolean bl = recordStartFpsMap.get(tag);
                if (bl == null) {
                    Intrinsics.throwNpe();
                }
                if (!bl.booleanValue()) break block9;
            }
            return;
        }
        MLog.debug((Object)TAG, (String)("beginFpsTrace: " + tag), (Object[])new Object[0]);
        if (fpsData == null) {
            fpsData = new FpsData();
        }
        String string = mFpsTag = tag;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        recordStartFpsMap.put(string, true);
        FpsData fpsData = BasicPerfTracer.fpsData;
        if (fpsData == null) {
            Intrinsics.throwNpe();
        }
        fpsData.startMonitorFrameInfo();
    }

    @MainThread
    public final void endFpsTrace() {
        block12: {
            block11: {
                if (!fpsEnable || StringUtils.isEmpty((String)mFpsTag) || fpsData == null) {
                    return;
                }
                Map<String, Boolean> map = recordEndFpsMap;
                String string = mFpsTag;
                boolean bl = false;
                Map<String, Boolean> map2 = map;
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (!map2.containsKey(string)) break block11;
                map = recordEndFpsMap;
                string = mFpsTag;
                bl = false;
                Boolean bl2 = map.get(string);
                if (bl2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!bl2.booleanValue()) break block12;
            }
            return;
        }
        MLog.debug((Object)TAG, (String)("endFpsTrace: " + mFpsTag), (Object[])new Object[0]);
        FpsData fpsData = BasicPerfTracer.fpsData;
        if (fpsData == null) {
            Intrinsics.throwNpe();
        }
        fpsData.stopMonitorFrameInfo();
        IBasicPerfAdapter iBasicPerfAdapter = adapter;
        if (iBasicPerfAdapter != null) {
            String string = mFpsTag;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            FpsData fpsData2 = BasicPerfTracer.fpsData;
            if (fpsData2 == null) {
                Intrinsics.throwNpe();
            }
            iBasicPerfAdapter.reportFps(string, fpsData2.getAverageFrameRate());
        }
        String string = mFpsTag;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        recordEndFpsMap.put(string, true);
        this.cleanFpsData();
    }

    public final long fpsCollectDelay() {
        long delay = 500L;
        if (RuntimeContext.sPhoneType == 2) {
            delay = 1000L;
        } else if (RuntimeContext.sPhoneType == 1) {
            delay = 1500L;
            if (RuntimeContext.isPhoneSuperLow()) {
                delay = 2000L;
            }
        }
        return delay;
    }

    private final void cleanFpsData() {
        boolean clean = true;
        Iterable $this$forEach$iv = recordStartFpsMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean it = (Boolean)element$iv;
            boolean bl = false;
            clean = clean && it;
        }
        if (clean) {
            MLog.debug((Object)TAG, (String)"cleanFpsData", (Object[])new Object[0]);
            fpsData = null;
            mFpsTag = null;
        }
    }

    private BasicPerfTracer() {
    }

    static {
        BasicPerfTracer basicPerfTracer;
        INSTANCE = basicPerfTracer = new BasicPerfTracer();
        boolean bl = false;
        recordMap = new LinkedHashMap();
        bl = false;
        recordStartFpsMap = new LinkedHashMap();
        bl = false;
        recordEndFpsMap = new LinkedHashMap();
    }

    public static final /* synthetic */ Map access$getRecordMap$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return recordMap;
    }

    public static final /* synthetic */ String access$getMTag$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return mTag;
    }

    public static final /* synthetic */ void access$setMTag$p(BasicPerfTracer $this, String string) {
        BasicPerfTracer basicPerfTracer = $this;
        mTag = string;
    }

    public static final /* synthetic */ RamInfo access$getBeginRamInfo$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return beginRamInfo;
    }

    public static final /* synthetic */ void access$setBeginRamInfo$p(BasicPerfTracer $this, RamInfo ramInfo) {
        BasicPerfTracer basicPerfTracer = $this;
        beginRamInfo = ramInfo;
    }

    public static final /* synthetic */ CpuUsage access$getCpuUsage$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return cpuUsage;
    }

    public static final /* synthetic */ void access$setCpuUsage$p(BasicPerfTracer $this, CpuUsage cpuUsage) {
        BasicPerfTracer basicPerfTracer = $this;
        BasicPerfTracer.cpuUsage = cpuUsage;
    }

    public static final /* synthetic */ RamInfo access$getEndRamInfo$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return endRamInfo;
    }

    public static final /* synthetic */ void access$setEndRamInfo$p(BasicPerfTracer $this, RamInfo ramInfo) {
        BasicPerfTracer basicPerfTracer = $this;
        endRamInfo = ramInfo;
    }

    public static final /* synthetic */ Float access$getCpuRate$p(BasicPerfTracer $this) {
        BasicPerfTracer basicPerfTracer = $this;
        return cpuRate;
    }

    public static final /* synthetic */ void access$setCpuRate$p(BasicPerfTracer $this, Float f) {
        BasicPerfTracer basicPerfTracer = $this;
        cpuRate = f;
    }

    public static final /* synthetic */ void access$reset(BasicPerfTracer $this) {
        $this.reset();
    }
}

