/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public final class JsonSimpleStep {
    private static final String MAVEN_COORDINATE = "org.json:json:";
    private static final String DEFAULT_VERSION = "20210307";

    public static FormatterStep create(int indent, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("json", () -> new State(indent, provisioner), State::toFormatter);
    }

    private JsonSimpleStep() {
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int indentSpaces;
        private final JarState jarState;

        private State(int indent, Provisioner provisioner) throws IOException {
            this.indentSpaces = indent;
            this.jarState = JarState.from("org.json:json:20210307", provisioner);
        }

        FormatterFunc toFormatter() {
            Method arrayToString;
            Constructor<?> arrayConstructor;
            Method objectToString;
            Constructor<?> objectConstructor;
            try {
                ClassLoader classLoader = this.jarState.getClassLoader();
                Class<?> jsonObject = classLoader.loadClass("org.json.JSONObject");
                Class[] constructorArguments = new Class[]{String.class};
                objectConstructor = jsonObject.getConstructor(constructorArguments);
                objectToString = jsonObject.getMethod("toString", Integer.TYPE);
                Class<?> jsonArray = classLoader.loadClass("org.json.JSONArray");
                arrayConstructor = jsonArray.getConstructor(constructorArguments);
                arrayToString = jsonArray.getMethod("toString", Integer.TYPE);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException("There was a problem preparing org.json dependencies", e);
            }
            return s -> {
                if (s.isEmpty()) {
                    return s;
                }
                char first = s.charAt(0);
                if (first == '{') {
                    return this.format(objectConstructor, objectToString, s);
                }
                if (first == '[') {
                    return this.format(arrayConstructor, arrayToString, s);
                }
                throw new AssertionError((Object)String.format("Unable to determine JSON type, expected a '{' or '[' but found '%s'", Character.valueOf(first)));
            };
        }

        private String format(Constructor<?> constructor, Method toString, String input) throws Exception {
            try {
                Object parsed = constructor.newInstance(input);
                return toString.invoke(parsed, this.indentSpaces) + "\n";
            }
            catch (InvocationTargetException ex) {
                throw new AssertionError("Unable to format JSON", ex.getCause());
            }
        }
    }
}

