/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.SerializableFileFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class LicenseHeaderStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "licenseHeader";
    private static final String DEFAULT_YEAR_DELIMITER = "-";
    private static final List<String> YEAR_TOKENS = Arrays.asList("$YEAR", "$today.year");
    private static final SerializableFileFilter UNSUPPORTED_JVM_FILES_FILTER = SerializableFileFilter.skipFilesNamed("package-info.java", "package-info.groovy", "module-info.java");
    private final Pattern delimiterPattern;
    private final String yearSepOrFull;
    @Nullable
    private final String yearToday;
    @Nullable
    private final String beforeYear;
    @Nullable
    private final String afterYear;
    private final boolean updateYearWithLatest;
    private static final Pattern patternYearSingle = Pattern.compile("[0-9]{4}");
    private static final String spotlessSetLicenseHeaderYearsFromGitHistory = "spotlessSetLicenseHeaderYearsFromGitHistory";
    private static final Pattern FIND_YEAR = Pattern.compile("Date:   .* ([0-9]{4}) ");

    public static FormatterStep createFromHeader(String licenseHeader, String delimiter) {
        return LicenseHeaderStep.createFromHeader(licenseHeader, delimiter, DEFAULT_YEAR_DELIMITER);
    }

    public static FormatterStep createFromHeader(String licenseHeader, String delimiter, String yearSeparator) {
        Objects.requireNonNull(licenseHeader, NAME);
        Objects.requireNonNull(delimiter, "delimiter");
        Objects.requireNonNull(yearSeparator, "yearSeparator");
        return FormatterStep.create(NAME, new LicenseHeaderStep(licenseHeader, delimiter, yearSeparator), step -> step::format);
    }

    public static FormatterStep createFromFile(File licenseHeaderFile, Charset encoding, String delimiter) {
        return LicenseHeaderStep.createFromFile(licenseHeaderFile, encoding, delimiter, DEFAULT_YEAR_DELIMITER);
    }

    public static FormatterStep createFromFile(File licenseHeaderFile, Charset encoding, String delimiter, String yearSeparator) {
        Objects.requireNonNull(licenseHeaderFile, "licenseHeaderFile");
        Objects.requireNonNull(encoding, "encoding");
        Objects.requireNonNull(delimiter, "delimiter");
        Objects.requireNonNull(yearSeparator, "yearSeparator");
        return FormatterStep.createLazy(NAME, () -> new LicenseHeaderStep(new String(Files.readAllBytes(licenseHeaderFile.toPath()), encoding), delimiter, yearSeparator), step -> step::format);
    }

    public static String name() {
        return NAME;
    }

    public static String defaultYearDelimiter() {
        return DEFAULT_YEAR_DELIMITER;
    }

    public static SerializableFileFilter unsupportedJvmFilesFilter() {
        return UNSUPPORTED_JVM_FILES_FILTER;
    }

    private LicenseHeaderStep(String licenseHeader, String delimiter, String yearSeparator) {
        this(licenseHeader, delimiter, yearSeparator, false);
    }

    public LicenseHeaderStep(String licenseHeader, String delimiter, String yearSeparator, boolean updateYearWithLatest) {
        if (delimiter.contains("\n")) {
            throw new IllegalArgumentException("The delimiter must not contain any newlines.");
        }
        if (!(licenseHeader = LineEnding.toUnix(licenseHeader)).endsWith("\n")) {
            licenseHeader = licenseHeader + "\n";
        }
        this.delimiterPattern = Pattern.compile('^' + delimiter, 9);
        Optional<String> yearToken = LicenseHeaderStep.getYearToken(licenseHeader);
        if (yearToken.isPresent()) {
            this.yearToday = String.valueOf(YearMonth.now().getYear());
            int yearTokenIndex = licenseHeader.indexOf(yearToken.get());
            this.beforeYear = licenseHeader.substring(0, yearTokenIndex);
            this.afterYear = licenseHeader.substring(yearTokenIndex + yearToken.get().length());
            this.yearSepOrFull = yearSeparator;
            this.updateYearWithLatest = updateYearWithLatest;
        } else {
            this.yearToday = null;
            this.beforeYear = null;
            this.afterYear = null;
            this.yearSepOrFull = licenseHeader;
            this.updateYearWithLatest = false;
        }
    }

    private static Optional<String> getYearToken(String licenseHeader) {
        return YEAR_TOKENS.stream().filter(licenseHeader::contains).findFirst();
    }

    public String format(String raw) {
        Matcher contentMatcher = this.delimiterPattern.matcher(raw);
        if (!contentMatcher.find()) {
            throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
        }
        if (this.yearToday == null) {
            if (contentMatcher.start() == this.yearSepOrFull.length() && raw.startsWith(this.yearSepOrFull)) {
                return raw;
            }
            return this.yearSepOrFull + raw.substring(contentMatcher.start());
        }
        int beforeYearIdx = raw.indexOf(this.beforeYear);
        int afterYearIdx = raw.indexOf(this.afterYear, beforeYearIdx + this.beforeYear.length() + 1);
        if (beforeYearIdx >= 0 && afterYearIdx >= 0 && afterYearIdx + this.afterYear.length() <= contentMatcher.start()) {
            boolean noPadding = beforeYearIdx == 0 && afterYearIdx + this.afterYear.length() == contentMatcher.start();
            String parsedYear = raw.substring(beforeYearIdx + this.beforeYear.length(), afterYearIdx);
            if (parsedYear.equals(this.yearToday)) {
                return noPadding ? raw : this.beforeYear + this.yearToday + this.afterYear + raw.substring(contentMatcher.start());
            }
            if (patternYearSingle.matcher(parsedYear).matches()) {
                if (this.updateYearWithLatest) {
                    return this.beforeYear + parsedYear + this.yearSepOrFull + this.yearToday + this.afterYear + raw.substring(contentMatcher.start());
                }
                return noPadding ? raw : this.beforeYear + parsedYear + this.afterYear + raw.substring(contentMatcher.start());
            }
            Matcher yearMatcher = patternYearSingle.matcher(parsedYear);
            if (yearMatcher.find()) {
                String firstYear = yearMatcher.group();
                String secondYear = this.updateYearWithLatest ? (firstYear.equals(this.yearToday) ? null : this.yearToday) : (yearMatcher.find(yearMatcher.end() + 1) ? yearMatcher.group() : null);
                String newYear = secondYear == null ? firstYear : firstYear + this.yearSepOrFull + secondYear;
                return noPadding && newYear.equals(parsedYear) ? raw : this.beforeYear + newYear + this.afterYear + raw.substring(contentMatcher.start());
            }
        }
        return this.beforeYear + this.yearToday + this.afterYear + raw.substring(contentMatcher.start());
    }

    public static final String FLAG_SET_LICENSE_HEADER_YEARS_FROM_GIT_HISTORY() {
        return spotlessSetLicenseHeaderYearsFromGitHistory;
    }

    public String setLicenseHeaderYearsFromGitHistory(String raw, File file) throws IOException {
        String oldYear;
        if (this.yearToday == null) {
            return raw;
        }
        Matcher contentMatcher = this.delimiterPattern.matcher(raw);
        if (!contentMatcher.find()) {
            throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
        }
        try {
            oldYear = LicenseHeaderStep.parseYear("git log --follow --find-renames=40% --diff-filter=A", file);
        }
        catch (IllegalArgumentException e) {
            oldYear = LicenseHeaderStep.parseYear("git log --follow --find-renames=40% --reverse", file);
        }
        String newYear = LicenseHeaderStep.parseYear("git log --max-count=1", file);
        String yearRange = oldYear.equals(newYear) ? oldYear : oldYear + this.yearSepOrFull + newYear;
        return this.beforeYear + yearRange + this.afterYear + raw.substring(contentMatcher.start());
    }

    private static String parseYear(String cmd, File file) throws IOException {
        String fullCmd = cmd + " " + file.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(file.getParentFile());
        if (LineEnding.nativeIsWin()) {
            builder.command("cmd", "/c", fullCmd);
        } else {
            builder.command("bash", "-c", fullCmd);
        }
        Process process = builder.start();
        String output = LicenseHeaderStep.drain(process.getInputStream());
        String error = LicenseHeaderStep.drain(process.getErrorStream());
        if (!error.isEmpty()) {
            throw new IllegalArgumentException("Error for command '" + fullCmd + "':\n" + error);
        }
        Matcher matcher = FIND_YEAR.matcher(output);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Unable to parse date from command '" + fullCmd + "':\n" + output);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private static String drain(InputStream stream) throws IOException {
        int numRead;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((numRead = stream.read(buf)) != -1) {
            output.write(buf, 0, numRead);
        }
        return new String(output.toByteArray());
    }
}

