/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KtLintStep {
    private static final Pattern VERSION_MATCHER = Pattern.compile("0\\.(\\d+)\\.\\d+");
    private static final String DEFAULT_VERSION = "0.34.2";
    static final String NAME = "ktlint";
    static final String PACKAGE_PRE_0_32 = "com.github.shyiko";
    static final String PACKAGE = "com.pinterest";
    static final String MAVEN_COORDINATE_PRE_0_32 = "com.github.shyiko:ktlint:";
    static final String MAVEN_COORDINATE = "com.pinterest:ktlint:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, Collections.emptyMap());
    }

    public static FormatterStep create(String version, Provisioner provisioner, Map<String, String> userData) {
        return KtLintStep.create(version, provisioner, false, userData);
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, true, Collections.emptyMap());
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner, Map<String, String> userData) {
        return KtLintStep.create(version, provisioner, true, userData);
    }

    private static FormatterStep create(String version, Provisioner provisioner, boolean isScript, Map<String, String> userData) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, isScript, userData), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        private final String pkg;
        final JarState jarState;
        private final TreeMap<String, String> userData;
        private final boolean useParams;

        State(String version, Provisioner provisioner, boolean isScript, Map<String, String> userData) throws IOException {
            String coordinate;
            this.userData = new TreeMap<String, String>(userData);
            Matcher matcher = VERSION_MATCHER.matcher(version);
            boolean matches = matcher.matches();
            if (matches && Integer.parseInt(matcher.group(1)) < 32) {
                coordinate = KtLintStep.MAVEN_COORDINATE_PRE_0_32;
                this.pkg = KtLintStep.PACKAGE_PRE_0_32;
            } else {
                coordinate = KtLintStep.MAVEN_COORDINATE;
                this.pkg = KtLintStep.PACKAGE;
            }
            this.useParams = matches && Integer.parseInt(matcher.group(1)) >= 34;
            this.jarState = JarState.from(coordinate + version, provisioner);
            this.isScript = isScript;
        }

        FormatterFunc createFormat() throws Exception {
            FormatterFunc formatterFunc;
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> standardRuleSetProviderClass = classLoader.loadClass(this.pkg + ".ktlint.ruleset.standard.StandardRuleSetProvider");
            Object standardRuleSet = standardRuleSetProviderClass.getMethod("get", new Class[0]).invoke(standardRuleSetProviderClass.newInstance(), new Object[0]);
            List<Object> ruleSets = Collections.singletonList(standardRuleSet);
            Class<?> function2Interface = classLoader.loadClass("kotlin.jvm.functions.Function2");
            Class<?> lintErrorClass = classLoader.loadClass(this.pkg + ".ktlint.core.LintError");
            Method detailGetter = lintErrorClass.getMethod("getDetail", new Class[0]);
            Method lineGetter = lintErrorClass.getMethod("getLine", new Class[0]);
            Method colGetter = lintErrorClass.getMethod("getCol", new Class[0]);
            Object formatterCallback = Proxy.newProxyInstance(classLoader, new Class[]{function2Interface}, (proxy, method, args) -> {
                Object lintError = args[0];
                boolean corrected = (Boolean)args[1];
                if (!corrected) {
                    String detail = (String)detailGetter.invoke(lintError, new Object[0]);
                    int line = (Integer)lineGetter.invoke(lintError, new Object[0]);
                    int col = (Integer)colGetter.invoke(lintError, new Object[0]);
                    throw new AssertionError((Object)("Error on line: " + line + ", column: " + col + "\n" + detail));
                }
                return null;
            });
            Class<?> ktlintClass = classLoader.loadClass(this.pkg + ".ktlint.core.KtLint");
            Object ktlint = ktlintClass.getDeclaredField("INSTANCE").get(null);
            if (this.useParams) {
                Class<?> paramsClass = classLoader.loadClass(this.pkg + ".ktlint.core.KtLint$Params");
                Constructor<?> constructor = paramsClass.getConstructor(String.class, String.class, Iterable.class, Map.class, function2Interface, Boolean.TYPE, String.class, Boolean.TYPE);
                Method formatterMethod = ktlintClass.getMethod("format", paramsClass);
                formatterFunc = input -> {
                    try {
                        Object params = constructor.newInstance(null, input, ruleSets, this.userData, formatterCallback, this.isScript, null, false);
                        return (String)formatterMethod.invoke(ktlint, params);
                    }
                    catch (InvocationTargetException e) {
                        throw ThrowingEx.unwrapCause(e);
                    }
                };
            } else {
                String formatterMethodName = this.isScript ? "formatScript" : "format";
                Method formatterMethod = ktlintClass.getMethod(formatterMethodName, String.class, Iterable.class, Map.class, function2Interface);
                formatterFunc = input -> {
                    try {
                        return (String)formatterMethod.invoke(ktlint, input, ruleSets, this.userData, formatterCallback);
                    }
                    catch (InvocationTargetException e) {
                        throw ThrowingEx.unwrapCause(e);
                    }
                };
            }
            return formatterFunc;
        }
    }
}

