/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PaddedCellBulk {
    private static final Logger logger = Logger.getLogger(PaddedCellBulk.class.getName());
    private static final SimpleFileVisitor<Path> FOLDER_CLEANING_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            return this.handleException(e);
        }

        private FileVisitResult handleException(IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return FileVisitResult.TERMINATE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
            if (e != null) {
                return this.handleException(e);
            }
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    };

    public static boolean anyMisbehave(Formatter formatter, List<File> problemFiles) {
        return PaddedCellBulk.anyMisbehave(formatter, problemFiles, 500L);
    }

    public static boolean anyMisbehave(Formatter formatter, List<File> problemFiles, long timeoutMs) {
        Objects.requireNonNull(formatter, "formatter");
        Objects.requireNonNull(problemFiles, "problemFiles");
        long start = System.currentTimeMillis();
        for (File problem : problemFiles) {
            PaddedCell padded = PaddedCell.check(formatter, problem);
            if (padded.misbehaved()) {
                return true;
            }
            if (timeoutMs <= 0L || System.currentTimeMillis() - start <= timeoutMs) continue;
            return false;
        }
        return false;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static List<File> check(File rootDir, File diagnoseDir, Formatter formatter, List<File> problemFiles) throws IOException {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(diagnoseDir, "diagnoseDir");
        Objects.requireNonNull(formatter, "formatter");
        Objects.requireNonNull(problemFiles, "problemFiles");
        FakeStep paddedCellStep = new FakeStep();
        Formatter paddedFormatter = Formatter.builder().lineEndingsPolicy(formatter.getLineEndingsPolicy()).encoding(formatter.getEncoding()).rootDir(formatter.getRootDir()).steps(Collections.singletonList(paddedCellStep)).exceptionPolicy(formatter.getExceptionPolicy()).build();
        Path rootPath = rootDir.toPath();
        Path diagnosePath = diagnoseDir.toPath();
        PaddedCellBulk.cleanDir(diagnosePath);
        ArrayList<File> stillFailing = new ArrayList<File>();
        for (File problemFile : problemFiles) {
            logger.fine("Running padded cell check on " + problemFile);
            PaddedCell padded = PaddedCell.check(formatter, problemFile);
            if (!padded.misbehaved()) {
                logger.fine("    well-behaved.");
                continue;
            }
            Path relative = rootPath.relativize(problemFile.toPath());
            Path diagnoseFile = diagnosePath.resolve(relative);
            for (int i = 0; i < padded.steps().size(); ++i) {
                Path path = Paths.get(diagnoseFile + "." + padded.type().name().toLowerCase(Locale.ROOT) + i, new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                String version = padded.steps().get(i);
                Files.write(path, version.getBytes(formatter.getEncoding()), new OpenOption[0]);
            }
            logger.finer("    " + relative + " " + padded.userMessage());
            if (!padded.isResolvable()) continue;
            paddedCellStep.set(problemFile, padded.canonical());
            if (paddedFormatter.isClean(problemFile)) continue;
            stillFailing.add(problemFile);
        }
        return stillFailing;
    }

    public static void apply(Formatter formatter, File file) throws IOException {
        PaddedCellBulk.applyAnyChanged(formatter, file);
    }

    public static boolean applyAnyChanged(Formatter formatter, File file) throws IOException {
        Objects.requireNonNull(formatter, "formatter");
        Objects.requireNonNull(file, "file");
        byte[] rawBytes = Files.readAllBytes(file.toPath());
        String raw = new String(rawBytes, formatter.getEncoding());
        String rawUnix = LineEnding.toUnix(raw);
        String formattedUnix = formatter.compute(rawUnix, file);
        String formatted = formatter.computeLineEndings(formattedUnix, file);
        byte[] formattedBytes = formatted.getBytes(formatter.getEncoding());
        if (Arrays.equals(rawBytes, formattedBytes)) {
            return false;
        }
        PaddedCell cell = PaddedCell.check(formatter, file, rawUnix);
        if (!cell.isResolvable()) {
            return false;
        }
        String canonicalUnix = cell.canonical();
        String canonical = formatter.computeLineEndings(canonicalUnix, file);
        byte[] canonicalBytes = canonical.getBytes(formatter.getEncoding());
        if (!Arrays.equals(rawBytes, canonicalBytes)) {
            Files.write(file.toPath(), canonicalBytes, StandardOpenOption.TRUNCATE_EXISTING);
            return true;
        }
        return false;
    }

    private static void cleanDir(Path folder) throws IOException {
        if (Files.exists(folder, new LinkOption[0])) {
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Files.walkFileTree(folder, FOLDER_CLEANING_VISITOR);
            } else {
                Files.delete(folder);
            }
        }
        Files.createDirectories(folder, new FileAttribute[0]);
    }

    @SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
    static class FakeStep
    implements FormatterStep {
        private File file;
        private String formatted;

        FakeStep() {
        }

        void set(File file, String formatted) {
            this.file = file;
            this.formatted = formatted;
        }

        @Override
        public String format(String raw, File file) throws Exception {
            if (file.equals(this.file)) {
                this.file = null;
                return Objects.requireNonNull(this.formatted);
            }
            throw new IllegalArgumentException("Must call set() before each call to format.");
        }

        @Override
        public String getName() {
            return "Padded cell result";
        }
    }
}

