/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.wtp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public enum EclipseWtpFormatterStep {
    CSS("EclipseCssFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    HTML("EclipseHtmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JS("EclipseJsFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JSON("EclipseJsonFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    XML("EclipseXmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithFile));

    private static final String NAME = "eclipse wtp formatters";
    private static final String FORMATTER_PACKAGE = "com.diffplug.spotless.extra.eclipse.wtp.";
    private static final String DEFAULT_VERSION = "4.13.0";
    private static final String FORMATTER_METHOD = "format";
    private final String implementationClassName;
    private final ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall;

    private EclipseWtpFormatterStep(String implementationClassName, ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall) {
        this.implementationClassName = implementationClassName;
        this.formatterCall = formatterCall;
    }

    public EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - " + this.toString(), provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> (FormatterFunc)this.formatterCall.apply((Object)this.implementationClassName, state)));
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    @Deprecated
    public static EclipseBasedStepBuilder createCssBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - css", provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> EclipseWtpFormatterStep.applyWithoutFile("EclipseCssFormatterStepImpl", state)));
    }

    @Deprecated
    public static EclipseBasedStepBuilder createHtmlBuilder(Provisioner provisioner) {
        return HTML.createBuilder(provisioner);
    }

    @Deprecated
    public static EclipseBasedStepBuilder createJsBuilder(Provisioner provisioner) {
        return JS.createBuilder(provisioner);
    }

    @Deprecated
    public static EclipseBasedStepBuilder createJsonBuilder(Provisioner provisioner) {
        return JSON.createBuilder(provisioner);
    }

    @Deprecated
    public static EclipseBasedStepBuilder createXmlBuilder(Provisioner provisioner) {
        return XML.createBuilder(provisioner);
    }

    private static FormatterFunc applyWithoutFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static FormatterFuncWithFile applyWithFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class, String.class);
        return (input, source) -> {
            try {
                return (String)method.invoke(formatter, input, source.getAbsolutePath());
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static interface FormatterFuncWithFile
    extends FormatterFunc {
        default public String apply(String input) throws Exception {
            throw new UnsupportedOperationException("Formatter requires file path of source.");
        }

        public String apply(String var1, File var2) throws Exception;
    }
}

