/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.Vector;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.LineIndentations;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyLineWrapper {
    public DefaultGroovyFormatter formatter;
    private final IFormatterPreferences preferences;
    private final LineIndentations lineIndentation;
    MultiTextEdit lineWraps;

    public GroovyLineWrapper(DefaultGroovyFormatter defaultGroovyFormatter, IFormatterPreferences pref, LineIndentations lineIndentations) {
        this.formatter = defaultGroovyFormatter;
        this.preferences = pref;
        this.lineIndentation = lineIndentations;
        this.lineWraps = new MultiTextEdit();
    }

    public TextEdit getLineWrapEdits() throws BadLocationException {
        Vector<Vector<Token>> tokenLines = this.formatter.getLineTokens();
        int line = 0;
        while (line < tokenLines.size()) {
            Token lastTokenOnLine = tokenLines.get(line).get(tokenLines.get(line).size() - 1);
            if (lastTokenOnLine.getColumn() >= this.preferences.getMaxLineLength()) {
                int lastToken;
                int offsetInLine = 0;
                while ((lastToken = this.getLastTokenPositionUnderMaximum(tokenLines.get(line), offsetInLine)) > 0 && lastToken != tokenLines.get(line).size() - 2) {
                    int replOffset = this.formatter.getOffsetOfTokenEnd(tokenLines.get(line).get(lastToken));
                    int replLength = this.formatter.getOffsetOfToken(tokenLines.get(line).get(lastToken + 1)) - replOffset;
                    String insert = this.formatter.getNewLine();
                    int indentationLevel = this.lineIndentation.getLineIndentation(lastTokenOnLine.getLine());
                    if (!this.lineIndentation.isMultilineIndentation(lastTokenOnLine.getLine())) {
                        indentationLevel += this.preferences.getIndentationMultiline();
                    }
                    String leadingGap = this.formatter.getLeadingGap(indentationLevel);
                    this.lineWraps.addChild(new ReplaceEdit(replOffset, replLength, String.valueOf(insert) + leadingGap));
                    offsetInLine = tokenLines.get(line).get(lastToken + 1).getColumn() - leadingGap.length();
                }
            }
            ++line;
        }
        return this.lineWraps;
    }

    private int getLastTokenPositionUnderMaximum(Vector<Token> vector, int offsetInLine) throws BadLocationException {
        int i = vector.size() - 2;
        while (i >= 0) {
            Token token = vector.get(i);
            if (token.getColumn() - offsetInLine + this.formatter.getTokenLength(token) <= this.preferences.getMaxLineLength()) {
                return i;
            }
            --i;
        }
        return 0;
    }
}

