/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.greclipse.GroovyTokenTypeBridge;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyIndentationService {
    private IJavaProject project;
    private IFormatterPreferences prefs;
    private GroovyDocumentScanner cachedScanner;
    private static Set<Integer> jumpIn = new HashSet<Integer>();
    private static Set<Integer> jumpOut = new HashSet<Integer>();
    private static Map<Integer, Integer> closer2opener = new HashMap<Integer, Integer>();
    private static GroovyIndentationService lastIndentor;

    static {
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LCURLY, GroovyTokenTypeBridge.RCURLY);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LBRACK, GroovyTokenTypeBridge.RBRACK);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LPAREN, GroovyTokenTypeBridge.RPAREN);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.STRING_CTOR_START, GroovyTokenTypeBridge.STRING_CTOR_END);
    }

    public static synchronized GroovyIndentationService get(IJavaProject javaProject) {
        if (lastIndentor == null || lastIndentor.getJavaProject() != javaProject) {
            lastIndentor = new GroovyIndentationService(javaProject);
        }
        return lastIndentor;
    }

    public static String getLeadingWhiteSpace(String text) {
        int i = 0;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return text.substring(0, i);
    }

    public static String getLine(IDocument d, int lineNum) {
        try {
            String delim = d.getLineDelimiter(lineNum);
            int delimLen = delim == null ? 0 : delim.length();
            String string = d.get(d.getLineOffset(lineNum), d.getLineLength(lineNum) - delimLen);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static String getLineLeadingWhiteSpace(IDocument d, int line) {
        return GroovyIndentationService.getLeadingWhiteSpace(GroovyIndentationService.getLine(d, line));
    }

    public static String getLineTextUpto(IDocument d, int offset) throws BadLocationException {
        int line = d.getLineOfOffset(offset);
        int lineStart = d.getLineOffset(line);
        String lineStartText = d.get(lineStart, offset - lineStart);
        return lineStartText;
    }

    private static void openClosePair(int opener, int closer) {
        Assert.isTrue(!closer2opener.containsKey(closer));
        closer2opener.put(closer, opener);
        jumpIn.add(opener);
        jumpOut.add(closer);
    }

    public GroovyIndentationService(IJavaProject project) {
        this.project = project;
    }

    public int computeIndentAfterNewline(IDocument d, int offset) throws BadLocationException {
        List<Token> tokens;
        int line;
        Token token;
        int orgIndentLevel = token == null ? 0 : this.getLineIndentLevel(d, line);
        int indentLevel = this.simpleComputeNextLineIndentLevel(orgIndentLevel, tokens = this.getTokens(d, d.getLineOffset(line = (token = this.getTokenBefore(d, offset)) == null ? 0 : this.getLine(token)), offset));
        if (indentLevel < orgIndentLevel) {
            Token lastToken = tokens.get(tokens.size() - 1);
            if (lastToken.getType() == GroovyTokenTypeBridge.NLS) {
                lastToken = this.getTokenBefore(d, lastToken);
            }
            if (this.isCloserOfPair(lastToken)) {
                indentLevel = this.getIndentLevelForCloserPair(d, lastToken);
            }
        }
        return indentLevel;
    }

    private int getLine(Token token) {
        return token.getLine() - 1;
    }

    public int computeIndentForLine(IDocument d, int line) {
        block4: {
            try {
                if (line != 0) break block4;
                return 0;
            }
            catch (BadLocationException e) {
                GroovyCore.logException("internal error", e);
                return 0;
            }
        }
        Token nextToken = this.getTokenFrom(d, d.getLineOffset(line));
        if (this.isCloserOfPair(nextToken)) {
            return this.getIndentLevelForCloserPair(d, nextToken);
        }
        IRegion prevLine = d.getLineInformation(line - 1);
        return this.computeIndentAfterNewline(d, prevLine.getOffset() + prevLine.getLength());
    }

    public String createIndentation(int spaces) {
        return GroovyIndentationService.createIndentation(this.getPrefs(), spaces);
    }

    public void dispose() {
        this.project = null;
        if (this.cachedScanner != null) {
            this.cachedScanner.dispose();
            this.cachedScanner = null;
        }
        this.prefs = null;
    }

    public void disposePrefs() {
        this.prefs = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void fixIndentation(Document workCopy, int line, int newIndentLevel) {
        try {
            IRegion lineRegion = workCopy.getLineInformation(line);
            String text = workCopy.get(lineRegion.getOffset(), lineRegion.getLength()).trim();
            text = String.valueOf(this.createIndentation(newIndentLevel)) + text;
            workCopy.replace(lineRegion.getOffset(), lineRegion.getLength(), text);
        }
        catch (BadLocationException e) {
            GroovyCore.logException("internal error", e);
        }
    }

    private GroovyDocumentScanner getGroovyDocumentScanner(IDocument d) {
        if (this.cachedScanner != null && this.cachedScanner.getDocument() == d) {
            return this.cachedScanner;
        }
        if (this.cachedScanner != null) {
            this.cachedScanner.dispose();
            this.cachedScanner = null;
        }
        this.cachedScanner = new GroovyDocumentScanner(d);
        return this.cachedScanner;
    }

    public int getIndentLevel(IDocument d, int offset) {
        try {
            return this.getLineIndentLevel(d, d.getLineOfOffset(offset));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int getIndentLevelForCloserPair(IDocument d, Token closer) {
        GroovyDocumentScanner scanner = this.getGroovyDocumentScanner(d);
        int closerType = closer.getType();
        int openerType = closer2opener.get(closerType);
        int closeCount = 1;
        Token token = closer;
        try {
            while (closeCount != 0 && (token = scanner.getLastTokenBefore(token)) != null) {
                if (token.getType() == openerType) {
                    --closeCount;
                }
                if (token.getType() != closerType) continue;
                ++closeCount;
            }
            return this.getIndentLevel(d, scanner.getOffset(token));
        }
        catch (BadLocationException badLocationException) {
            try {
                return this.getIndentLevel(d, scanner.getOffset(closer));
            }
            catch (BadLocationException badLocationException2) {
                return 0;
            }
        }
    }

    public IJavaProject getJavaProject() {
        return this.project;
    }

    public String getLineDelimiter(IDocument d, int lineNum) throws BadLocationException {
        String result = d.getLineDelimiter(lineNum);
        if (result == null) {
            return "";
        }
        return result;
    }

    public int getLineIndentLevel(IDocument d, int lineNum) {
        return this.indentLevel(GroovyIndentationService.getLine(d, lineNum));
    }

    private List<Token> getLineTokensUpto(IDocument d, int offset) {
        return this.getGroovyDocumentScanner(d).getLineTokensUpto(offset);
    }

    public IFormatterPreferences getPrefs() {
        if (this.prefs == null) {
            this.refreshPrefs();
        }
        return this.prefs;
    }

    public String getTabString() {
        return this.createIndentation(this.getPrefs().getTabSize());
    }

    private Token getTokenBefore(IDocument d, Token token) throws BadLocationException {
        return this.getGroovyDocumentScanner(d).getLastTokenBefore(token);
    }

    private Token getTokenBefore(IDocument d, int offset) throws BadLocationException {
        return this.getGroovyDocumentScanner(d).getLastTokenBefore(offset);
    }

    private Token getTokenFrom(IDocument d, int offset) {
        return this.getGroovyDocumentScanner(d).getTokenFrom(offset);
    }

    private List<Token> getTokens(IDocument d, int start, int end) {
        return this.getGroovyDocumentScanner(d).getTokens(start, end);
    }

    public int indentLevel(String lineText) {
        int level = 0;
        int i = 0;
        while (i < lineText.length()) {
            switch (lineText.charAt(i)) {
                case ' ': {
                    ++level;
                    break;
                }
                case '\t': {
                    level += this.getPrefs().getTabSize();
                    break;
                }
                default: {
                    return level;
                }
            }
            ++i;
        }
        return level;
    }

    public boolean isAfterOpeningBrace(IDocument d, int pos) {
        Token token = this.getGroovyDocumentScanner(d).getLastTokenBefore(pos);
        return token != null && token.getType() == GroovyTokenTypeBridge.LCURLY;
    }

    private boolean isCloserOfPair(Token lastToken) {
        return closer2opener.containsKey(lastToken.getType());
    }

    public boolean isEndOfLine(IDocument d, int pos) {
        Token token = this.getGroovyDocumentScanner(d).getTokenFrom(pos);
        return token == null || token.getType() == GroovyTokenTypeBridge.NLS || token.getType() == GroovyTokenTypeBridge.EOF;
    }

    public boolean isInEmptyLine(IDocument d, int offset) {
        try {
            int line = d.getLineOfOffset(offset);
            String text = GroovyIndentationService.getLine(d, line);
            return text.trim().length() == 0;
        }
        catch (BadLocationException e) {
            GroovyCore.logException("Internal error", e);
            return false;
        }
    }

    public String newline(IDocument d) {
        return TextUtilities.getDefaultLineDelimiter(d);
    }

    public void refreshPrefs() {
        this.prefs = new FormatterPreferences(this.project);
    }

    private int simpleComputeNextLineIndentLevel(int indentLevel, List<Token> tokens) {
        int adjust = this.getOpenVersusCloseBalance(tokens);
        if (adjust > 0) {
            indentLevel += this.getPrefs().getIndentationSize();
        } else if (adjust < 0) {
            indentLevel -= this.getPrefs().getIndentationSize();
        }
        return indentLevel;
    }

    public int getOpenVersusCloseBalance(List<Token> tokens) {
        int adjust = 0;
        for (Token tok : tokens) {
            if (jumpIn.contains(tok.getType())) {
                ++adjust;
            }
            if (!jumpOut.contains(tok.getType())) continue;
            --adjust;
        }
        return adjust;
    }

    public static String createIndentation(IFormatterPreferences pref, int spaces) {
        StringBuilder gap = new StringBuilder();
        if (pref.useTabs()) {
            int tabSize = pref.getTabSize();
            while (spaces >= tabSize) {
                gap.append('\t');
                spaces -= tabSize;
            }
            while (spaces > 0) {
                gap.append(' ');
                --spaces;
            }
        } else {
            int i = 0;
            while (i < spaces) {
                gap.append(' ');
                ++i;
            }
        }
        return gap.toString();
    }

    public boolean moreOpenThanCloseBefore(IDocument d, int offset) {
        return this.getOpenVersusCloseBalance(this.getLineTokensUpto(d, offset)) > 0;
    }

    public int lengthToNextCurly(IDocument d, int offset) throws BadLocationException {
        Token token = this.getTokenFrom(d, offset);
        if (!this.isEndOfLine(d, offset) && GroovyTokenTypeBridge.RCURLY == token.getType()) {
            return token.getColumn() - offset + d.getLineOffset(d.getLineOfOffset(offset));
        }
        return 0;
    }
}

