/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.greclipse.GroovyTokenTypeBridge;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTScanner;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.ClosuresInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.KlenkDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.ListInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.CorrectLineWrap;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.NextLine;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.SameLine;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyBeautifier {
    private static final boolean DEBUG_EDITS = false;
    public DefaultGroovyFormatter formatter;
    private final IFormatterPreferences preferences;
    private final Set<Token> ignoreToken;

    public GroovyBeautifier(DefaultGroovyFormatter defaultGroovyFormatter, IFormatterPreferences pref) {
        this.formatter = defaultGroovyFormatter;
        this.preferences = pref;
        this.ignoreToken = new HashSet<Token>();
    }

    public TextEdit getBeautifiEdits() throws MalformedTreeException, BadLocationException {
        MultiTextEdit edits = new MultiTextEdit();
        this.combineClosures(edits);
        this.formatLists(edits);
        this.correctBraces(edits);
        this.removeUnnecessarySemicolons(edits);
        this.formatter.getTokens().dispose();
        return edits;
    }

    private void formatLists(MultiTextEdit edits) {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ListInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode _node : scanner.getMatchedNodes().keySet()) {
            Token before;
            Expression exp;
            int i;
            boolean nextTokenAs;
            Token maybeAs;
            Token lastToken;
            KlenkDocumentScanner tokens;
            ListExpression node;
            block15: {
                node = (ListExpression)_node;
                tokens = this.formatter.getTokens();
                lastToken = null;
                try {
                    lastToken = tokens.getLastNonWhitespaceTokenBefore(node.getEnd() - 1);
                    if (lastToken == null) continue;
                    if (lastToken.getType() == GroovyTokenTypeBridge.STRING_CTOR_START) {
                    }
                    break block15;
                }
                catch (BadLocationException e) {
                    Util.log(e);
                }
                continue;
            }
            int nodeStart = node.getStart();
            int nodeEnd = node.getEnd();
            int nodeLen = nodeEnd - nodeStart;
            boolean isLong = (nodeLen = this.correctNodeLen(nodeLen, tokens.tokens, this.formatter.getNewLine())) > this.preferences.getLongListLength();
            List<Expression> exps = node.getExpressions();
            try {
                maybeAs = tokens.getNextToken(lastToken);
            }
            catch (BadLocationException e) {
                GroovyCore.logException("Trouble getting next token", e);
                maybeAs = null;
            }
            boolean bl = nextTokenAs = maybeAs != null && maybeAs.getType() == GroovyTokenTypeBridge.LITERAL_as;
            if (isLong || this.hasClosureElement(node) && node.getExpressions().size() > 1) {
                i = 0;
                while (i < exps.size()) {
                    exp = exps.get(i);
                    before = tokens.getLastTokenBefore(exp.getStart());
                    try {
                        while (before.getType() != GroovyTokenTypeBridge.LBRACK && before.getType() != GroovyTokenTypeBridge.COMMA) {
                            before = tokens.getLastTokenBefore(before);
                        }
                        this.replaceWhiteSpaceAfter(edits, before, this.formatter.getNewLine());
                    }
                    catch (BadLocationException e) {
                        GroovyCore.logException("Trouble formatting list", e);
                    }
                    ++i;
                }
                if (nextTokenAs) continue;
                this.replaceWhiteSpaceAfter(edits, lastToken, this.formatter.getNewLine());
                continue;
            }
            i = 0;
            while (i < exps.size()) {
                exp = exps.get(i);
                before = tokens.getLastTokenBefore(exp.getStart());
                try {
                    while (before.getType() != GroovyTokenTypeBridge.LBRACK && before.getType() != GroovyTokenTypeBridge.COMMA) {
                        before = tokens.getLastTokenBefore(before);
                    }
                    this.replaceWhiteSpaceAfter(edits, before, before.getType() == GroovyTokenTypeBridge.LBRACK ? "" : " ");
                }
                catch (BadLocationException e) {
                    Util.log(e);
                }
                ++i;
            }
            if (nextTokenAs) continue;
            this.replaceWhiteSpaceAfter(edits, lastToken, lastToken.getType() == GroovyTokenTypeBridge.SL_COMMENT ? this.formatter.getNewLine() : "");
        }
    }

    private int correctNodeLen(int nodeLen, List<Token> tokens, String newLine) {
        if (newLine.length() > 1) {
            for (Token token : tokens) {
                if (token.getType() != GroovyTokenTypeBridge.NLS) continue;
                nodeLen -= newLine.length() - 1;
            }
        }
        return nodeLen;
    }

    private void replaceWhiteSpaceAfter(MultiTextEdit edits, Token token, String replaceWith) {
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        try {
            Token first;
            int editStart = tokens.getEnd(token);
            Token last = first = tokens.getNextToken(token);
            while (this.isWhiteSpace(last.getType())) {
                last = tokens.getNextToken(last);
            }
            this.replaceFromTo(editStart, tokens.getOffset(last), replaceWith, edits);
        }
        catch (BadLocationException e) {
            Util.log(e);
        }
    }

    private boolean isWhiteSpace(int type) {
        return type == GroovyTokenTypeBridge.WS || type == GroovyTokenTypeBridge.NLS;
    }

    private boolean hasClosureElement(ListExpression node) {
        List<Expression> list = node.getExpressions();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ClosureExpression) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void combineClosures(MultiTextEdit edits) throws BadLocationException {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ClosuresInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode node : scanner.getMatchedNodes().keySet()) {
            ClosureExpression clExp = (ClosureExpression)node;
            int posClStart = this.formatter.getPosOfToken(GroovyTokenTypeBridge.LCURLY, clExp.getLineNumber(), clExp.getColumnNumber(), "{");
            if (posClStart == -1) continue;
            int posCLEnd = this.formatter.getPosOfToken(GroovyTokenTypeBridge.RCURLY, clExp.getLastLineNumber(), clExp.getLastColumnNumber() - 1, "}");
            if (posCLEnd == -1) {
                int positionLastTokenOfClosure = this.formatter.getPosOfToken(clExp.getLastLineNumber(), clExp.getLastColumnNumber());
                while (this.formatter.getTokens().get(positionLastTokenOfClosure).getType() != GroovyTokenTypeBridge.RCURLY) {
                    --positionLastTokenOfClosure;
                }
                posCLEnd = positionLastTokenOfClosure;
            }
            if (clExp.getLineNumber() == clExp.getLastLineNumber()) {
                this.ignoreToken.add(this.formatter.getTokens().get(posCLEnd));
                continue;
            }
            if (!(clExp.getCode() instanceof BlockStatement)) continue;
            BlockStatement codeblock = (BlockStatement)clExp.getCode();
            int posParamDelim = posClStart;
            if (clExp.getParameters() != null && clExp.getParameters().length > 0) {
                posParamDelim = this.formatter.getPosOfNextTokenOfType(posClStart, GroovyTokenTypeBridge.CLOSABLE_BLOCK_OP);
                this.replaceNLSWithSpace(edits, posClStart, posParamDelim);
            }
            if (codeblock.getStatements().size() == 1 && posCLEnd - posClStart < 10) {
                this.replaceNLSWithSpace(edits, posParamDelim, posCLEnd);
                this.ignoreToken.add(this.formatter.getTokens().get(posCLEnd));
                continue;
            }
            if (posParamDelim > 0 && this.formatter.getNextTokenIncludingNLS(posParamDelim).getType() != GroovyTokenTypeBridge.NLS) {
                this.addEdit(new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posParamDelim)), this.formatter.getNewLine()), edits);
                continue;
            }
            if (posParamDelim != 0 || this.formatter.getNextTokenIncludingNLS(posClStart).getType() == GroovyTokenTypeBridge.NLS) continue;
            this.addEdit(new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posClStart)), this.formatter.getNewLine()), edits);
        }
    }

    private void replaceNLSWithSpace(MultiTextEdit container, int startPos, int endPos) throws BadLocationException {
        Token token;
        Token fromToken = null;
        int p = startPos + 1;
        while (p < endPos) {
            token = this.formatter.getTokens().get(p);
            int ttype = token.getType();
            if (ttype == GroovyTokenTypeBridge.NLS) {
                if (fromToken == null) {
                    fromToken = token;
                }
            } else {
                if (ttype == GroovyTokenTypeBridge.SL_COMMENT) {
                    ++p;
                }
                if (fromToken != null) {
                    this.replaceFromTo(fromToken, token, " ", container);
                    fromToken = null;
                }
            }
            ++p;
        }
        if (fromToken != null) {
            token = this.formatter.getTokens().get(p);
            this.replaceFromTo(fromToken, token, " ", container);
        }
    }

    private void replaceFromTo(Token fromToken, Token toToken, String with, MultiTextEdit container) throws BadLocationException {
        int startEdit = this.formatter.getOffsetOfToken(fromToken);
        int endEdit = this.formatter.getOffsetOfToken(toToken);
        this.addEdit(new ReplaceEdit(startEdit, endEdit - startEdit, with), container);
    }

    private void replaceFromTo(int startEdit, int endEdit, String with, MultiTextEdit container) {
        this.addEdit(new ReplaceEdit(startEdit, endEdit - startEdit, with), container);
    }

    private void correctBraces(MultiTextEdit edits) throws BadLocationException {
        CorrectLineWrap lCurlyCorrector = null;
        CorrectLineWrap rCurlyCorrector = null;
        if (this.preferences.getBracesStart() == 0) {
            lCurlyCorrector = new SameLine(this);
        } else if (this.preferences.getBracesStart() == 1) {
            lCurlyCorrector = new NextLine(this);
        }
        if (this.preferences.getBracesEnd() == 0) {
            rCurlyCorrector = new SameLine(this);
        } else if (this.preferences.getBracesEnd() == 1) {
            rCurlyCorrector = new NextLine(this);
        }
        assert (lCurlyCorrector != null);
        assert (rCurlyCorrector != null);
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        assert (tokens != null);
        boolean skipNextNLS = false;
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.get(i);
            if (!this.ignoreToken.contains(token)) {
                int tokenType = token.getType();
                if (tokenType == GroovyTokenTypeBridge.LCURLY) {
                    if (skipNextNLS) {
                        skipNextNLS = false;
                        break;
                    }
                    ClosureExpression maybeClosure = this.formatter.findCorrespondingClosure(token);
                    if (maybeClosure == null || maybeClosure.getLineNumber() != maybeClosure.getLastLineNumber()) {
                        int type;
                        Token nextToken;
                        this.addEdit(lCurlyCorrector.correctLineWrap(i, token), edits);
                        ASTNode node = this.formatter.findCorrespondingNode(token);
                        if ((node == null || !(node instanceof ClosureExpression) && !(node instanceof ArgumentListExpression)) && (nextToken = tokens.getNextToken(token)) != null && (type = nextToken.getType()) != GroovyTokenTypeBridge.NLS && type != GroovyTokenTypeBridge.RCURLY) {
                            int start = tokens.getEnd(token);
                            int end = tokens.getOffset(nextToken);
                            this.addEdit(new ReplaceEdit(start, end - start, this.formatter.getNewLine()), edits);
                        }
                    }
                } else if (tokenType == GroovyTokenTypeBridge.RCURLY) {
                    if (skipNextNLS) {
                        skipNextNLS = false;
                    } else {
                        Token previousToken = tokens.getLastTokenBefore(token);
                        if (previousToken.getType() != GroovyTokenTypeBridge.LCURLY) {
                            this.addEdit(rCurlyCorrector.correctLineWrap(i, token), edits);
                        }
                    }
                } else if (tokenType != GroovyTokenTypeBridge.NLS && tokenType == GroovyTokenTypeBridge.SL_COMMENT) {
                    skipNextNLS = true;
                }
            }
            ++i;
        }
    }

    private void removeUnnecessarySemicolons(MultiTextEdit edits) throws BadLocationException {
        if (this.preferences.isRemoveUnnecessarySemicolons()) {
            SemicolonRemover semicolonRemover = new SemicolonRemover(this.formatter.selection, this.formatter.document, edits);
            ((GroovyFormatter)semicolonRemover).format();
        }
    }

    private void addEdit(TextEdit edit, TextEdit container) {
        if (edit != null && edit.getOffset() >= this.formatter.formatOffset && edit.getOffset() + edit.getLength() <= this.formatter.formatOffset + this.formatter.formatLength) {
            try {
                container.addChild(edit);
            }
            catch (MalformedTreeException malformedTreeException) {
                // empty catch block
            }
        }
    }
}

