/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.ResolveVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportResolver {
    public static String getResolvedClassName(ModuleNode root, ClassNode classType, boolean defaultImports) {
        String alias = ImportResolver.asAlias(root, classType);
        if (alias.equals("")) {
            ImportNode found = ImportResolver.findImportNodeForClass(classType, root.getImports());
            if (found != null) {
                return found.getType().getNameWithoutPackage();
            }
            found = ImportResolver.findImportNodeForClass(classType, root.getStaticStarImports().values());
            if (found != null) {
                return found.getType().getNameWithoutPackage();
            }
            found = ImportResolver.findImportNodeForClass(classType, root.getStaticImports().values());
            if (found != null) {
                return found.getType().getNameWithoutPackage();
            }
            String packageNameWithDot = String.valueOf(classType.getPackageName()) + ".";
            if (root.hasPackageName() && root.getPackageName().equals(packageNameWithDot)) {
                return classType.getNameWithoutPackage();
            }
            List<ImportNode> packageImports = root.getStarImports();
            for (ImportNode imp : packageImports) {
                if (!imp.getPackageName().equals(packageNameWithDot)) continue;
                return classType.getNameWithoutPackage();
            }
            if (defaultImports) {
                String[] stringArray = ResolveVisitor.DEFAULT_IMPORTS;
                int n = ResolveVisitor.DEFAULT_IMPORTS.length;
                int n2 = 0;
                while (n2 < n) {
                    String packageName = stringArray[n2];
                    if (packageName.equals(packageNameWithDot)) {
                        return classType.getNameWithoutPackage();
                    }
                    ++n2;
                }
                if (classType.equals(ClassHelper.BigDecimal_TYPE)) {
                    return classType.getNameWithoutPackage();
                }
                if (classType.equals(ClassHelper.BigInteger_TYPE)) {
                    return classType.getNameWithoutPackage();
                }
            }
            return classType.getName();
        }
        return alias;
    }

    private static ImportNode findImportNodeForClass(ClassNode toFind, Collection<ImportNode> imports) {
        for (ImportNode imp : imports) {
            if (imp.getType() == null || !imp.getType().getName().equals(toFind.getName())) continue;
            return imp;
        }
        return null;
    }

    public static String asAlias(ModuleNode root, ClassNode type) {
        ImportNode imp = ImportResolver.findImportNodeForClass(type, root.getImports());
        if (imp != null && ImportResolver.isExplicitAlias(imp)) {
            return imp.getAlias();
        }
        return "";
    }

    public static boolean isExplicitAlias(ImportNode importNode) {
        return !importNode.getType().getNameWithoutPackage().equals(importNode.getAlias());
    }

    public static String asFieldName(ModuleNode root, ClassNode type, String possibleField) {
        ImportNode imp = root.getStaticImports().get(possibleField);
        if (imp != null && imp.getType() != null && imp.getType().getName().equals(type.getName())) {
            return possibleField;
        }
        imp = ImportResolver.findImportNodeForClass(type, root.getStaticStarImports().values());
        if (imp != null) {
            return possibleField;
        }
        return "";
    }
}

