/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import groovy.lang.IntRange;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePartReader {
    public static final String DEFAULT_LINE_DELIMITER = System.getProperty("line.separator");

    private static List<String> getWords(String line, IntRange range) {
        String relevantPieceOfLine = StringGroovyMethods.getAt(line, range);
        relevantPieceOfLine = relevantPieceOfLine.replaceAll("\\(", " ( ");
        relevantPieceOfLine = relevantPieceOfLine.replaceAll("\\)", " ) ");
        return StringGroovyMethods.tokenize(relevantPieceOfLine);
    }

    public static String readBackwardsFromCoordinate(IDocument doc, LineColumn coord) throws BadLocationException {
        if (doc != null && coord.getLine() > 0 && coord.getColumn() > 0) {
            int lineLength = doc.getLineLength(coord.getLine() - 1);
            int offset = doc.getLineOffset(coord.getLine() - 1);
            String line = doc.get(offset, lineLength);
            List<String> words = FilePartReader.getWords(line, new IntRange(0, coord.getColumn() - 2));
            return words.get(words.size() - 1);
        }
        return " ";
    }

    public static String readForwardFromCoordinate(IDocument doc, LineColumn coord) throws BadLocationException {
        if (doc != null && coord.getLine() > 0 && coord.getColumn() > 0) {
            int lineLength = doc.getLineLength(coord.getLine() - 1);
            int offset = doc.getLineOffset(coord.getLine() - 1);
            String line = doc.get(offset, lineLength);
            List<String> words = FilePartReader.getWords(line, new IntRange(coord.getColumn() - 1, line.length()));
            return words.get(0);
        }
        return " ";
    }

    public static String getLineDelimiter(FileReader file) throws IOException {
        char[] content = IOGroovyMethods.getText(file).toCharArray();
        String lineDelimiter = DEFAULT_LINE_DELIMITER;
        int index = 0;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char currentChar = cArray[n2];
            if (currentChar == '\r') {
                if (content[index + 1] == '\n') {
                    lineDelimiter = "\r\n";
                    break;
                }
                lineDelimiter = "\r";
                break;
            }
            if (currentChar == '\n') {
                lineDelimiter = "\n";
                break;
            }
            ++index;
            ++n2;
        }
        return lineDelimiter;
    }
}

