/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementFinder
extends CodeVisitorSupport {
    private List<Statement> inSelection;
    private List<Statement> postSelection;
    private AnnotatedNode actualSelectedDeclaration;
    private AnnotatedNode currentDeclaration;
    private final Region selection;
    private final ModuleNode rootNode;
    boolean preCode = true;
    boolean isInLoopOrClosure = false;
    boolean internalInLoopOrClosure = false;

    public StatementFinder(Region selection, ModuleNode rootNode) {
        this.selection = selection;
        this.rootNode = rootNode;
        this.scanDocument();
    }

    public boolean isStatic() {
        return this.actualSelectedDeclaration instanceof MethodNode ? ((MethodNode)this.actualSelectedDeclaration).isStatic() : ((FieldNode)this.actualSelectedDeclaration).isStatic();
    }

    public boolean isInConstructor() {
        return this.actualSelectedDeclaration instanceof MethodNode && ((MethodNode)this.actualSelectedDeclaration).getName().equals("<init>");
    }

    public boolean isInLoopOrClosure() {
        return this.isInLoopOrClosure;
    }

    public List<Statement> getInSelection() {
        return this.inSelection;
    }

    public List<Statement> getPostSelection() {
        return this.postSelection;
    }

    public AnnotatedNode getSelectedDeclaration() {
        return this.actualSelectedDeclaration;
    }

    public List<String> getMethodNames() {
        ArrayList<String> methods = new ArrayList<String>();
        if (this.actualSelectedDeclaration != null) {
            ClassNode declaringClass = this.actualSelectedDeclaration.getDeclaringClass();
            for (MethodNode method : declaringClass.getMethods()) {
                methods.add(method.getName());
            }
        }
        return methods;
    }

    public String getClassName() {
        ClassNode declaringClass = this.actualSelectedDeclaration.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass.getNameWithoutPackage();
        }
        return "";
    }

    public ClassNode getClassNode() {
        return this.actualSelectedDeclaration.getDeclaringClass();
    }

    public void scanDocument() {
        this.inSelection = new ArrayList<Statement>();
        this.postSelection = new ArrayList<Statement>();
        if (this.rootNode != null) {
            for (ClassNode cl : this.rootNode.getClasses()) {
                for (ConstructorNode constructorNode : cl.getDeclaredConstructors()) {
                    this.scanMethod(cl, constructorNode);
                }
                for (MethodNode methodNode : cl.getMethods()) {
                    this.scanMethod(cl, methodNode);
                }
                for (FieldNode fieldNode : cl.getFields()) {
                    this.scanField(cl, fieldNode);
                }
            }
        }
    }

    private void scanField(ClassNode cl, FieldNode field) {
        Statement closureBlock;
        if (this.testSelection(this.selection, field, SelectionTestKind.SELECTION_IS_COVERED_BY) && field.getInitialExpression() instanceof ClosureExpression && (closureBlock = ((ClosureExpression)field.getInitialExpression()).getCode()) instanceof BlockStatement) {
            this.currentDeclaration = field;
            this.visitBlockStatement((BlockStatement)closureBlock);
        }
    }

    private void scanMethod(ClassNode cl, MethodNode method) {
        if (this.testSelection(this.selection, method, SelectionTestKind.SELECTION_IS_COVERED_BY) && method.getCode() instanceof BlockStatement) {
            this.currentDeclaration = method;
            this.visitBlockStatement((BlockStatement)method.getCode());
        }
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        for (Statement statement : block.getStatements()) {
            if (this.testSelection(this.selection, statement, SelectionTestKind.SELECTION_COVERS)) {
                this.inSelection.add(statement);
                if (this.internalInLoopOrClosure) {
                    this.isInLoopOrClosure = true;
                }
                this.preCode = false;
                this.actualSelectedDeclaration = this.currentDeclaration;
                continue;
            }
            if (this.preCode) {
                if (!this.testSelection(this.selection, statement, SelectionTestKind.SELECTION_IS_COVERED_BY)) continue;
                statement.visit(this);
                continue;
            }
            this.postSelection.add(0, statement);
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        boolean oldInLoop = this.internalInLoopOrClosure;
        this.internalInLoopOrClosure = true;
        super.visitForLoop(forLoop);
        this.internalInLoopOrClosure = oldInLoop;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        boolean oldInLoop = this.internalInLoopOrClosure;
        this.internalInLoopOrClosure = true;
        super.visitWhileLoop(loop);
        this.internalInLoopOrClosure = oldInLoop;
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop) {
        boolean oldInLoop = this.internalInLoopOrClosure;
        this.internalInLoopOrClosure = true;
        super.visitDoWhileLoop(loop);
        this.internalInLoopOrClosure = oldInLoop;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        boolean oldInLoop = this.internalInLoopOrClosure;
        this.internalInLoopOrClosure = true;
        super.visitClosureExpression(expression);
        this.internalInLoopOrClosure = oldInLoop;
    }

    private boolean testSelection(Region sel, ASTNode astNode, SelectionTestKind inSelection) {
        if (sel.isEmpty()) {
            return false;
        }
        ASTNode node = astNode;
        if (!ASTTools.hasValidPosition(node) && node instanceof ReturnStatement) {
            node = ((ReturnStatement)node).getExpression();
        }
        if (inSelection == SelectionTestKind.SELECTION_COVERS) {
            return sel.regionCoversNode(node);
        }
        return sel.regionIsCoveredByNode(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionTestKind {
        SELECTION_COVERS,
        SELECTION_IS_COVERED_BY;

    }
}

