/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.GroovySnippetParser;
import org.codehaus.groovy.eclipse.refactoring.Activator;
import org.codehaus.groovy.eclipse.refactoring.core.extract.ASTVariableScanner;
import org.codehaus.groovy.eclipse.refactoring.core.extract.ExtractConstructorTest;
import org.codehaus.groovy.eclipse.refactoring.core.extract.InferParameterAndReturnTypesRequestor;
import org.codehaus.groovy.eclipse.refactoring.core.extract.StatementFinder;
import org.codehaus.groovy.eclipse.refactoring.core.extract.VariableRenamer;
import org.codehaus.groovy.eclipse.refactoring.core.rewriter.ASTWriter;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.ui.extract.GroovyRefactoringMessages;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractGroovyMethodRefactoring
extends Refactoring {
    private GroovyRefactoringObservable observable = new GroovyRefactoringObservable();
    private String newMethodName = "";
    private MethodNode newMethod;
    private BlockStatement block;
    private int newMethodModifier = 0;
    private Region replaceScope;
    private Region selectedText;
    private StatementFinder methodCodeFinder;
    private boolean returnMustBeDeclared = false;
    private List<Variable> actualParameters;
    private List<ClassNode> inferredTypeOfActualParameters;
    private List<Variable> originalParametersBeforeRename;
    private Set<Variable> returnParameters;
    private List<ClassNode> inferredReturnTypes;
    private Map<String, String> variablesToRename;
    protected IPreferenceStore refactoringPreferences;
    private GroovyCompilationUnit unit;
    private CompilationUnitChange change;

    public ExtractGroovyMethodRefactoring(GroovyCompilationUnit unit, int offset, int length, RefactoringStatus status) {
        this.refactoringPreferences = Activator.getDefault().getPreferenceStore();
        this.selectedText = new Region(offset, length);
        this.unit = unit;
        this.initializeExtractedStatements(status);
    }

    public ExtractGroovyMethodRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        status.merge(this.initialize(arguments));
        this.initializeExtractedStatements(status);
    }

    private void initializeExtractedStatements(RefactoringStatus status) {
        StatementFinder f;
        try {
            f = new StatementFinder(this.selectedText, this.unit.getModuleNode());
        }
        catch (Exception e) {
            status.addFatalError(e.getMessage(), (RefactoringStatusContext)this.createErrorContext());
            f = null;
        }
        this.methodCodeFinder = f;
        this.createBlockStatement();
        this.updateMethod();
        this.saveOriginalParameters();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        pm.beginTask("Checking initial conditions for extract method", 100);
        this.updateMethod();
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        status.merge(this.checkNrOfReturnValues(pm));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        status.merge(this.checkStatementSelection(pm));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        status.merge(this.checkExtractFromConstructor(pm));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        pm.done();
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus stat = new RefactoringStatus();
        stat.merge(this.checkDuplicateMethod(pm));
        this.change = new CompilationUnitChange(GroovyRefactoringMessages.ExtractMethodRefactoring, (ICompilationUnit)this.unit);
        this.change.setEdit((TextEdit)new MultiTextEdit());
        if (this.newMethod != null) {
            TextEditGroup group = new TextEditGroup("Replace existing code with call to new method", this.createMethodCallEdit());
            this.change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)this.change, group));
            this.change.addEdit(group.getTextEdits()[0]);
            group = new TextEditGroup("Declaration of extracted method", this.createMethodDeclarationEdit(stat));
            this.change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)this.change, group));
            this.change.addEdit(group.getTextEdits()[0]);
        }
        return stat;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public String getName() {
        return "Extract Groovy Method";
    }

    public void setPreferences(IPreferenceStore preferences) {
        this.refactoringPreferences = preferences;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String selection = arguments.getAttribute("selection");
        if (selection == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"selection"));
        }
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.valueOf(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.valueOf(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{selection, "selection"}));
        }
        this.selectedText = new Region(offset, length);
        String handle = arguments.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        }
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement((String)arguments.getProject(), (String)handle, (boolean)false);
        if (element == null || !element.exists() || element.getElementType() != 5 || !(element instanceof GroovyCompilationUnit)) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)this.getName(), (String)"org.eclipse.jdt.ui.extract.method");
        }
        this.unit = (GroovyCompilationUnit)element;
        String name = arguments.getAttribute("name");
        if (name == null || name.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
        }
        this.newMethodName = name;
        return new RefactoringStatus();
    }

    private void saveOriginalParameters() {
        this.originalParametersBeforeRename = new ArrayList<Variable>();
        if (this.newMethod != null && this.newMethod.getParameters() != null) {
            Parameter[] parameterArray = this.newMethod.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                this.originalParametersBeforeRename.add(p);
                ++n2;
            }
        }
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void setNewMethodname(String newMethodname) {
        this.newMethodName = newMethodname;
        this.updateMethod();
        this.observable.setChanged();
        this.observable.notifyObservers();
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    public void setModifier(int modifier) {
        this.newMethodModifier = modifier;
        this.updateMethod();
        this.observable.setChanged();
        this.observable.notifyObservers();
    }

    public int getModifier() {
        return this.newMethodModifier;
    }

    private void setCallAndMethHeadParameters(List<Variable> params) {
        this.actualParameters = params;
        this.inferredTypeOfActualParameters.clear();
        for (Variable variable : params) {
            this.inferredTypeOfActualParameters.add(variable.getType());
        }
        this.updateMethod();
    }

    public Parameter[] getCallAndMethHeadParameters() {
        Parameter[] params = new Parameter[this.actualParameters.size()];
        int i = 0;
        while (i < params.length) {
            Parameter tmpParam;
            Variable v = this.actualParameters.get(i);
            ClassNode t = this.inferredTypeOfActualParameters.get(i);
            params[i] = tmpParam = new Parameter(t, v.getName());
            ++i;
        }
        return params;
    }

    public String getMethodCall() {
        VariableExpression objExp = new VariableExpression("this");
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Variable param : this.originalParametersBeforeRename) {
            arguments.addExpression(new VariableExpression(param.getName(), param.getOriginType() == null ? ClassHelper.DYNAMIC_TYPE : param.getOriginType()));
        }
        MethodCallExpression newMethodCall = new MethodCallExpression((Expression)objExp, this.newMethodName, (Expression)arguments);
        ASTWriter writer = new ASTWriter(this.unit.getModuleNode(), this.replaceScope.getOffset(), null);
        if (this.returnParameters.size() > 0) {
            this.visitExpressionsForReturnStmt(newMethodCall, writer);
        } else {
            writer.visitMethodCallExpression(newMethodCall);
        }
        return writer.getGroovyCode();
    }

    private void visitExpressionsForReturnStmt(MethodCallExpression newMethodCall, ASTWriter astw) {
        Assert.isTrue(this.returnParameters.size() > 0);
        Variable retVar = this.returnParameters.iterator().next();
        if (this.returnMustBeDeclared) {
            VariableExpression varExp = new VariableExpression(retVar);
            DeclarationExpression declarationExpression = new DeclarationExpression(varExp, Token.newSymbol(100, -1, -1), (Expression)newMethodCall);
            astw.visitDeclarationExpression(declarationExpression);
        } else {
            BinaryExpression binaryExpression = new BinaryExpression(new VariableExpression(retVar), Token.newSymbol(100, -1, -1), newMethodCall);
            astw.visitBinaryExpression(binaryExpression);
        }
    }

    public String getMethodHead() {
        this.updateMethod();
        ASTWriter astw = new ASTWriter(this.unit.getModuleNode(), null);
        astw.visitMethod(this.newMethod);
        String head = astw.getGroovyCode();
        int headEndPos = head.indexOf(")");
        return head.substring(0, headEndPos + 1).trim();
    }

    private void updateMethod() {
        if (this.block.getStatements().size() > 0) {
            Parameter[] params = this.getCallAndMethHeadParameters();
            ClassNode returnType = ClassHelper.DYNAMIC_TYPE;
            if (this.returnParameters.size() > 0 && (returnType = this.inferredReturnTypes.get(0)).equals(VariableScope.OBJECT_CLASS_NODE)) {
                returnType = ClassHelper.DYNAMIC_TYPE;
            }
            this.newMethod = new MethodNode(this.newMethodName, 0, returnType, params, null, this.block);
            this.checkStaticModifier();
        }
    }

    private void checkStaticModifier() {
        if (this.methodCodeFinder.isStatic()) {
            this.newMethod.setModifiers(this.newMethodModifier | 8);
        } else {
            this.newMethod.setModifiers(this.newMethodModifier);
        }
    }

    public boolean isStatic() {
        return this.methodCodeFinder.isStatic();
    }

    private void createBlockStatement() {
        this.block = new BlockStatement();
        this.block.addStatements(this.methodCodeFinder.getInSelection());
        this.replaceScope = ASTTools.getPositionOfBlockStatements(this.block);
        this.defineActualAndReturnParameters();
    }

    private void defineActualAndReturnParameters() {
        ASTVariableScanner scanner = new ASTVariableScanner(this.methodCodeFinder.isInLoopOrClosure());
        scanner.visitNode(this.block);
        ASTVariableScanner postSelectionScanner = new ASTVariableScanner(this.methodCodeFinder.isInLoopOrClosure());
        BlockStatement postBlock = new BlockStatement();
        postBlock.addStatements(this.methodCodeFinder.getPostSelection());
        postSelectionScanner.visitNode(postBlock);
        Set<Variable> postUsedVar = postSelectionScanner.getUsedVariables();
        Set<Variable> selReturnVar = scanner.getAssignedVariables();
        Set<Variable> innerLoopAssigned = scanner.getInnerLoopAssignedVariables();
        this.actualParameters = new ArrayList<Variable>(scanner.getUsedVariables());
        this.inferredTypeOfActualParameters = new ArrayList<ClassNode>(this.actualParameters.size());
        this.returnParameters = new HashSet<Variable>();
        this.inferredReturnTypes = new ArrayList<ClassNode>();
        HashSet<Variable> assignedInBlockAndUsedAfterBlock = new HashSet<Variable>(postUsedVar);
        assignedInBlockAndUsedAfterBlock.retainAll(selReturnVar);
        this.returnParameters.addAll(assignedInBlockAndUsedAfterBlock);
        this.returnParameters.addAll(innerLoopAssigned);
        for (Variable variable : this.returnParameters) {
            if (!postUsedVar.contains(variable) || !scanner.getDeclaratedVariables().contains(variable)) continue;
            this.returnMustBeDeclared = true;
            break;
        }
        InferParameterAndReturnTypesRequestor inferRequestor = new InferParameterAndReturnTypesRequestor(this.actualParameters, this.returnParameters, this.selectedText);
        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.unit);
        visitor.visitCompilationUnit(inferRequestor);
        Map<Variable, ClassNode> inferredTypes = inferRequestor.getInferredTypes();
        for (Variable variable : this.actualParameters) {
            if (inferredTypes.containsKey(variable)) {
                ClassNode type = inferredTypes.get(variable);
                if (type == null || VariableScope.isVoidOrObject(type)) {
                    this.inferredTypeOfActualParameters.add(ClassHelper.DYNAMIC_TYPE);
                    continue;
                }
                this.inferredTypeOfActualParameters.add(this.maybeConvertToPrimitiveType(type));
                continue;
            }
            this.inferredTypeOfActualParameters.add(ClassHelper.DYNAMIC_TYPE);
        }
        for (Variable variable : this.returnParameters) {
            if (inferredTypes.containsKey(variable)) {
                this.inferredReturnTypes.add(this.maybeConvertToPrimitiveType(inferredTypes.get(variable)));
                continue;
            }
            this.inferredReturnTypes.add(variable.getOriginType());
        }
    }

    private ClassNode maybeConvertToPrimitiveType(ClassNode type) {
        return ClassHelper.getUnwrapper(type).getPlainNodeReference();
    }

    private RefactoringStatus checkDuplicateMethod(IProgressMonitor pm) {
        SubProgressMonitor sub = new SubProgressMonitor(pm, 25);
        sub.beginTask("Checking for duplicate methods", 25);
        RefactoringStatus stat = new RefactoringStatus();
        if (this.getMethodNames().contains(this.newMethodName)) {
            Object[] message = new Object[]{this.newMethodName, this.getClassName()};
            String messageString = MessageFormat.format(GroovyRefactoringMessages.ExtractMethodWizard_MethodNameAlreadyExists, message);
            stat.addError(messageString);
        }
        sub.done();
        return stat;
    }

    private RefactoringStatus checkExtractFromConstructor(IProgressMonitor pm) {
        SubProgressMonitor sub = new SubProgressMonitor(pm, 25);
        sub.beginTask("Checking for constructor calls", 25);
        RefactoringStatus stat = new RefactoringStatus();
        if (this.methodCodeFinder.isInConstructor() && new ExtractConstructorTest().containsConstructorCall(this.newMethod)) {
            stat.addFatalError(GroovyRefactoringMessages.ExtractMethodInfo_NoExtractionOfConstructorCallinConstructor, (RefactoringStatusContext)this.createErrorContext());
        }
        sub.done();
        return stat;
    }

    private RefactoringStatus checkStatementSelection(IProgressMonitor pm) {
        SubProgressMonitor sub = new SubProgressMonitor(pm, 25);
        sub.beginTask("Checking statement selection", 25);
        RefactoringStatus stat = new RefactoringStatus();
        int selectionLength = this.selectedText.getLength();
        if (this.block.isEmpty() && selectionLength >= 0) {
            stat.addFatalError(GroovyRefactoringMessages.ExtractMethodInfo_NoStatementSelected, (RefactoringStatusContext)this.createErrorContext());
        }
        sub.done();
        return stat;
    }

    private RefactoringStatus checkNrOfReturnValues(IProgressMonitor pm) {
        SubProgressMonitor sub = new SubProgressMonitor(pm, 25);
        sub.beginTask("Checking number of return values", 25);
        RefactoringStatus stat = new RefactoringStatus();
        if (this.returnParameters != null && this.returnParameters.size() > 1) {
            StringBuilder retValues = new StringBuilder();
            for (Variable var : this.returnParameters) {
                retValues.append(String.valueOf(var.getType().getNameWithoutPackage()) + " " + var.getName() + "\n");
            }
            String errorMsg = String.valueOf(GroovyRefactoringMessages.ExtractMethodInfo_ToMuchReturnValues) + retValues.toString();
            stat.addFatalError(errorMsg, (RefactoringStatusContext)this.createErrorContext());
        }
        sub.done();
        return stat;
    }

    private String createCopiedMethodCode(RefactoringStatus status) {
        Document unitDocument = new Document(String.valueOf(this.unit.getContents()));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter(unitDocument);
        StringBuilder sb = new StringBuilder();
        try {
            FormatterPreferences formmatterPrefs = new FormatterPreferences(this.unit);
            int indentLevel = this.calculateIndentation();
            String indentation = CodeFormatterUtil.createIndentString((int)indentLevel, (IJavaProject)this.unit.getJavaProject());
            sb.append(String.valueOf(lineDelimiter) + lineDelimiter + indentation);
            sb.append(this.getMethodHead()).append(" {").append(lineDelimiter);
            String copyOfSourceCode = unitDocument.get(this.replaceScope.getOffset(), this.replaceScope.getLength());
            sb.append(copyOfSourceCode);
            sb.append(lineDelimiter);
            ASTWriter astw = this.writeReturnStatements(unitDocument);
            if (astw.getGroovyCode().length() > 0) {
                sb.append(astw.getGroovyCode());
            }
            sb.append("}");
            MethodNode newMethod = this.createNewMethodForValidation(sb.toString(), status);
            Document newMethodDocument = new Document(sb.toString());
            if (newMethod != null && this.variablesToRename != null) {
                MultiTextEdit edits = this.renameVariableInExtractedMethod(newMethod);
                edits.apply(newMethodDocument);
            }
            DefaultGroovyFormatter formatter = new DefaultGroovyFormatter(newMethodDocument, formmatterPrefs, indentLevel);
            formatter.format().apply(newMethodDocument);
            return newMethodDocument.get();
        }
        catch (BadLocationException e) {
            status.addFatalError("Problem when creating the body of the extracted method.\n" + e.getMessage(), (RefactoringStatusContext)this.createErrorContext());
            GroovyCore.logException("Problem when creating the body of the extracted method.", e);
            return sb.toString();
        }
    }

    private MethodNode createNewMethodForValidation(String methodText, RefactoringStatus status) {
        ModuleNode module;
        block3: {
            try {
                GroovySnippetParser parser = new GroovySnippetParser();
                module = parser.parse(methodText);
                if (module.getMethods() != null && module.getMethods().size() == 1) break block3;
                status.addError("Problem parsing extracted method", (RefactoringStatusContext)this.createErrorContext());
                if (module.getMethods() != null) break block3;
                return null;
            }
            catch (Exception e) {
                status.addError("Problem parsing extracted method.\n" + e.getMessage(), (RefactoringStatusContext)this.createErrorContext());
                return null;
            }
        }
        MethodNode method = module.getMethods().get(0);
        new VariableScopeVisitor(null).visitClass(method.getDeclaringClass());
        return method;
    }

    private FileStatusContext createErrorContext() {
        return new FileStatusContext((IFile)this.unit.getResource(), (IRegion)new org.eclipse.jface.text.Region(this.selectedText.getOffset(), this.selectedText.getLength()));
    }

    private int calculateIndentation() {
        int defaultIndentation;
        if (this.methodCodeFinder.getClassNode().isScript()) {
            defaultIndentation = 0;
        } else {
            int innerClassCount = 0;
            ClassNode current = this.methodCodeFinder.getClassNode();
            while (current != null) {
                ++innerClassCount;
                if (current.getEnclosingMethod() != null) {
                    ++innerClassCount;
                    current = current.getEnclosingMethod().getDeclaringClass();
                    continue;
                }
                current = current.getDeclaringClass();
            }
            defaultIndentation = innerClassCount;
        }
        return defaultIndentation;
    }

    private MultiTextEdit renameVariableInExtractedMethod(MethodNode method) {
        VariableRenamer renamer = new VariableRenamer();
        return renamer.rename(method, this.variablesToRename);
    }

    private ASTWriter writeReturnStatements(IDocument document) {
        ASTWriter astw = new ASTWriter(this.unit.getModuleNode(), document);
        for (Variable var : this.returnParameters) {
            ReturnStatement ret = new ReturnStatement(new VariableExpression(var));
            astw.visitReturnStatement(ret);
            astw.insertLineFeed();
        }
        return astw;
    }

    private InsertEdit createMethodDeclarationEdit(RefactoringStatus status) {
        String newMethodCode = this.createCopiedMethodCode(status);
        return new InsertEdit(this.methodCodeFinder.getSelectedDeclaration().getEnd(), newMethodCode);
    }

    private ReplaceEdit createMethodCallEdit() {
        int offset = this.replaceScope.getOffset();
        int length = this.replaceScope.getLength();
        ReplaceEdit insertMethodCall = new ReplaceEdit(offset, length, this.getMethodCall());
        return insertMethodCall;
    }

    public List<String> getMethodNames() {
        return this.methodCodeFinder.getMethodNames();
    }

    public String getClassName() {
        return this.methodCodeFinder.getClassName();
    }

    public int setMoveParameter(String variName, boolean upEvent, int numberOfMoves) {
        Parameter[] originalParams = this.getCallAndMethHeadParameters();
        ArrayList<Variable> newParamList = new ArrayList<Variable>();
        int indexOfSelectedParam = -1;
        Parameter[] parameterArray = originalParams;
        int n = originalParams.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            newParamList.add(param);
            if (param.getName().equals(variName)) {
                indexOfSelectedParam = newParamList.indexOf(param);
            }
            ++n2;
        }
        indexOfSelectedParam = this.reorderParameters(upEvent, numberOfMoves, newParamList, indexOfSelectedParam);
        this.setCallAndMethHeadParameters(newParamList);
        return indexOfSelectedParam;
    }

    private int reorderParameters(boolean upEvent, int numberOfMoves, List<Variable> newParamList, int index) {
        int indexOfSelectedParam = index;
        Variable variToMove = newParamList.remove(indexOfSelectedParam);
        Variable originalToMove = this.originalParametersBeforeRename.remove(indexOfSelectedParam);
        indexOfSelectedParam = this.calculateNewIndexAfterMove(upEvent, numberOfMoves, newParamList, indexOfSelectedParam);
        newParamList.add(indexOfSelectedParam, variToMove);
        this.originalParametersBeforeRename.add(indexOfSelectedParam, originalToMove);
        return indexOfSelectedParam;
    }

    private int calculateNewIndexAfterMove(boolean upEvent, int numberOfMoves, List<Variable> newParamList, int index) {
        int indexOfSelectedParam = index;
        indexOfSelectedParam = upEvent ? (indexOfSelectedParam < 1 ? 0 : (indexOfSelectedParam -= numberOfMoves)) : (indexOfSelectedParam > newParamList.size() - 1 ? newParamList.size() - 1 : (indexOfSelectedParam += numberOfMoves));
        return indexOfSelectedParam;
    }

    public void setParameterRename(Map<String, String> variablesToRename) {
        this.variablesToRename = variablesToRename;
        ArrayList<Variable> newParamList = new ArrayList<Variable>();
        for (Variable param : this.originalParametersBeforeRename) {
            if (variablesToRename.containsKey(param.getName())) {
                newParamList.add(new Parameter(param.getOriginType(), variablesToRename.get(param.getName())));
                continue;
            }
            newParamList.add(param);
        }
        this.setCallAndMethHeadParameters(newParamList);
        this.observable.setChanged();
        this.observable.notifyObservers();
    }

    public String getOriginalParameterName(int selectionIndex) {
        return this.originalParametersBeforeRename.get(selectionIndex).getName();
    }

    private class GroovyRefactoringObservable
    extends Observable {
        private GroovyRefactoringObservable() {
        }

        protected synchronized void setChanged() {
            super.setChanged();
        }

        public void notifyObservers(Object arg) {
            super.notifyObservers(arg);
            this.clearChanged();
        }
    }
}

