/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertGroovyLocalToFieldRefactoring
extends PromoteTempToFieldRefactoring {
    private GroovyCompilationUnit unit;
    private String fieldName;
    private int fieldVisibility = -1;
    private int selectionStart;
    private int selectionLength;
    private IASTFragment selectionFragment;
    private VariableExpression variableExpressionInDeclaration;
    private DeclarationExpression declarationExpression;
    private ClassNode containingClassNode;
    private ModuleNode moduleNode;
    private MethodNode methodNode;
    private CompilationUnitChange change;

    public ConvertGroovyLocalToFieldRefactoring(GroovyCompilationUnit unit, int selectionStart, int selectionLength) {
        super((ICompilationUnit)unit, selectionStart, selectionLength);
        this.unit = unit;
        this.selectionStart = selectionStart;
        this.selectionLength = selectionLength;
    }

    public int getVisibility() {
        if (this.fieldVisibility == -1) {
            this.fieldVisibility = (Integer)ReflectionUtils.getPrivateField(PromoteTempToFieldRefactoring.class, "fVisibility", (Object)this);
        }
        return this.fieldVisibility;
    }

    public boolean getDeclareFinal() {
        return false;
    }

    public boolean getDeclareStatic() {
        return false;
    }

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = (String)ReflectionUtils.getPrivateField(PromoteTempToFieldRefactoring.class, "fFieldName", (Object)this);
        }
        if ((this.fieldName == null || this.fieldName.length() == 0) && this.variableExpressionInDeclaration != null) {
            this.fieldName = this.variableExpressionInDeclaration.getName();
        }
        return this.fieldName;
    }

    public int getInitializeIn() {
        return 1;
    }

    public void setVisibility(int accessModifier) {
        super.setVisibility(accessModifier);
        this.fieldVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
    }

    public void setDeclareStatic(boolean declareStatic) {
    }

    public void setFieldName(String fieldName) {
        super.setFieldName(fieldName);
        this.fieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
    }

    public boolean canEnableSettingStatic() {
        return false;
    }

    public boolean canEnableSettingFinal() {
        return false;
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return false;
    }

    public boolean canEnableSettingDeclareInMethod() {
        return true;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return false;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 5);
            RefactoringStatus result = Checks.validateEdit((ICompilationUnit)this.unit, (Object)this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            IASTFragment selectionFragment = this.getSelectionFragment();
            if (selectionFragment == null) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            Expression selectedExpression = selectionFragment.getAssociatedExpression();
            if (!(selectedExpression instanceof VariableExpression)) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            VariableExpression selectedVariableExpression = (VariableExpression)selectedExpression;
            Variable declaredVariable = selectedVariableExpression.getAccessedVariable();
            if (declaredVariable instanceof DynamicVariable) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot convert dynamic variable."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (!(declaredVariable instanceof VariableExpression)) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            VariableExpression variableExpressionInDeclaration = (VariableExpression)declaredVariable;
            DeclarationExpression declarationExpression = this.getDeclarationExpression(variableExpressionInDeclaration);
            if (declarationExpression == null) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot find variable declaration."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (declarationExpression.isMultipleAssignmentDeclaration()) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot convert a variable declared using multiple assignment."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            this.variableExpressionInDeclaration = variableExpressionInDeclaration;
            ClassNode containingClassNode = this.getContainingClassNode();
            if (containingClassNode == null) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot find enclosing class declaration."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (containingClassNode.isScript()) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot add field to a script."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (containingClassNode.isInterface() || containingClassNode.isAnnotationDefinition()) {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot add field to an interface or annotation definition."));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public String[] guessFieldNames() {
        return new String[]{this.variableExpressionInDeclaration.getName()};
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            TextEdit edit;
            pm.beginTask("", 4);
            FieldNode conflictingField = this.getContainingClassNode().getDeclaredField(this.getFieldName());
            if (conflictingField != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field);
                return refactoringStatus;
            }
            pm.worked(1);
            CompilationUnitChange change = new CompilationUnitChange("Convert Groovy Local Variable To Field", (ICompilationUnit)this.unit);
            change.setEdit((TextEdit)new MultiTextEdit());
            TextEditGroup group = this.createFieldTextEditGroup();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            TextEdit[] textEditArray = group.getTextEdits();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            pm.worked(1);
            group = this.declarationToReferenceTextEditGroup();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            textEditArray = group.getTextEdits();
            n = textEditArray.length;
            n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            pm.worked(1);
            RefactoringStatus status = new RefactoringStatus();
            group = this.renameVariableReferencesTextEditGroup(status);
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            TextEdit[] textEditArray2 = group.getTextEdits();
            int n3 = textEditArray2.length;
            n = 0;
            while (n < n3) {
                TextEdit edit2 = textEditArray2[n];
                change.addEdit(edit2);
                ++n;
            }
            pm.worked(1);
            this.change = change;
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private TextEditGroup createFieldTextEditGroup() {
        ClassNode classNode = this.getContainingClassNode();
        char[] contents = this.unit.getContents();
        MethodNode method = this.getContainingMethodNode();
        int methodLineOffset = method.getStart() - method.getColumnNumber() + 1;
        int methodOffset = method.getStart();
        String methodIndentation = String.valueOf(CharOperation.subarray(contents, methodLineOffset, methodOffset));
        int indentLevel = ASTTools.getCurrentIntentation(methodIndentation);
        String fieldText = null;
        try {
            fieldText = this.createFieldText(indentLevel);
        }
        catch (Exception exception) {}
        TextEditGroup group = new TextEditGroup("Create field.");
        if (fieldText != null) {
            int insertOffset = CharOperation.indexOf('{', contents, classNode.getStart()) + 1;
            String newline = TextUtilities.determineLineDelimiter(String.valueOf(contents), "\n");
            group.addTextEdit(new InsertEdit(insertOffset, String.valueOf(newline) + fieldText));
        }
        return group;
    }

    private String createFieldText(int indentLevel) throws MalformedTreeException, BadLocationException {
        StringBuilder sb = new StringBuilder();
        String indentation = CodeFormatterUtil.createIndentString((int)indentLevel, (IJavaProject)this.unit.getJavaProject());
        sb.append(indentation);
        String visibility = JdtFlags.getVisibilityString((int)this.getVisibility());
        sb.append(visibility);
        if (!visibility.equals("")) {
            sb.append(" ");
        }
        char[] contents = this.unit.getContents();
        String typeOrDef = new String(CharOperation.subarray(contents, this.declarationExpression.getStart(), this.variableExpressionInDeclaration.getStart()));
        sb.append(typeOrDef).append(this.getFieldName());
        Document doc = new Document(sb.toString());
        DefaultGroovyFormatter formatter = new DefaultGroovyFormatter(doc, new FormatterPreferences(this.unit), indentLevel);
        TextEdit edit = formatter.format();
        edit.apply(doc);
        return doc.get();
    }

    private TextEditGroup declarationToReferenceTextEditGroup() {
        TextEditGroup group = new TextEditGroup("Convert local variable declaration to reference.");
        int typeOrDefLength = this.variableExpressionInDeclaration.getStart() - this.declarationExpression.getStart();
        group.addTextEdit(new ReplaceEdit(this.declarationExpression.getStart(), typeOrDefLength, ""));
        return group;
    }

    private TextEditGroup renameVariableReferencesTextEditGroup(RefactoringStatus status) {
        final HashSet references = new HashSet();
        ClassCodeVisitorSupport referencesVisitor = new ClassCodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression variableExpression) {
                if (variableExpression.getAccessedVariable() == ConvertGroovyLocalToFieldRefactoring.this.variableExpressionInDeclaration && variableExpression.getLineNumber() >= 0) {
                    references.add(variableExpression);
                }
            }

            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
        referencesVisitor.visitClass(this.getContainingClassNode());
        Iterator<InnerClassNode> innerClasses = this.getContainingClassNode().getInnerClasses();
        while (innerClasses != null && innerClasses.hasNext()) {
            ClassNode innerClass = innerClasses.next();
            referencesVisitor.visitClass(innerClass);
        }
        TextEditGroup group = new TextEditGroup("Update local variables to reference field.");
        for (VariableExpression reference : references) {
            if (this.getUsedVariableAndFieldNames(reference).contains(this.getFieldName())) {
                status.merge(RefactoringStatus.createWarningStatus((String)"New field conflicts with existing name."));
            }
            group.addTextEdit(new ReplaceEdit(reference.getStart(), reference.getLength(), this.getFieldName()));
        }
        return group;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        return this.change;
    }

    private IASTFragment getSelectionFragment() {
        if (this.selectionFragment == null) {
            this.selectionFragment = ASTTools.getSelectionFragment(this.getModuleNode(), this.selectionStart, this.selectionLength);
        }
        return this.selectionFragment;
    }

    private ClassNode getContainingClassNode() {
        if (this.containingClassNode == null) {
            ModuleNode moduleNode = this.getModuleNode();
            if (moduleNode == null) {
                return null;
            }
            if (this.declarationExpression == null) {
                return null;
            }
            this.containingClassNode = ASTTools.getContainingClassNode(moduleNode, this.declarationExpression.getStart());
        }
        return this.containingClassNode;
    }

    private ModuleNode getModuleNode() {
        if (this.moduleNode == null) {
            this.moduleNode = this.unit.getModuleNode();
        }
        return this.moduleNode;
    }

    private DeclarationExpression getDeclarationExpression(final VariableExpression variableExpressionInDeclaration) {
        if (this.declarationExpression != null) {
            return this.declarationExpression;
        }
        ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

            public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
                ConvertGroovyLocalToFieldRefactoring.this.declarationExpression = declarationExpression;
                super.visitDeclarationExpression(declarationExpression);
            }

            public void visitVariableExpression(VariableExpression variableExpression) {
                if (variableExpression == variableExpressionInDeclaration) {
                    throw new VisitCompleteException();
                }
                super.visitVariableExpression(variableExpression);
            }

            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
        for (ClassNode classNode : this.getModuleNode().getClasses()) {
            try {
                visitor.visitClass(classNode);
            }
            catch (VisitCompleteException visitCompleteException) {
                break;
            }
            this.declarationExpression = null;
        }
        return this.declarationExpression;
    }

    private MethodNode getContainingMethodNode() {
        if (this.methodNode != null) {
            return this.methodNode;
        }
        ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

            public void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
                ConvertGroovyLocalToFieldRefactoring.this.methodNode = methodNode;
                super.visitConstructorOrMethod(methodNode, isConstructor);
            }

            public void visitVariableExpression(VariableExpression variableExpression) {
                if (variableExpression == ConvertGroovyLocalToFieldRefactoring.this.variableExpressionInDeclaration) {
                    throw new VisitCompleteException();
                }
                super.visitVariableExpression(variableExpression);
            }

            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
        for (ClassNode classNode : this.getModuleNode().getClasses()) {
            try {
                visitor.visitClass(classNode);
            }
            catch (VisitCompleteException visitCompleteException) {
                break;
            }
            this.methodNode = null;
        }
        return this.methodNode;
    }

    private Set<String> getUsedVariableAndFieldNames(VariableExpression variableExpression) {
        FindSurroundingNode find = new FindSurroundingNode(new Region((ASTNode)variableExpression), FindSurroundingNode.VisitKind.PARENT_STACK);
        find.doVisitSurroundingNode(this.moduleNode);
        ArrayList parentStack = new ArrayList(find.getParentStack());
        Collections.reverse(parentStack);
        HashSet<String> result = new HashSet<String>();
        for (IASTFragment fragment : parentStack) {
            ASTNode astNode = fragment.getAssociatedNode();
            VariableScope scope = null;
            if (astNode instanceof BlockStatement) {
                scope = ((BlockStatement)astNode).getVariableScope();
            } else if (astNode instanceof MethodNode) {
                scope = ((MethodNode)astNode).getVariableScope();
            } else if (astNode instanceof ClosureExpression) {
                scope = ((ClosureExpression)astNode).getVariableScope();
            } else if (astNode instanceof ClassNode) {
                for (FieldNode field : ((ClassNode)astNode).getFields()) {
                    if (field.getLineNumber() <= 0) continue;
                    result.add(field.getName());
                }
            }
            if (scope == null) continue;
            Iterator<Variable> declaredVariables = scope.getDeclaredVariablesIterator();
            while (declaredVariables.hasNext()) {
                Variable variable = declaredVariables.next();
                if (variable instanceof VariableExpression) {
                    VariableExpression varExpression = (VariableExpression)variable;
                    if (varExpression.getAccessedVariable() == variableExpression.getAccessedVariable()) continue;
                    result.add(variable.getName());
                    continue;
                }
                result.add(variable.getName());
            }
        }
        return result;
    }
}

