/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.convert;

import javax.swing.text.BadLocationException;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToClosureRefactoring {
    private final IMethod targetMethod;

    public ConvertToClosureRefactoring(GroovyCompilationUnit unit, int offset) {
        this.targetMethod = this.findMethod(unit, offset);
    }

    private IMethod findMethod(GroovyCompilationUnit unit, int offset) {
        IJavaElement maybeMethod;
        block6: {
            if (unit.isOnBuildPath()) {
                return null;
            }
            maybeMethod = unit.getElementAt(offset);
            if (maybeMethod instanceof IMethod) break block6;
            return null;
        }
        try {
            ISourceRange nameRange = ((IMethod)maybeMethod).getNameRange();
            if (nameRange.getLength() == maybeMethod.getElementName().length()) {
                return (IMethod)maybeMethod;
            }
            char[] contents = unit.getContents();
            if (contents.length > nameRange.getOffset() && contents[nameRange.getOffset()] == '\"') {
                return (IMethod)maybeMethod;
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Error finding enclosing method for refactoring", e);
        }
        return null;
    }

    public void applyRefactoring(IDocument document) {
        if (this.targetMethod != null) {
            TextEdit thisEdit = this.findReplacement(document, this.targetMethod);
            try {
                if (thisEdit != null) {
                    thisEdit.apply(document);
                }
            }
            catch (Exception e) {
                GroovyCore.logException("Oops.", e);
            }
        }
    }

    public boolean isApplicable() {
        return this.targetMethod != null && this.targetMethod.exists();
    }

    private TextEdit findReplacement(IDocument doc, IMethod targetMethod) {
        try {
            ISourceRange nameRange = targetMethod.getSourceRange();
            int openingParen = this.findOpenParen(doc, targetMethod, nameRange);
            int closingParen = this.findCloseParen(doc, openingParen);
            int openingBracket = this.findOpenBracket(doc, closingParen);
            return this.createEdit(doc, targetMethod, openingParen, closingParen, openingBracket);
        }
        catch (Exception e) {
            GroovyCore.logException("Exception during convert to closure.", e);
            return null;
        }
    }

    private int findOpenParen(IDocument doc, IMethod targetMethod, ISourceRange nameRange) throws BadLocationException, org.eclipse.jface.text.BadLocationException {
        int offset = nameRange.getOffset() + targetMethod.getElementName().length();
        while (offset < doc.getLength() && doc.getChar(offset) != '(') {
            ++offset;
        }
        return offset;
    }

    private int findOpenBracket(IDocument doc, int closingParen) throws BadLocationException, org.eclipse.jface.text.BadLocationException {
        int offset = closingParen;
        while (offset < doc.getLength() && doc.getChar(offset) != '{') {
            ++offset;
        }
        return offset;
    }

    private int findCloseParen(IDocument doc, int open) throws BadLocationException, org.eclipse.jface.text.BadLocationException {
        int offset = open;
        while (offset < doc.getLength() && doc.getChar(offset) != ')') {
            ++offset;
        }
        return offset;
    }

    private TextEdit createEdit(IDocument doc, IMethod targetMethod, int openingParen, int closingParen, int openingBracket) throws BadLocationException, org.eclipse.jface.text.BadLocationException {
        if (openingParen >= doc.getLength() || doc.getChar(openingParen) != '(') {
            return null;
        }
        if (closingParen >= doc.getLength() || doc.getChar(closingParen) != ')') {
            return null;
        }
        if (openingBracket >= doc.getLength() || doc.getChar(openingBracket) != '{') {
            return null;
        }
        MultiTextEdit edit = new MultiTextEdit();
        if (targetMethod.getParameterTypes().length > 0) {
            edit.addChild(new ReplaceEdit(openingParen, 1, " = { "));
            edit.addChild(new ReplaceEdit(closingParen, openingBracket - closingParen + 1, " ->"));
        } else {
            edit.addChild(new ReplaceEdit(openingParen, 1, " = {"));
            edit.addChild(new DeleteEdit(closingParen, openingBracket - closingParen + 1));
        }
        return edit;
    }
}

